/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.preferences;

import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.gmf.runtime.common.ui.preferences.CheckBoxFieldEditor;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;
import org.eclipse.papyrus.infra.gmfdiag.preferences.pages.AbstractPapyrusNodePreferencePage;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.AbstractGroup;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.BackgroundColor;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.DecorationGroup;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.LabelGroup;
import org.eclipse.papyrus.infra.gmfdiag.preferences.ui.NodeColorGroup;
import org.eclipse.papyrus.infra.ui.preferences.AbstractPreferenceGroup;
import org.eclipse.papyrus.uml.diagram.sequence.part.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CustomCombinedFragmentPreferencePage
extends AbstractPapyrusNodePreferencePage {
    public static final String[] compartments = new String[]{Messages.CombinedFragmentCombinedFragmentCompartmentEditPart_title};

    public static void initDefaults(IPreferenceStore store) {
        String key = "PapyrusUMLSequenceDiagram_CombinedFragment";
        store.setDefault(PreferencesConstantsHelper.getElementConstant((String)key, (int)17), 40);
        store.setDefault(PreferencesConstantsHelper.getElementConstant((String)key, (int)16), 40);
        String[] stringArray = compartments;
        int n = compartments.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            String preferenceName = PreferencesConstantsHelper.getCompartmentElementConstant((String)key, (String)name, (int)18);
            store.setDefault(preferenceName, true);
            ++n2;
        }
    }

    protected TreeMap<String, Boolean> getCompartmentTitleVisibilityPreferences() {
        TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
        String[] stringArray = compartments;
        int n = compartments.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            map.put(name, Boolean.FALSE);
            ++n2;
        }
        return map;
    }

    protected void initializeCompartmentsList() {
        String[] stringArray = compartments;
        int n = compartments.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.compartmentsList.add(name);
            ++n2;
        }
    }

    protected TreeMap<String, String> getLabelRole() {
        return new TreeMap<String, String>();
    }

    protected void createPageContents(Composite parent) {
        Object compartmentGroup;
        super.createPageContents(parent);
        NodeColorGroup colorGroupForNodeComposite = new NodeColorGroup(parent, this.getPreferenceKey(), (DialogPage)this);
        this.addPreferenceGroup((AbstractPreferenceGroup)colorGroupForNodeComposite);
        BackgroundColor backgroundColorGroup = new BackgroundColor(parent, this.getPreferenceKey(), (DialogPage)this);
        this.addPreferenceGroup((AbstractPreferenceGroup)backgroundColorGroup);
        DecorationGroup decorationGroup = new DecorationGroup(parent, this.getPreferenceKey(), (DialogPage)this);
        this.addPreferenceGroup((AbstractPreferenceGroup)decorationGroup);
        if (!this.compartmentsList.isEmpty()) {
            compartmentGroup = new NodeCompartmentGroupEx(parent, this.getPreferenceKey(), (DialogPage)this, this.compartmentsList, this.getCompartmentTitleVisibilityPreferences().keySet(), this.getPreferenceStore());
            this.addPreferenceGroup((AbstractPreferenceGroup)compartmentGroup);
        }
        if (!this.getLabelRole().isEmpty()) {
            compartmentGroup = new LabelGroup(parent, this.getPreferenceKey(), (DialogPage)this, this.getLabelRole());
            this.addPreferenceGroup((AbstractPreferenceGroup)compartmentGroup);
        }
    }

    protected String getBundleId() {
        return "org.eclipse.papyrus.uml.diagram.sequence";
    }

    static class NodeCompartmentGroupEx
    extends AbstractGroup {
        private final List<String> myCompartments;
        private final IPreferenceStore myPreferenceStore;
        private final Set<String> compartmentsWithTitle;

        public NodeCompartmentGroupEx(Composite parent, String title, DialogPage dialogPage, List<String> compartmentsName, Set<String> compartmentsWithTitle, IPreferenceStore store) {
            super(parent, title, dialogPage);
            this.myCompartments = compartmentsName;
            this.compartmentsWithTitle = compartmentsWithTitle;
            this.myPreferenceStore = store;
            this.createContent(parent);
        }

        protected void createContent(Composite parent) {
            for (String compartment : this.myCompartments) {
                this.addCompartmentVisibilityGroup(parent, compartment);
            }
        }

        protected void addCompartmentVisibilityGroup(Composite parent, String compartment) {
            Group group = new Group(parent, 0);
            group.setLayout((Layout)new GridLayout(2, true));
            group.setText(compartment);
            GridData gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            group.setLayoutData((Object)gridData);
            String compartmentVisibilityPreference = PreferencesConstantsHelper.getCompartmentElementConstant((String)this.getKey(), (String)compartment, (int)18);
            String compartmentVisibilityLabel = "Show compartment";
            Button showCompartmentButton = this.addCheckboxField((Composite)group, compartmentVisibilityPreference, compartmentVisibilityLabel);
            if (this.compartmentsWithTitle.contains(compartment)) {
                boolean showCompartmentIsNotChecked;
                String compartmentNameVisibilityPreference = PreferencesConstantsHelper.getCompartmentElementConstant((String)this.getKey(), (String)compartment, (int)19);
                String compartmentNameVisibilityLabel = "Show name";
                Button showNameButton = this.addCheckboxField((Composite)group, compartmentNameVisibilityPreference, compartmentNameVisibilityLabel);
                boolean bl = showCompartmentIsNotChecked = !this.myPreferenceStore.getBoolean(compartmentVisibilityPreference);
                if (showCompartmentIsNotChecked) {
                    showNameButton.setEnabled(false);
                }
                this.createDependency(showCompartmentButton, new Control[]{showNameButton});
            }
        }

        protected Button addCheckboxField(Composite parent, String preferenceKey, String label) {
            Composite plate = new Composite(parent, 0);
            plate.setLayoutData((Object)new GridData());
            CheckBoxFieldEditor compartmentVisibilityBooleanFieldEditor = new CheckBoxFieldEditor(preferenceKey, label, plate);
            Button checkbox = compartmentVisibilityBooleanFieldEditor.getCheckbox();
            compartmentVisibilityBooleanFieldEditor.setPage(this.getDialogPage());
            this.addFieldEditor((FieldEditor)compartmentVisibilityBooleanFieldEditor);
            return checkbox;
        }

        protected void createDependency(final Button master, final Control[] slaves) {
            SelectionListener dependencyListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    boolean state = master.getSelection();
                    int i = 0;
                    while (i < slaves.length) {
                        slaves[i].setEnabled(state);
                        ++i;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
            master.addSelectionListener(dependencyListener);
        }
    }
}

