/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.List;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GeneralOrderingEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.DurationLinkUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.OccurrenceSpecificationUtil;
import org.eclipse.uml2.uml.UMLPackage;

public class GeneralOrderingUtil
extends OccurrenceSpecificationUtil {
    public static boolean isCreateGeneralOrderingLink(CreateConnectionRequest request) {
        CreateRelationshipRequest createElementRequest = GeneralOrderingUtil.getCreateRelationshipRequest(request);
        if (createElementRequest == null) {
            AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest createRequest;
            List types;
            return request instanceof AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest && (types = (createRequest = (AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest)request).getElementTypes()).stream().allMatch(Predicate.isEqual(UMLElementTypes.GeneralOrdering_Edge));
        }
        IElementType type = createElementRequest.getElementType();
        return type == UMLElementTypes.GeneralOrdering_Edge;
    }

    public static boolean isGeneralOrderingLink(CreateConnectionViewRequest createRequest) {
        String semanticHint = createRequest.getConnectionViewDescriptor().getSemanticHint();
        return "GeneralOrdering_Edge".equals(semanticHint);
    }

    public static boolean isGeneralOrderingLink(ReconnectRequest request) {
        return request.getConnectionEditPart() instanceof GeneralOrderingEditPart;
    }

    public static boolean isConsistent(Connector connector, SetRequest setRequest) {
        String targetAnchor;
        Object newValue = setRequest.getValue();
        EStructuralFeature feature = setRequest.getFeature();
        if (feature != UMLPackage.Literals.GENERAL_ORDERING__BEFORE && feature != UMLPackage.Literals.GENERAL_ORDERING__AFTER) {
            return true;
        }
        if (newValue == null) {
            return false;
        }
        View sourceView = connector.getSource();
        String sourceAnchor = connector.getSourceAnchor() instanceof IdentityAnchor ? ((IdentityAnchor)connector.getSourceAnchor()).getId() : "";
        View targetView = connector.getTarget();
        String string = targetAnchor = connector.getSourceAnchor() instanceof IdentityAnchor ? ((IdentityAnchor)connector.getTargetAnchor()).getId() : "";
        if (sourceView == null || targetView == null) {
            return false;
        }
        return !(feature == UMLPackage.Literals.GENERAL_ORDERING__BEFORE ? newValue != DurationLinkUtil.findSemanticOccurrence(sourceView, sourceAnchor) : feature == UMLPackage.Literals.GENERAL_ORDERING__AFTER && newValue != DurationLinkUtil.findSemanticOccurrence(targetView, targetAnchor));
    }
}

