/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.MDTUtil;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.util.DestructionOccurrenceUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class FragmentOrderingKeeper {
    private static final float HALF_UNIT = 0.5f;
    private static final String NAME_FORMAT = "<{0}> {1}";
    private Map<Integer, List<InteractionFragment>> optionallyOrderedFragments;
    private EList<InteractionFragment> orderedFragments;
    private Set<Lifeline> constrainingNotRepresentedLifelines;
    private Set<LifelineEditPart> constrainingLifelineParts;
    private Set<Message> constrainingMessages;
    private Set<ExecutionSpecification> constrainingExecutions;
    private Set<GeneralOrdering> constrainingGeneralOrderings;
    private List<List<InteractionFragment>> orderConstraints;
    private Set<InteractionFragment> conflictingFragments;

    public IStatus validate(EObject target, IValidationContext ctx) {
        InteractionFragment fragment;
        boolean valid;
        if (target instanceof Interaction) {
            Interaction interaction = (Interaction)target;
            boolean valid2 = this.validateOrder(interaction);
            if (!valid2) {
                IStatus status = ctx.createFailureStatus(new Object[]{this.getConflictingFragmentsFormattedString()});
                this.removeModelReferences();
                return status;
            }
        } else if (target instanceof InteractionOperand) {
            InteractionOperand interactionOp = (InteractionOperand)target;
            boolean valid3 = this.validateOrder(interactionOp);
            if (!valid3) {
                IStatus status = ctx.createFailureStatus(new Object[]{this.getConflictingFragmentsFormattedString()});
                this.removeModelReferences();
                return status;
            }
        } else if (target instanceof InteractionFragment && !(valid = this.validateOrder((fragment = (InteractionFragment)target).getEnclosingInteraction()))) {
            IStatus status = ctx.createFailureStatus(new Object[]{this.getConflictingFragmentsFormattedString()});
            this.removeModelReferences();
            return status;
        }
        this.removeModelReferences();
        return ctx.createSuccessStatus();
    }

    private String getConflictingFragmentsFormattedString() {
        StringBuffer buff = new StringBuffer();
        for (InteractionFragment frag : this.conflictingFragments) {
            buff.append(System.getProperty("line.separator"));
            String name = NLS.bind((String)NAME_FORMAT, (Object)frag.eClass().getName(), (Object)frag.getQualifiedName());
            buff.append(name);
        }
        return buff.toString();
    }

    private void removeModelReferences() {
        this.orderedFragments = null;
        if (this.constrainingLifelineParts != null) {
            this.constrainingLifelineParts.clear();
        }
        if (this.constrainingMessages != null) {
            this.constrainingMessages.clear();
        }
        if (this.constrainingExecutions != null) {
            this.constrainingExecutions.clear();
        }
        if (this.constrainingGeneralOrderings != null) {
            this.constrainingGeneralOrderings.clear();
        }
        if (this.orderConstraints != null) {
            this.orderConstraints.clear();
        }
        if (this.conflictingFragments != null) {
            this.conflictingFragments.clear();
        }
        if (this.optionallyOrderedFragments != null) {
            this.optionallyOrderedFragments.clear();
        }
    }

    private boolean validateOrder(InteractionOperand interactionOperand) {
        this.orderedFragments = interactionOperand.getFragments();
        this.computeConstraints();
        return this.reorderFragmentsInAValidTrace();
    }

    private boolean validateOrder(Interaction interaction) {
        this.orderedFragments = interaction.getFragments();
        this.computeConstraints();
        return this.reorderFragmentsInAValidTrace();
    }

    private void computeConstraints() {
        IEditorPart editor = MDTUtil.getActiveEditor();
        DiagramEditPart diagram = null;
        if (editor instanceof IDiagramWorkbenchPart) {
            diagram = ((IDiagramWorkbenchPart)editor).getDiagramEditPart();
        }
        this.constrainingNotRepresentedLifelines = new HashSet<Lifeline>();
        this.constrainingLifelineParts = new HashSet<LifelineEditPart>();
        this.constrainingMessages = new HashSet<Message>();
        this.constrainingExecutions = new HashSet<ExecutionSpecification>();
        this.constrainingGeneralOrderings = new HashSet<GeneralOrdering>();
        for (InteractionFragment fragment : this.orderedFragments) {
            ExecutionSpecification exe;
            Message mess;
            for (Lifeline lifeline : fragment.getCovereds()) {
                boolean lifelineRepresented = false;
                List lifelineViews = DiagramEditPartsUtil.getEObjectViews((EObject)lifeline);
                for (Object lifelineView : lifelineViews) {
                    EditPart part;
                    String visualID;
                    if (!(lifelineView instanceof View) || diagram == null || !"Lifeline_Shape".equals(visualID = UMLVisualIDRegistry.getVisualID((View)lifelineView)) || !((part = DiagramEditPartsUtil.getEditPartFromView((View)((View)lifelineView), (EditPart)diagram)) instanceof LifelineEditPart)) continue;
                    this.constrainingLifelineParts.add((LifelineEditPart)part);
                    lifelineRepresented = true;
                }
                if (lifelineRepresented) continue;
                this.constrainingNotRepresentedLifelines.add(lifeline);
            }
            if (fragment instanceof MessageOccurrenceSpecification && (mess = ((MessageOccurrenceSpecification)fragment).getMessage()) != null) {
                this.constrainingMessages.add(mess);
            }
            if (fragment instanceof ExecutionSpecification) {
                this.constrainingExecutions.add((ExecutionSpecification)fragment);
            } else if (fragment instanceof ExecutionOccurrenceSpecification && (exe = ((ExecutionOccurrenceSpecification)fragment).getExecution()) != null) {
                this.constrainingExecutions.add(exe);
            }
            if (!(fragment instanceof OccurrenceSpecification)) continue;
            EList orderings = ((OccurrenceSpecification)fragment).getToAfters();
            this.constrainingGeneralOrderings.addAll((Collection<GeneralOrdering>)orderings);
            orderings = ((OccurrenceSpecification)fragment).getToBefores();
            this.constrainingGeneralOrderings.addAll((Collection<GeneralOrdering>)orderings);
        }
        this.constructPartialOrders();
    }

    private void constructPartialOrders() {
        MessageEnd frag;
        Cloneable constraint;
        this.optionallyOrderedFragments = new HashMap<Integer, List<InteractionFragment>>();
        int numberOfConstraints = this.constrainingNotRepresentedLifelines.size() + this.constrainingLifelineParts.size() + this.constrainingMessages.size() + this.constrainingExecutions.size() + this.constrainingGeneralOrderings.size();
        this.orderConstraints = new ArrayList<List<InteractionFragment>>(numberOfConstraints);
        int indexConstraint = 0;
        for (Lifeline lifeline : this.constrainingNotRepresentedLifelines) {
            constraint = new ArrayList();
            for (InteractionFragment fragment : this.orderedFragments) {
                if (!lifeline.getCoveredBys().contains((Object)fragment)) continue;
                constraint.add(fragment);
            }
            DestructionOccurrenceUtil.reorderDestructionOccurrence(constraint);
            this.orderConstraints.add(indexConstraint, (List<InteractionFragment>)((Object)constraint));
            ++indexConstraint;
        }
        for (LifelineEditPart part : this.constrainingLifelineParts) {
            constraint = new TreeMap();
            this.fillConstraintWithLifelineEvents((TreeMap<Float, InteractionFragment>)constraint, part, indexConstraint);
            ArrayList<InteractionFragment> list = new ArrayList<InteractionFragment>(((TreeMap)constraint).values());
            DestructionOccurrenceUtil.reorderDestructionOccurrence(list);
            this.orderConstraints.add(indexConstraint, list);
            ++indexConstraint;
        }
        for (Message mess : this.constrainingMessages) {
            constraint = new ArrayList(2);
            frag = mess.getSendEvent();
            if (frag instanceof InteractionFragment && this.orderedFragments.contains((Object)frag)) {
                constraint.add((InteractionFragment)frag);
            }
            if ((frag = mess.getReceiveEvent()) instanceof InteractionFragment && this.orderedFragments.contains((Object)frag)) {
                constraint.add((InteractionFragment)frag);
            }
            DestructionOccurrenceUtil.constraintDestructionOccurrence(mess, (List<InteractionFragment>)((Object)constraint));
            this.orderConstraints.add(indexConstraint, (List<InteractionFragment>)((Object)constraint));
            ++indexConstraint;
        }
        for (ExecutionSpecification exe : this.constrainingExecutions) {
            constraint = new ArrayList(3);
            frag = exe.getStart();
            if (frag != null && this.orderedFragments.contains((Object)frag)) {
                constraint.add(frag);
            }
            if (this.orderedFragments.contains((Object)(frag = exe))) {
                constraint.add(frag);
            }
            if ((frag = exe.getFinish()) != null && this.orderedFragments.contains((Object)frag)) {
                constraint.add(frag);
            }
            this.orderConstraints.add(indexConstraint, (List<InteractionFragment>)((Object)constraint));
            ++indexConstraint;
        }
        for (GeneralOrdering genOrd : this.constrainingGeneralOrderings) {
            constraint = new ArrayList(2);
            frag = genOrd.getBefore();
            if (frag != null && this.orderedFragments.contains((Object)frag)) {
                constraint.add(frag);
            }
            if ((frag = genOrd.getAfter()) != null && this.orderedFragments.contains((Object)frag)) {
                constraint.add(frag);
            }
            this.orderConstraints.add(indexConstraint, (List<InteractionFragment>)((Object)constraint));
            ++indexConstraint;
        }
    }

    private void fillConstraintWithLifelineEvents(TreeMap<Float, InteractionFragment> constraint, LifelineEditPart lifelinePart, int indexConstraint) {
        EObject lifeline = lifelinePart.resolveSemanticElement();
        if (lifeline instanceof Lifeline) {
            ArrayList<InteractionFragment> nonLocalizedEvents = new ArrayList<InteractionFragment>();
            for (InteractionFragment event : ((Lifeline)lifeline).getCoveredBys()) {
                if (!this.orderedFragments.contains((Object)event)) continue;
                Point loc = SequenceUtil.findLocationOfEvent(lifelinePart, event);
                if (loc != null) {
                    float index = this.findNonConflictingYIndexOnLifeline(loc.y, constraint, event);
                    constraint.put(Float.valueOf(index), event);
                    continue;
                }
                nonLocalizedEvents.add(event);
            }
            this.optionallyOrderedFragments.put(indexConstraint, nonLocalizedEvents);
            InteractionFragment lastMetSortedFragment = null;
            block1: for (InteractionFragment fragment : this.orderedFragments) {
                if (!((Lifeline)lifeline).getCoveredBys().contains((Object)fragment)) continue;
                if (constraint.containsValue(fragment)) {
                    lastMetSortedFragment = fragment;
                    continue;
                }
                if (nonLocalizedEvents.contains(fragment) && lastMetSortedFragment == null) {
                    constraint.put(Float.valueOf(0.0f), fragment);
                    lastMetSortedFragment = fragment;
                    continue;
                }
                if (!nonLocalizedEvents.contains(fragment)) continue;
                Iterator<Map.Entry<Float, InteractionFragment>> entryIt = constraint.entrySet().iterator();
                while (entryIt.hasNext()) {
                    float key;
                    Map.Entry<Float, InteractionFragment> entry = entryIt.next();
                    if (!entry.getValue().equals(lastMetSortedFragment)) continue;
                    if (entryIt.hasNext()) {
                        key = (entry.getKey().floatValue() + entryIt.next().getKey().floatValue()) / 2.0f;
                        constraint.put(Float.valueOf(key), fragment);
                        lastMetSortedFragment = fragment;
                        continue block1;
                    }
                    key = entry.getKey().floatValue() + 1.0f;
                    constraint.put(Float.valueOf(key), fragment);
                    lastMetSortedFragment = fragment;
                    continue block1;
                }
            }
        }
    }

    private float findNonConflictingYIndexOnLifeline(int y, TreeMap<Float, InteractionFragment> eventsMap, InteractionFragment event) {
        float index = Integer.valueOf(y).floatValue();
        float delta = 0.5f;
        while (eventsMap.containsKey(Float.valueOf(index))) {
            InteractionFragment otherEvent = eventsMap.get(Float.valueOf(index));
            index = this.simulatenousEventsHappenInThisOrder(otherEvent, event) ? (index += delta) : (index -= delta);
            delta *= 0.5f;
        }
        return index;
    }

    private boolean simulatenousEventsHappenInThisOrder(InteractionFragment firstFragment, InteractionFragment secondFragment) {
        if (firstFragment instanceof DestructionOccurrenceSpecification) {
            return false;
        }
        if (secondFragment instanceof DestructionOccurrenceSpecification) {
            return true;
        }
        if (firstFragment instanceof MessageOccurrenceSpecification && EcoreUtil.equals((EObject)((MessageOccurrenceSpecification)firstFragment).getMessage().getReceiveEvent(), (EObject)firstFragment)) {
            return true;
        }
        if (secondFragment instanceof MessageOccurrenceSpecification && EcoreUtil.equals((EObject)((MessageOccurrenceSpecification)secondFragment).getMessage().getReceiveEvent(), (EObject)secondFragment)) {
            return false;
        }
        if (firstFragment instanceof ExecutionOccurrenceSpecification && EcoreUtil.equals((EObject)((ExecutionOccurrenceSpecification)firstFragment).getExecution().getStart(), (EObject)firstFragment)) {
            return true;
        }
        if (secondFragment instanceof ExecutionOccurrenceSpecification && EcoreUtil.equals((EObject)((ExecutionOccurrenceSpecification)secondFragment).getExecution().getStart(), (EObject)secondFragment)) {
            return false;
        }
        if (firstFragment instanceof ExecutionSpecification) {
            return true;
        }
        if (secondFragment instanceof ExecutionSpecification) {
            return false;
        }
        if (firstFragment instanceof ExecutionOccurrenceSpecification && EcoreUtil.equals((EObject)((ExecutionOccurrenceSpecification)firstFragment).getExecution().getFinish(), (EObject)firstFragment)) {
            return false;
        }
        if (secondFragment instanceof ExecutionOccurrenceSpecification && EcoreUtil.equals((EObject)((ExecutionOccurrenceSpecification)secondFragment).getExecution().getFinish(), (EObject)secondFragment)) {
            return true;
        }
        if (firstFragment instanceof MessageOccurrenceSpecification && EcoreUtil.equals((EObject)((MessageOccurrenceSpecification)firstFragment).getMessage().getSendEvent(), (EObject)firstFragment)) {
            return false;
        }
        if (secondFragment instanceof MessageOccurrenceSpecification && EcoreUtil.equals((EObject)((MessageOccurrenceSpecification)secondFragment).getMessage().getSendEvent(), (EObject)secondFragment)) {
            return true;
        }
        return true;
    }

    private boolean reorderFragmentsInAValidTrace() {
        ArrayList<InteractionFragment> initialFragmentsList = new ArrayList<InteractionFragment>((Collection<InteractionFragment>)this.orderedFragments);
        ArrayList<InteractionFragment> reorderedFragments = new ArrayList<InteractionFragment>(this.orderedFragments.size());
        int n = this.orderConstraints.size();
        boolean valid = true;
        int[] pointers = new int[n];
        Arrays.fill(pointers, 0);
        while (this.getFragmentToInspect(-1, pointers) != null) {
            HashSet fragmentsSet;
            int j;
            boolean wait;
            InteractionFragment fragmentToInspect;
            HashMap<Integer, InteractionFragment> matureFragments = new HashMap<Integer, InteractionFragment>(n);
            int i = 0;
            while (i < n) {
                fragmentToInspect = this.getFragmentToInspect(i, pointers);
                if (fragmentToInspect != null) {
                    wait = false;
                    j = 0;
                    while (j < n) {
                        List<InteractionFragment> waitingList;
                        if (i != j && pointers[j] < this.orderConstraints.get(j).size() && (waitingList = this.orderConstraints.get(j).subList(pointers[j] + 1, this.orderConstraints.get(j).size())).contains(fragmentToInspect)) {
                            wait = true;
                            break;
                        }
                        ++j;
                    }
                    if (!wait) {
                        matureFragments.put(i, fragmentToInspect);
                    }
                }
                ++i;
            }
            if (matureFragments.isEmpty()) {
                matureFragments = new HashMap(n);
                i = 0;
                while (i < n) {
                    fragmentToInspect = this.getFragmentToInspect(i, pointers);
                    if (fragmentToInspect != null) {
                        wait = false;
                        j = 0;
                        while (j < n) {
                            if (i != j && pointers[j] < this.orderConstraints.get(j).size()) {
                                List<InteractionFragment> waitingList;
                                int updatedPointer = pointers[j];
                                if (this.optionallyOrderedFragments.containsKey(j)) {
                                    List<InteractionFragment> ignore = this.optionallyOrderedFragments.get(j);
                                    while (ignore.contains(this.orderConstraints.get(j).get(updatedPointer))) {
                                        ++updatedPointer;
                                    }
                                }
                                if ((waitingList = this.orderConstraints.get(j).subList(updatedPointer + 1, this.orderConstraints.get(j).size())).contains(fragmentToInspect)) {
                                    wait = true;
                                    break;
                                }
                            }
                            ++j;
                        }
                        if (!wait) {
                            matureFragments.put(i, fragmentToInspect);
                        }
                    }
                    ++i;
                }
                if (matureFragments.isEmpty()) {
                    if (valid) {
                        this.conflictingFragments = new HashSet<InteractionFragment>(n);
                        int k = 0;
                        while (k < n) {
                            InteractionFragment frag = this.getFragmentToInspect(k, pointers);
                            if (frag != null) {
                                this.conflictingFragments.add(frag);
                            }
                            ++k;
                        }
                    }
                    valid = false;
                    InteractionFragment addedFragment = this.getFragmentToInspect(-1, pointers);
                    reorderedFragments.add(addedFragment);
                    int k = 0;
                    while (k < n) {
                        InteractionFragment frag = this.getFragmentToInspect(k, pointers);
                        while (reorderedFragments.contains(frag)) {
                            int n2 = k;
                            pointers[n2] = pointers[n2] + 1;
                            frag = this.getFragmentToInspect(k, pointers);
                        }
                        ++k;
                    }
                    continue;
                }
                fragmentsSet = new HashSet(matureFragments.values());
                reorderedFragments.addAll(fragmentsSet);
                Iterator iterator = matureFragments.keySet().iterator();
                while (iterator.hasNext()) {
                    int incrementingPointerIndex = (Integer)iterator.next();
                    InteractionFragment frag = this.getFragmentToInspect(incrementingPointerIndex, pointers);
                    while (reorderedFragments.contains(frag)) {
                        int n3 = incrementingPointerIndex;
                        pointers[n3] = pointers[n3] + 1;
                        frag = this.getFragmentToInspect(incrementingPointerIndex, pointers);
                    }
                }
                continue;
            }
            fragmentsSet = new HashSet(matureFragments.values());
            reorderedFragments.addAll(fragmentsSet);
            Iterator iterator = matureFragments.keySet().iterator();
            while (iterator.hasNext()) {
                int incrementingPointerIndex = (Integer)iterator.next();
                InteractionFragment frag = this.getFragmentToInspect(incrementingPointerIndex, pointers);
                while (reorderedFragments.contains(frag)) {
                    int n4 = incrementingPointerIndex;
                    pointers[n4] = pointers[n4] + 1;
                    frag = this.getFragmentToInspect(incrementingPointerIndex, pointers);
                }
            }
        }
        initialFragmentsList.removeAll(reorderedFragments);
        reorderedFragments.addAll(initialFragmentsList);
        DestructionOccurrenceUtil.reorderDestructionOccurrence(reorderedFragments);
        int size = reorderedFragments.size();
        int i = 0;
        while (i < size) {
            this.orderedFragments.move(i, (Object)((InteractionFragment)reorderedFragments.get(i)));
            ++i;
        }
        return valid;
    }

    private InteractionFragment getFragmentToInspect(int i, int[] pointers) {
        if (this.orderConstraints.size() != pointers.length) {
            return null;
        }
        if (i < 0 || i >= this.orderConstraints.size()) {
            i = -1;
            int j = 0;
            while (j < this.orderConstraints.size() && i == -1) {
                if (pointers[j] < this.orderConstraints.get(j).size()) {
                    i = j;
                }
                ++j;
            }
        }
        if (i >= 0 && i < this.orderConstraints.size() && pointers[i] < this.orderConstraints.get(i).size()) {
            return this.orderConstraints.get(i).get(pointers[i]);
        }
        return null;
    }
}

