/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.PHPPreferencePageBlocksRegistry;
import org.eclipse.php.internal.ui.preferences.ScrolledCompositeImpl;
import org.eclipse.php.ui.preferences.IPHPPreferencePageBlock;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractMultiBlockPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IPHPPreferencePageBlock[] fConfigurationBlocks;

    public AbstractMultiBlockPreferencePage() {
        this.setDescription();
        this.setPreferenceStore();
        this.createConfigurationBlocks();
    }

    private void createConfigurationBlocks() {
        try {
            this.fConfigurationBlocks = PHPPreferencePageBlocksRegistry.getPHPPreferencePageBlock(this.getPreferencePageID());
        }
        catch (Exception e) {
            PHPUiPlugin.log(e);
        }
        if (this.fConfigurationBlocks == null) {
            this.fConfigurationBlocks = new IPHPPreferencePageBlock[0];
        }
        HashMap<String, IPHPPreferencePageBlock> map = new HashMap<String, IPHPPreferencePageBlock>();
        int i = 0;
        while (i < this.fConfigurationBlocks.length) {
            IPHPPreferencePageBlock block = this.fConfigurationBlocks[i];
            map.put(block.getComparableName(), block);
            ++i;
        }
        Set keys = map.keySet();
        this.fConfigurationBlocks = new IPHPPreferencePageBlock[keys.size()];
        ArrayList<String> keysList = new ArrayList<String>();
        for (String comperableName : keys) {
            keysList.add(comperableName);
        }
        Collections.sort(keysList);
        int i2 = 0;
        for (String comperableName : keysList) {
            this.fConfigurationBlocks[i2] = (IPHPPreferencePageBlock)map.get(comperableName);
            ++i2;
        }
    }

    protected Control createContents(Composite composite) {
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(composite, 768);
        Composite group = new Composite((Composite)scrolledCompositeImpl, 0);
        group.setLayout((Layout)new GridLayout());
        try {
            int i = 0;
            while (i < this.fConfigurationBlocks.length) {
                this.fConfigurationBlocks[i].setCompositeAddon(group);
                this.fConfigurationBlocks[i].initializeValues(this);
                ++i;
            }
            scrolledCompositeImpl.setContent((Control)group);
        }
        catch (Exception e) {
            PHPUiPlugin.log(e);
        }
        return scrolledCompositeImpl;
    }

    public void init(IWorkbench workbench) {
    }

    protected abstract void setDescription();

    protected abstract void setPreferenceStore();

    protected abstract String getPreferencePageID();

    public boolean performCancel() {
        int i = 0;
        while (i < this.fConfigurationBlocks.length) {
            IPHPPreferencePageBlock block = this.fConfigurationBlocks[i];
            block.performCancel();
            ++i;
        }
        return super.performCancel();
    }

    protected void performDefaults() {
        int i = 0;
        while (i < this.fConfigurationBlocks.length) {
            IPHPPreferencePageBlock block = this.fConfigurationBlocks[i];
            block.performDefaults();
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        int i = 0;
        while (i < this.fConfigurationBlocks.length) {
            IPHPPreferencePageBlock block = this.fConfigurationBlocks[i];
            block.performOK(false);
            ++i;
        }
        return super.performOk();
    }
}

