/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.view;

import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.util.SourceInfo;
import org.eclipse.ptp.pldt.common.util.ViewActivator;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.BarrierTable;
import org.eclipse.ptp.pldt.mpi.analysis.analysis.MPIBarrierMatching;
import org.eclipse.ptp.pldt.mpi.analysis.messages.Messages;
import org.eclipse.ptp.pldt.mpi.analysis.view.ArtifactWithParent;
import org.eclipse.ptp.pldt.mpi.analysis.view.MPIArtifactMarkingVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowErrors {
    protected List<MPIBarrierMatching.ErrorMessage> errors_;
    protected int counter = 0;

    public ShowErrors(List<MPIBarrierMatching.ErrorMessage> errors) {
        this.errors_ = errors;
    }

    public boolean run() {
        boolean foundErrors = false;
        IWorkspaceRoot wsResource = ResourcesPlugin.getWorkspace().getRoot();
        try {
            int depth = 2;
            wsResource.deleteMarkers("org.eclipse.ptp.pldt.mpi.analysis.errorMarker", false, depth);
        }
        catch (CoreException e) {
            System.out.println("RM: exception deleting markers.");
            e.printStackTrace();
        }
        MPIArtifactMarkingVisitor visitor = new MPIArtifactMarkingVisitor("org.eclipse.ptp.pldt.mpi.analysis.errorMarker");
        for (MPIBarrierMatching.ErrorMessage err : this.errors_) {
            ArtifactWithParent a;
            String barrierName;
            BarrierTable.BarrierInfo barrier;
            int condID = ++this.counter;
            ScanReturn sr = new ScanReturn();
            String funcName = err.getFuncName();
            String fileName = err.getFileName();
            SourceInfo sourceInfo = err.getSourceInfo();
            ArtifactWithParent ea = new ArtifactWithParent(fileName, sourceInfo.getStartingLine(), 1, funcName, "Erroneous Condition", sourceInfo, 0, condID, "Error", 0);
            sr.addArtifact((Artifact)ea);
            visitor.visitFile(err.getResource(), sr.getArtifactList());
            int path1ID = ++this.counter;
            String path1name = null;
            path1name = err.getLength1() == -1 ? (err.getPath2() != null ? Messages.ShowErrors_path1DynamicNumberOfBarriers : Messages.ShowErrors_loopDynamicNumberOfBarriers) : String.valueOf(Messages.ShowErrors_path1) + err.getLength1() + Messages.ShowErrors_barriers;
            sr = new ScanReturn();
            ea = new ArtifactWithParent("", 0, 0, "", Messages.ShowErrors_counterExample, err.getPath1SourceInfo(), condID, path1ID, path1name, 0);
            sr.addArtifact((Artifact)ea);
            int path2ID = 0;
            if (err.getPath2() != null) {
                ++this.counter;
                path2ID = this.counter;
                String path2name = null;
                path2name = err.getLength2() == -1 ? Messages.ShowErrors_path2dynamicNumberOfBarriers : String.valueOf(Messages.ShowErrors_path2) + err.getLength2() + Messages.ShowErrors_barriers;
                ea = new ArtifactWithParent("", 0, 0, "", "Counter Example", err.getPath2SourceInfo(), condID, path2ID, path2name, 0);
                sr.addArtifact((Artifact)ea);
            }
            visitor.visitFile(err.getResource(), sr.getArtifactList());
            for (MPIBarrierMatching.PathNode pn : err.getPath1()) {
                barrier = pn.getBarrier();
                ++this.counter;
                sr = new ScanReturn();
                sourceInfo = barrier.getSourceInfo();
                fileName = barrier.getFileName();
                funcName = barrier.getEnclosingFunc();
                barrierName = null;
                barrierName = pn.isRepeat() ? String.valueOf(Messages.ShowErrors_barrier_) + (barrier.getID() - 4) + "(*)" : String.valueOf(Messages.ShowErrors_barrier_) + (barrier.getID() - 4);
                a = new ArtifactWithParent(fileName, sourceInfo.getStartingLine(), 1, funcName, Messages.ShowErrors_barrier, sourceInfo, path1ID, this.counter, barrierName, barrier.getID() - 4);
                sr.addArtifact((Artifact)a);
                visitor.visitFile(barrier.getResource(), sr.getArtifactList());
            }
            if (err.getPath2() == null) continue;
            for (MPIBarrierMatching.PathNode pn : err.getPath2()) {
                barrier = pn.getBarrier();
                ++this.counter;
                sr = new ScanReturn();
                sourceInfo = barrier.getSourceInfo();
                fileName = barrier.getFileName();
                funcName = barrier.getEnclosingFunc();
                barrierName = null;
                barrierName = pn.isRepeat() ? String.valueOf(Messages.ShowErrors_barrier_) + (barrier.getID() - 4) + "(*)" : String.valueOf(Messages.ShowErrors_barrier_) + (barrier.getID() - 4);
                a = new ArtifactWithParent(fileName, sourceInfo.getStartingLine(), 1, funcName, Messages.ShowErrors_barrier, sourceInfo, path2ID, this.counter, barrierName, barrier.getID() - 4);
                sr.addArtifact((Artifact)a);
                visitor.visitFile(barrier.getResource(), sr.getArtifactList());
            }
        }
        ViewActivator.activateView((String)"org.eclipse.ptp.pldt.mpi.analysis.view.MPIBarrierMatchingSetTableView");
        if (this.errors_.size() > 0) {
            ViewActivator.activateView((String)"org.eclipse.ptp.pldt.mpi.analysis.view.MPIErrorView");
            foundErrors = true;
        }
        return foundErrors;
    }
}

