/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.matcher;

import java.util.Arrays;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class AndMatcher
extends BaseMatcher {
    private Matcher[] matchers;

    public AndMatcher(Matcher ... matchers) {
        if (matchers == null) {
            throw new NullPointerException("matchers");
        }
        this.matchers = matchers;
    }

    public boolean matches(Object item) {
        Matcher[] matcherArray = this.matchers;
        int n = this.matchers.length;
        int n2 = 0;
        while (n2 < n) {
            Matcher m = matcherArray[n2];
            if (!m.matches(item)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Matcher[] getMatchers() {
        return this.matchers;
    }

    public void describeTo(Description description) {
        description.appendList("(", " and ", ")", Arrays.asList(this.matchers));
    }

    public String toString() {
        return "Matcher matching when all matchers match: " + Arrays.toString(this.matchers);
    }
}

