/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.condition;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.AbstractExplorer;

public class ProjectExists
extends AbstractWaitCondition {
    private String projectName;
    private AbstractExplorer explorer;

    public ProjectExists(String projectName) {
        this(projectName, new PackageExplorerPart());
    }

    public ProjectExists(String projectName, AbstractExplorer explorer) {
        this.projectName = projectName;
        this.explorer = explorer;
    }

    public boolean test() {
        this.explorer.open();
        return this.explorer.containsProject(this.projectName);
    }

    public String description() {
        return "Project " + this.projectName + " exists.";
    }

    public String errorMessageWhile() {
        return "Project with name '" + this.projectName + "' still exists.";
    }

    public String errorMessageUntil() {
        List projects = this.explorer.getProjects().stream().map(it -> it.getName()).collect(Collectors.toList());
        return "Project with name '" + this.projectName + "' does not exists. Existing projects: " + projects.toString();
    }
}

