/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.mylyn.tasks.ui.views;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.GroupWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitProvider;
import org.eclipse.reddeer.common.wait.WaitWrapper;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;

public class TaskList {
    private static final TimePeriod TIMEOUT = TimePeriod.VERY_LONG;
    protected final Logger log = Logger.getLogger(this.getClass());
    private TreeItem treeItem;

    public TaskList(TreeItem treeItem) {
        this.treeItem = treeItem;
    }

    public void delete() {
        this.delete(false);
    }

    public void delete(boolean stopFirst) {
        this.log.info("Deleting Repository");
        this.select();
        new ContextMenuItem(new String[]{"Delete"}).select();
        new PushButton("OK").click();
        new GroupWait(TIMEOUT, new WaitWrapper[]{WaitProvider.waitUntil((WaitCondition)new TreeItemIsDisposed(this.treeItem)), WaitProvider.waitWhile((WaitCondition)new JobIsRunning())});
    }

    protected void select() {
        this.treeItem.select();
    }

    public String getName() {
        return this.treeItem.getText();
    }

    private class TreeItemIsDisposed
    extends AbstractWaitCondition {
        private TreeItem treeItem;

        public TreeItemIsDisposed(TreeItem treeItem) {
            this.treeItem = treeItem;
        }

        public boolean test() {
            return this.treeItem.isDisposed();
        }

        public String description() {
            return "repository tree item is disposed";
        }
    }
}

