/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.environment;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.environment.IResourceWriteOperation;
import org.eclipse.scout.sdk.s2e.util.CharSequenceInputStream;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class ResourceWriteOperation
implements IResourceWriteOperation {
    private final IFile m_file;
    private final CharSequence m_content;

    protected ResourceWriteOperation(IFile file, CharSequence content) {
        this.m_file = (IFile)Ensure.notNull((Object)file, (String)"File cannot be null", (Object[])new Object[0]);
        this.m_content = (CharSequence)Ensure.notNull((Object)content, (String)"File content cannot be null", (Object[])new Object[0]);
    }

    @Override
    public IFile getFile() {
        return this.m_file;
    }

    @Override
    public void accept(EclipseProgress progress) {
        progress.init("Write " + this.m_file.getProjectRelativePath(), 3);
        try {
            if (ResourceWriteOperation.areContentsEqual(this.m_file, this.m_content)) {
                return;
            }
            progress.setWorkRemaining(2);
            this.writeFile(progress.newChild(2));
        }
        catch (IOException | CoreException e) {
            SdkLog.error((String)"could not store '{}'.", (Object[])new Object[]{this.m_file.getProjectRelativePath(), e});
        }
    }

    protected void writeFile(EclipseProgress progress) throws IOException, CoreException {
        String charsetName = this.m_file.getCharset();
        Throwable throwable = null;
        Object var4_5 = null;
        try (CharSequenceInputStream stream = new CharSequenceInputStream(this.m_content, charsetName);){
            if (!this.m_file.exists()) {
                ResourceWriteOperation.mkdirs((IResource)this.m_file.getParent(), (IProgressMonitor)progress.newChild(1).monitor());
                this.m_file.create((InputStream)stream, true, (IProgressMonitor)progress.newChild(1).monitor());
            } else {
                IStatus result = S2eUtils.makeCommittable(Collections.singletonList(this.m_file));
                if (result.isOK()) {
                    this.m_file.setContents((InputStream)stream, true, true, (IProgressMonitor)progress.newChild(2).monitor());
                } else {
                    SdkLog.warning((String)"Unable to make all resources committable. Save will be skipped.", (Object[])new Object[]{new CoreException(result)});
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean areContentsEqual(IFile file, CharSequence newContent) {
        return ResourceWriteOperation.areContentsEqual(file, newContent, 2048);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean areContentsEqual(IFile file, CharSequence newContent, int blockSize) {
        if (!file.exists()) {
            return false;
        }
        char[] buffer = new char[blockSize];
        int blockStart = 0;
        int total = 0;
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (InputStreamReader in = new InputStreamReader(file.getContents(), file.getCharset());){
                boolean bl;
                while (true) {
                    int length;
                    if ((length = in.read(buffer)) == -1) {
                        if (total != newContent.length()) break;
                        bl = true;
                        return bl;
                    }
                    total += length;
                    if (newContent.length() < blockStart + length) {
                        return false;
                    }
                    if (!ResourceWriteOperation.equalsBlock(buffer, blockStart, length, newContent)) {
                        return false;
                    }
                    blockStart += length;
                }
                bl = false;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            SdkLog.warning((String)"Unable to read contents of file '{}'.", (Object[])new Object[]{file, e});
            return false;
        }
    }

    protected static boolean equalsBlock(char[] a, int start, int length, CharSequence ref) {
        int i = 0;
        while (i < length) {
            if (a[i] != ref.charAt(start + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void mkdirs(IResource dir, IProgressMonitor monitor) throws CoreException {
        if (dir.getType() != 2) {
            return;
        }
        if (!dir.getParent().exists()) {
            ResourceWriteOperation.mkdirs((IResource)dir.getParent(), monitor);
        }
        if (!dir.exists()) {
            ((IFolder)dir).create(true, false, monitor);
        }
    }

    @Override
    public IResource getAffectedResource() {
        IFile curResource = this.m_file;
        while (curResource != null && !curResource.exists()) {
            curResource = curResource.getParent();
        }
        return curResource;
    }

    public String toString() {
        return "Write " + this.m_file.getProjectRelativePath();
    }
}

