/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.persistence;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.tcf.te.launch.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchSpecification;
import org.eclipse.tcf.te.launch.core.persistence.AbstractItemListXMLParser;
import org.eclipse.tcf.te.launch.core.persistence.DefaultPersistenceDelegate;
import org.eclipse.tcf.te.runtime.persistence.PersistenceManager;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistenceDelegate;
import org.osgi.framework.Bundle;

public abstract class AbstractItemListPersistenceDelegate<ItemType> {
    private final String tagName;
    private final String key;

    public AbstractItemListPersistenceDelegate(String tagName, String key) {
        Assert.isNotNull((Object)tagName);
        Assert.isNotNull((Object)key);
        this.tagName = tagName;
        this.key = key;
    }

    public final void setItems(ILaunchConfigurationWorkingCopy wc, ItemType[] items) {
        Assert.isNotNull((Object)wc);
        if (items == null || items.length == 0) {
            DefaultPersistenceDelegate.setAttribute(wc, this.key, null);
            return;
        }
        String xml = this.encodeItems(items);
        DefaultPersistenceDelegate.setAttribute(wc, this.key, xml);
    }

    public final void setItems(ILaunchSpecification launchSpec, ItemType[] items) {
        Assert.isNotNull((Object)launchSpec);
        if (items == null || items.length == 0) {
            launchSpec.removeAttribute(this.key);
            return;
        }
        String xml = this.encodeItems(items);
        launchSpec.addAttribute(this.key, xml);
    }

    public final String encodeItems(ItemType[] items) {
        String result;
        block13: {
            Assert.isNotNull(items);
            result = null;
            StringWriter writer = new StringWriter();
            try {
                try {
                    String indentation = this.writeHeader(writer);
                    ItemType[] ItemTypeArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ItemType item = ItemTypeArray[n2];
                        this.writeItem(writer, indentation, item);
                        ++n2;
                    }
                    this.writeFooter(writer);
                    result = writer.toString();
                }
                catch (IOException e) {
                    if (Platform.inDebugMode()) {
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), "Launch framework internal error: " + e.getLocalizedMessage(), (Throwable)e);
                        Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                    }
                    result = null;
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private String writeHeader(Writer writer) throws IOException {
        Assert.isNotNull((Object)writer);
        writer.write("<" + this.tagName + "s>\n");
        return "\t";
    }

    private String writeFooter(Writer writer) throws IOException {
        Assert.isNotNull((Object)writer);
        writer.write("</" + this.tagName + "s>\n");
        return "";
    }

    private void writeItem(Writer writer, String indentation, ItemType item) throws IOException {
        Assert.isNotNull((Object)writer);
        Assert.isNotNull((Object)indentation);
        Assert.isNotNull(item);
        IPersistenceDelegate delegate = PersistenceManager.getInstance().getDelegate(item, String.class);
        if (delegate != null) {
            writer.write(String.valueOf(indentation) + "<" + this.tagName + " " + "type" + "=\"" + delegate.getPersistedClass(item).getName() + "\">\n");
            writer.write(String.valueOf(indentation) + "\t" + delegate.write(item, String.class) + "\n");
            writer.write(String.valueOf(indentation) + "</" + this.tagName + ">\n");
        }
    }

    public final List<ItemType> decodeItems(String encodedItems) {
        Assert.isNotNull((Object)encodedItems);
        ArrayList items = new ArrayList();
        if (!"".equals(encodedItems.trim())) {
            ByteArrayInputStream input = new ByteArrayInputStream(encodedItems.getBytes());
            AbstractItemListXMLParser xmlParser = this.getXMLParser();
            xmlParser.initXMLParser();
            xmlParser.setItems(items);
            try {
                xmlParser.getXMLReader().parse((InputStream)input, xmlParser);
            }
            catch (Exception e) {
                if (Platform.inDebugMode()) {
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), "Launch framework internal error: " + e.getLocalizedMessage(), (Throwable)e);
                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                }
                items.clear();
            }
        }
        return items;
    }

    protected abstract AbstractItemListXMLParser<ItemType> getXMLParser();

    public final List<ItemType> getItems(ILaunchConfiguration configuration) {
        String encodedItems;
        List<Object> items = new ArrayList();
        if (configuration != null && (encodedItems = DefaultPersistenceDelegate.getAttribute(configuration, this.key, null)) != null) {
            items = this.decodeItems(encodedItems);
        }
        return items;
    }

    public final List<ItemType> getItems(ILaunchSpecification launchSpec) {
        String encodedItems;
        List<Object> items = new ArrayList();
        if (launchSpec != null && (encodedItems = (String)launchSpec.getAttribute(this.key, null)) != null) {
            items = this.decodeItems(encodedItems);
        }
        return items;
    }
}

