/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNodeBase;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNodeWorkingCopy;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IUserAccount;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.FSTreeNodeBase;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.AbstractOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpCommitAttr;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

class FSTreeNodeWorkingCopy
extends FSTreeNodeBase
implements IFSTreeNodeWorkingCopy {
    private final FSTreeNodeBase fOriginal;
    private int fPermissions;
    private int fWin32Attributes;

    FSTreeNodeWorkingCopy(FSTreeNodeWorkingCopy original) {
        this.fOriginal = original;
        this.fPermissions = original.fPermissions;
        this.fWin32Attributes = original.fWin32Attributes;
    }

    FSTreeNodeWorkingCopy(FSTreeNode original) {
        this.fOriginal = original;
        this.fPermissions = original.getPermissions();
        this.fWin32Attributes = original.getWin32Attrs();
    }

    @Override
    protected int getWin32Attrs() {
        return this.fWin32Attributes;
    }

    @Override
    protected int getPermissions() {
        return this.fPermissions;
    }

    @Override
    public IFSTreeNodeWorkingCopy createWorkingCopy() {
        return new FSTreeNodeWorkingCopy(this);
    }

    @Override
    public void setWritable(boolean b) {
        IUserAccount account = this.getUserAccount();
        if (account != null) {
            int bit = this.getUID() == account.getEUID() ? 128 : (this.getGID() == account.getEGID() ? 16 : 2);
            this.setPermission(bit, true);
        }
    }

    @Override
    public void setPermission(int bit, boolean value) {
        this.fPermissions = value ? (this.fPermissions |= bit) : (this.fPermissions &= ~bit);
    }

    @Override
    public void setWin32Attr(int bit, boolean value) {
        this.fWin32Attributes = value ? (this.fWin32Attributes |= bit) : (this.fWin32Attributes &= ~bit);
    }

    @Override
    public void setHidden(boolean hidden) {
        this.setWin32Attr(2, hidden);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.setWin32Attr(1, readOnly);
    }

    @Override
    public boolean isDirty() {
        if (this.fOriginal.getPermissions() != this.getPermissions()) {
            return true;
        }
        return this.fOriginal.getWin32Attrs() != this.getWin32Attrs();
    }

    @Override
    public IOperation operationCommit() {
        return new AbstractOperation(){

            @Override
            public String getName() {
                return MessageFormat.format(Messages.FSTreeNodeWorkingCopy_commitOperation_name, FSTreeNodeWorkingCopy.this.getName());
            }

            @Override
            protected IStatus doRun(IProgressMonitor monitor) {
                monitor.beginTask(this.getName(), -1);
                return FSTreeNodeWorkingCopy.this.doCommit(monitor);
            }
        };
    }

    protected IStatus doCommit(IProgressMonitor monitor) {
        try {
            if (this.fOriginal instanceof FSTreeNodeWorkingCopy) {
                IStatus iStatus = this.commit((FSTreeNodeWorkingCopy)this.fOriginal);
                return iStatus;
            }
            if (this.fOriginal instanceof FSTreeNode) {
                IStatus iStatus = this.commit((FSTreeNode)this.fOriginal, monitor);
                return iStatus;
            }
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private IStatus commit(FSTreeNodeWorkingCopy original) {
        original.fPermissions = this.fPermissions;
        original.fWin32Attributes = this.fWin32Attributes;
        return Status.OK_STATUS;
    }

    private IStatus commit(FSTreeNode original, IProgressMonitor monitor) {
        if (!this.isDirty()) {
            return Status.OK_STATUS;
        }
        IFileSystem.FileAttrs attrs = original.getAttributes();
        if (attrs != null) {
            HashMap attributes = new HashMap(attrs.attributes);
            if (this.fWin32Attributes != original.getWin32Attrs()) {
                attrs.attributes.put("Win32Attrs", this.fWin32Attributes);
            }
            attrs = new IFileSystem.FileAttrs(attrs.flags, attrs.size, attrs.uid, attrs.gid, this.fPermissions, attrs.atime, attrs.mtime, attributes);
            return new OpCommitAttr(original, attrs).run(monitor);
        }
        return Status.OK_STATUS;
    }

    @Override
    public String getName() {
        return this.fOriginal.getName();
    }

    @Override
    public IFSTreeNodeBase.Type getType() {
        return this.fOriginal.getType();
    }

    @Override
    public String getFileTypeLabel() {
        return this.fOriginal.getFileTypeLabel();
    }

    @Override
    public IUserAccount getUserAccount() {
        return this.fOriginal.getUserAccount();
    }

    @Override
    public String getLocation() {
        return this.fOriginal.getLocation();
    }

    @Override
    public boolean isFileSystem() {
        return this.fOriginal.isFileSystem();
    }

    @Override
    public boolean isRootDirectory() {
        return this.fOriginal.isRootDirectory();
    }

    @Override
    public boolean isDirectory() {
        return this.fOriginal.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.fOriginal.isFile();
    }

    @Override
    public long getAccessTime() {
        return this.fOriginal.getAccessTime();
    }

    @Override
    public long getModificationTime() {
        return this.fOriginal.getModificationTime();
    }

    @Override
    public long getSize() {
        return this.fOriginal.getSize();
    }

    @Override
    public boolean isWindowsNode() {
        return this.fOriginal.isWindowsNode();
    }

    @Override
    public int getUID() {
        return this.fOriginal.getUID();
    }

    @Override
    public int getGID() {
        return this.fOriginal.getGID();
    }

    @Override
    protected boolean checkPermission(int user, int group, int other) {
        return this.fOriginal.checkPermission(user, group, other);
    }
}

