/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns;

import java.io.File;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.columns.ImageUpdateAdapter;

public class CacheFileImageUpdater
implements ImageUpdateAdapter {
    @Override
    public String getImageKey(IFSTreeNode node) {
        return node.getLocationURL().toExternalForm();
    }

    @Override
    public File getMirrorFile(IFSTreeNode node) {
        return node.getCacheFile();
    }

    @Override
    public File getImageFile(IFSTreeNode node) {
        File cacheFile = node.getCacheFile();
        File parentDir = cacheFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            parentDir = ModelManager.getCacheRoot();
        }
        return new File(parentDir, String.valueOf(node.getName()) + ".png");
    }
}

