/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.wizards;

import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.wizards.NewNodeWizardPage;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.validator.Validator;

public class NameValidator
extends Validator {
    NewNodeWizardPage wizard;

    public NameValidator(NewNodeWizardPage wizard) {
        super(1);
        this.wizard = wizard;
    }

    public boolean isValid(String newText) {
        String formatRegex;
        IFSTreeNode folder = this.wizard.getInputDir();
        if (folder == null) {
            this.setMessage(Messages.NameValidator_SpecifyFolder, 1);
            return false;
        }
        if (newText == null || newText.trim().length() == 0) {
            this.setMessage(Messages.FSRenamingAssistant_SpecifyNonEmptyName, 3);
            return false;
        }
        String text = newText.trim();
        if (this.hasChild(text)) {
            this.setMessage(Messages.FSRenamingAssistant_NameAlreadyExists, 3);
            return false;
        }
        String string = formatRegex = folder.isWindowsNode() ? "[^(\\?|\\\\|/|:|\\*|<|>|\\|)]+" : "[^/]+";
        if (!text.matches(formatRegex)) {
            this.setMessage(folder.isWindowsNode() ? Messages.FSRenamingAssistant_WinIllegalCharacters : Messages.FSRenamingAssistant_UnixIllegalCharacters, 3);
            return false;
        }
        this.setMessage(null, 0);
        return true;
    }

    private boolean hasChild(String name) {
        IFSTreeNode folder = this.wizard.getInputDir();
        IFSTreeNode[] nodes = folder.getChildren();
        if (nodes == null) {
            return false;
        }
        IFSTreeNode[] iFSTreeNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IFSTreeNode node = iFSTreeNodeArray[n2];
            if (node.isWindowsNode() ? node.getName().equalsIgnoreCase(name) : node.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

