/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.utils;

import java.util.UUID;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.CompoundDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;

public final class Utils {
    public static final int CTF_MAGIC = -1040441407;
    public static final int TSDL_MAGIC = 1976638807;
    public static final int TSDL_MAGIC_LEN = 4;
    public static final String SEPARATOR = System.getProperty("file.separator");
    public static final int UUID_LEN = 16;

    private Utils() {
    }

    public static int unsignedCompare(long left, long right) {
        long a = left + Long.MIN_VALUE;
        long b = right + Long.MIN_VALUE;
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static UUID getUUIDfromDefinition(AbstractArrayDefinition uuidDef) throws CTFException {
        byte[] uuidArray = new byte[16];
        IDeclaration declaration = uuidDef.getDeclaration();
        if (!(declaration instanceof CompoundDeclaration)) {
            throw new CTFException("UUID must be a sequence of unsigned bytes");
        }
        CompoundDeclaration uuidDec = (CompoundDeclaration)declaration;
        IDeclaration uuidElem = uuidDec.getElementType();
        if (!(uuidElem instanceof IntegerDeclaration)) {
            throw new CTFException("UUID must be a sequence of unsigned bytes");
        }
        IntegerDeclaration intUuidElem = (IntegerDeclaration)uuidElem;
        if (!intUuidElem.isUnsignedByte()) {
            throw new CTFException("UUID must be a sequence of unsigned bytes");
        }
        return Utils.getUUID(uuidDef, uuidArray);
    }

    private static UUID getUUID(AbstractArrayDefinition uuidDef, byte[] uuidArray) throws CTFException {
        int i = 0;
        while (i < uuidArray.length) {
            IntegerDefinition uuidByteDef = (IntegerDefinition)uuidDef.getDefinitions().get(i);
            if (uuidByteDef == null) {
                throw new CTFException("UUID incomplete, only " + i + " bytes available");
            }
            uuidArray[i] = (byte)uuidByteDef.getValue();
            ++i;
        }
        UUID uuid = Utils.makeUUID(uuidArray);
        return uuid;
    }

    public static UUID makeUUID(byte[] bytes) throws CTFException {
        long high = 0L;
        long low = 0L;
        if (bytes.length < 16) {
            throw new CTFException("UUID byte field must be 16 bytes long");
        }
        int bitsPerByte = 8;
        int bitMask = 255;
        int i = 0;
        while (i < 8) {
            low = low << 8 | (long)(bytes[i + 8] & bitMask);
            high = high << 8 | (long)(bytes[i] & bitMask);
            ++i;
        }
        return new UUID(high, low);
    }
}

