/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms;

import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ManagedForm
implements IManagedForm {
    private Object input;
    private ScrolledForm form;
    private FormToolkit toolkit;
    private Object container;
    private boolean ownsToolkit;
    private boolean initialized;
    private Vector<IFormPart> parts = new Vector();

    public ManagedForm(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.ownsToolkit = true;
        this.form = this.toolkit.createScrolledForm(parent);
    }

    public ManagedForm(FormToolkit toolkit, ScrolledForm form) {
        this.form = form;
        this.toolkit = toolkit;
    }

    @Override
    public void addPart(IFormPart part) {
        this.parts.add(part);
        part.initialize(this);
    }

    @Override
    public void removePart(IFormPart part) {
        this.parts.remove(part);
    }

    @Override
    public IFormPart[] getParts() {
        return this.parts.toArray(new IFormPart[this.parts.size()]);
    }

    @Override
    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    @Override
    public ScrolledForm getForm() {
        return this.form;
    }

    @Override
    public void reflow(boolean changed) {
        this.form.reflow(changed);
    }

    @Override
    public void fireSelectionChanged(IFormPart part, ISelection selection) {
        int i = 0;
        while (i < this.parts.size()) {
            IFormPart cpart = this.parts.get(i);
            if (!part.equals(cpart) && cpart instanceof IPartSelectionListener) {
                ((IPartSelectionListener)((Object)cpart)).selectionChanged(part, selection);
            }
            ++i;
        }
    }

    @Override
    public void initialize() {
        if (this.initialized) {
            return;
        }
        for (IFormPart part : this.parts) {
            part.initialize(this);
        }
        this.initialized = true;
    }

    public void dispose() {
        for (IFormPart part : this.parts) {
            part.dispose();
        }
        if (this.ownsToolkit) {
            this.toolkit.dispose();
        }
    }

    @Override
    public void refresh() {
        Thread dt;
        Thread t = Thread.currentThread();
        if (t.equals(dt = this.toolkit.getColors().getDisplay().getThread())) {
            this.doRefresh();
        } else {
            this.toolkit.getColors().getDisplay().asyncExec(() -> this.doRefresh());
        }
    }

    private void doRefresh() {
        int nrefreshed = 0;
        for (IFormPart part : this.parts) {
            if (!part.isStale()) continue;
            part.refresh();
            ++nrefreshed;
        }
        if (nrefreshed > 0) {
            this.form.reflow(true);
        }
    }

    @Override
    public void commit(boolean onSave) {
        for (IFormPart part : this.parts) {
            if (!part.isDirty()) continue;
            part.commit(onSave);
        }
    }

    @Override
    public boolean setInput(Object input) {
        boolean pageResult = false;
        this.input = input;
        for (IFormPart part : this.parts) {
            boolean result = part.setFormInput(input);
            if (!result) continue;
            pageResult = true;
        }
        return pageResult;
    }

    @Override
    public Object getInput() {
        return this.input;
    }

    public void setFocus() {
        if (this.parts.size() > 0) {
            IFormPart part = this.parts.get(0);
            part.setFocus();
        }
        if (!this.form.setFocus()) {
            this.form.getContent().forceFocus();
        }
    }

    @Override
    public boolean isDirty() {
        for (IFormPart part : this.parts) {
            if (!part.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStale() {
        for (IFormPart part : this.parts) {
            if (!part.isStale()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dirtyStateChanged() {
    }

    @Override
    public void staleStateChanged() {
    }

    @Override
    public Object getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Object container) {
        this.container = container;
    }

    @Override
    public IMessageManager getMessageManager() {
        return this.form.getMessageManager();
    }
}

