/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.Set;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.internal.themes.CascadingColorRegistry;
import org.eclipse.ui.internal.themes.CascadingFontRegistry;
import org.eclipse.ui.themes.ITheme;

public class CascadingTheme
extends EventManager
implements ITheme {
    private CascadingFontRegistry fontRegistry;
    private CascadingColorRegistry colorRegistry;
    private ITheme currentTheme;
    private IPropertyChangeListener listener = event -> this.fire(event);

    public CascadingTheme(ITheme currentTheme, CascadingColorRegistry colorRegistry, CascadingFontRegistry fontRegistry) {
        this.currentTheme = currentTheme;
        this.colorRegistry = colorRegistry;
        this.fontRegistry = fontRegistry;
        fontRegistry.addListener(this.listener);
        colorRegistry.addListener(this.listener);
    }

    protected void fire(PropertyChangeEvent event) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IPropertyChangeListener)listener).propertyChange(event);
            ++n2;
        }
    }

    @Override
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.addListenerObject(listener);
    }

    @Override
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.removeListenerObject(listener);
    }

    @Override
    public String getId() {
        return this.currentTheme.getId();
    }

    @Override
    public String getLabel() {
        return this.currentTheme.getLabel();
    }

    @Override
    public ColorRegistry getColorRegistry() {
        return this.colorRegistry;
    }

    @Override
    public FontRegistry getFontRegistry() {
        return this.fontRegistry;
    }

    @Override
    public void dispose() {
        this.colorRegistry.removeListener(this.listener);
        this.fontRegistry.removeListener(this.listener);
    }

    @Override
    public String getString(String key) {
        return this.currentTheme.getString(key);
    }

    @Override
    public int getInt(String key) {
        return this.currentTheme.getInt(key);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.currentTheme.getBoolean(key);
    }

    public Set keySet() {
        return this.currentTheme.keySet();
    }
}

