/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.eval;

import java.util.Collection;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.memories.TimestampReplacement;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.TimelyMemory;
import org.eclipse.viatra.query.runtime.rete.eval.AbstractEvaluatorNode;
import org.eclipse.viatra.query.runtime.rete.eval.EvaluatorCore;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;

public class OutputCachingEvaluatorNode
extends AbstractEvaluatorNode
implements Clearable {
    protected NetworkStructureChangeSensitiveLogic logic;
    Map<Tuple, Tuple> outputCache;
    TimelyMemory<Timestamp> timestampMemory;
    private final NetworkStructureChangeSensitiveLogic TIMELESS = new NetworkStructureChangeSensitiveLogic(){

        @Override
        public void pullIntoWithTimestamp(Map<Tuple, Timestamp> collector, boolean flush) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void pullInto(Collection<Tuple> collector, boolean flush) {
            for (Tuple output : OutputCachingEvaluatorNode.this.outputCache.values()) {
                collector.add(output);
            }
        }

        @Override
        public void update(Direction direction, Tuple input, Timestamp timestamp) {
            if (direction == Direction.INSERT) {
                Tuple output = OutputCachingEvaluatorNode.this.core.performEvaluation(input);
                if (output != null) {
                    Tuple previous = OutputCachingEvaluatorNode.this.outputCache.put(input, output);
                    if (previous != null) {
                        throw new IllegalStateException(String.format("Duplicate insertion of tuple %s into node %s", input, this));
                    }
                    OutputCachingEvaluatorNode.this.propagateUpdate(direction, output, timestamp);
                }
            } else {
                Tuple output = OutputCachingEvaluatorNode.this.outputCache.remove(input);
                if (output != null) {
                    OutputCachingEvaluatorNode.this.propagateUpdate(direction, output, timestamp);
                }
            }
        }
    };
    private final NetworkStructureChangeSensitiveLogic TIMELY = new NetworkStructureChangeSensitiveLogic(){

        @Override
        public void pullIntoWithTimestamp(Map<Tuple, Timestamp> collector, boolean flush) {
            for (Map.Entry entry : OutputCachingEvaluatorNode.this.timestampMemory.asMap().entrySet()) {
                Tuple input = (Tuple)entry.getKey();
                Tuple output = OutputCachingEvaluatorNode.this.outputCache.get(input);
                if (output == NORESULT) continue;
                Timestamp timestamp = (Timestamp)entry.getValue();
                collector.put(output, timestamp);
            }
        }

        @Override
        public void pullInto(Collection<Tuple> collector, boolean flush) {
            OutputCachingEvaluatorNode.this.TIMELESS.pullInto(collector, flush);
        }

        @Override
        public void update(Direction direction, Tuple input, Timestamp timestamp) {
            if (direction == Direction.INSERT) {
                Tuple output = OutputCachingEvaluatorNode.this.outputCache.get(input);
                if (output == null) {
                    output = OutputCachingEvaluatorNode.this.core.performEvaluation(input);
                    if (output == null) {
                        output = NORESULT;
                    }
                    OutputCachingEvaluatorNode.this.outputCache.put(input, output);
                }
                OutputCachingEvaluatorNode.this.timestampMemory.put(input, (Comparable)timestamp);
                if (output != NORESULT) {
                    OutputCachingEvaluatorNode.this.propagateUpdate(direction, output, timestamp);
                }
            } else {
                Tuple output = OutputCachingEvaluatorNode.this.outputCache.get(input);
                TimestampReplacement pair = OutputCachingEvaluatorNode.this.timestampMemory.remove(input, (Comparable)timestamp);
                if (pair.newValue == null) {
                    OutputCachingEvaluatorNode.this.outputCache.remove(input);
                }
                if (output != NORESULT) {
                    OutputCachingEvaluatorNode.this.propagateUpdate(direction, output, timestamp);
                }
            }
        }
    };
    private static final Tuple NORESULT = Tuples.staticArityFlatTupleOf((Object)((Object)NoResult.INSTANCE));

    public OutputCachingEvaluatorNode(ReteContainer reteContainer, EvaluatorCore core) {
        super(reteContainer, core);
        reteContainer.registerClearable(this);
        this.outputCache = CollectionsFactory.createMap();
        this.logic = this.createLogic();
    }

    @Override
    public void networkStructureChanged() {
        super.networkStructureChanged();
        this.logic = this.createLogic();
    }

    public void clear() {
        this.outputCache.clear();
        if (this.timestampMemory != null) {
            this.timestampMemory.clear();
        }
    }

    protected NetworkStructureChangeSensitiveLogic createLogic() {
        if (this.reteContainer.isDifferentialDataFlowEvaluation() && this.reteContainer.getCommunicationTracker().isInRecursiveGroup(this)) {
            if (this.timestampMemory == null) {
                this.timestampMemory = new TimelyMemory();
            }
            return this.createRecursiveTimelyLogic();
        }
        return this.createDefaultLogic();
    }

    protected NetworkStructureChangeSensitiveLogic createDefaultLogic() {
        return this.TIMELESS;
    }

    protected NetworkStructureChangeSensitiveLogic createRecursiveTimelyLogic() {
        return this.TIMELY;
    }

    @Override
    public void pullInto(Collection<Tuple> collector, boolean flush) {
        this.logic.pullInto(collector, flush);
    }

    @Override
    public void pullIntoWithTimestamp(Map<Tuple, Timestamp> collector, boolean flush) {
        this.logic.pullIntoWithTimestamp(collector, flush);
    }

    @Override
    public void update(Direction direction, Tuple input, Timestamp timestamp) {
        this.logic.update(direction, input, timestamp);
    }

    protected static abstract class NetworkStructureChangeSensitiveLogic {
        protected NetworkStructureChangeSensitiveLogic() {
        }

        public abstract void update(Direction var1, Tuple var2, Timestamp var3);

        public abstract void pullInto(Collection<Tuple> var1, boolean var2);

        public abstract void pullIntoWithTimestamp(Map<Tuple, Timestamp> var1, boolean var2);
    }

    private static enum NoResult {
        INSTANCE;

    }
}

