/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.uml2;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowComponentHelper;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class UML2Writer
extends AbstractWorkflowComponent {
    private static final Log LOG = LogFactory.getLog(UML2Writer.class);
    private String outPath;
    private String destinationFolder = "./";
    private String inputSlot = "default";
    private boolean useUML1x = false;

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public void setDestinationFolder(String destinationFolder) {
        this.destinationFolder = destinationFolder;
        if (!this.destinationFolder.equals("")) {
            if (!this.destinationFolder.endsWith("/")) {
                this.destinationFolder = String.valueOf(this.destinationFolder) + "/";
            }
        } else {
            this.destinationFolder = "./";
        }
    }

    public void setInputSlot(String p) {
        this.inputSlot = p;
    }

    public void setOutPath(String p) {
        this.outPath = p;
        if (!this.outPath.endsWith("/")) {
            this.outPath = String.valueOf(this.outPath) + "/";
        }
        if (this.outPath.startsWith("/")) {
            this.outPath = this.outPath.substring(1);
        }
    }

    public void setUseUML1x(boolean useUML1x) {
        this.useUML1x = useUML1x;
    }

    public void checkConfiguration(Issues issues) {
        if (!WorkflowComponentHelper.isParamSet((String)this.inputSlot)) {
            issues.addError("Parameter 'inputSlot' must be set");
        }
        if (!WorkflowComponentHelper.isLegalDir((String)this.destinationFolder)) {
            issues.addError("Property 'destinationFolder' does not specify a legal directory");
        }
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        LOG.info((Object)"running UML2Writer");
        Object slotContent = ctx.get(this.inputSlot);
        if (slotContent == null) {
            issues.addError((WorkflowComponent)this, "slot '" + this.inputSlot + "' is empty.");
            return;
        }
        if (!(slotContent instanceof Collection) && !(slotContent instanceof Package)) {
            issues.addError((WorkflowComponent)this, "slot '" + this.inputSlot + "' does not contain a list, a model or a profile", slotContent);
            return;
        }
        ResourceSetImpl rsImpl = new ResourceSetImpl();
        Resource.Factory factory = (Resource.Factory)Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(this.getUMLFileExtension());
        rsImpl.getResourceFactoryRegistry().getExtensionToFactoryMap().put("emx", factory);
        rsImpl.getResourceFactoryRegistry().getExtensionToFactoryMap().put("epx", factory);
        if (slotContent instanceof Collection) {
            for (Object o : (Collection)slotContent) {
                if (!(o instanceof Package)) continue;
                Package model = (Package)o;
                this.saveModel(model, (ResourceSet)rsImpl);
            }
        } else if (slotContent instanceof Package) {
            this.saveModel((Package)slotContent, (ResourceSet)rsImpl);
        }
        for (Resource resource : rsImpl.getResources()) {
            resource.unload();
        }
    }

    private void saveModel(Package model, ResourceSet rsImpl) {
        String modelFile = String.valueOf(this.destinationFolder) + this.outPath + model.getName() + "." + this.getUMLFileExtension();
        URI fileURI = URI.createFileURI((String)modelFile);
        Resource r = rsImpl.createResource(fileURI);
        r.getContents().add((Object)model);
        TreeIterator allContents = UML2Util.getAllContents((EObject)model, (boolean)true, (boolean)false);
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (!(eObject instanceof Element)) continue;
            r.getContents().addAll((Collection)((Element)eObject).getStereotypeApplications());
        }
        try {
            r.save(null);
        }
        catch (IOException e) {
            LOG.debug((Object)e.getMessage());
        }
        for (Resource resource : rsImpl.getResources()) {
            resource.unload();
        }
    }

    private String getUMLFileExtension() {
        return this.useUML1x ? "uml2" : "uml";
    }
}

