/*******************************************************************************
 * Copyright (c) 2015, 2019 itemis AG (http://www.itemis.eu) and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/
package org.eclipse.xtext.xtext.ui.wizard.project

import java.util.regex.Pattern
import org.eclipse.jface.dialogs.Dialog
import org.eclipse.jface.dialogs.IMessageProvider
import org.eclipse.jface.resource.JFaceResources
import org.eclipse.swt.SWT
import org.eclipse.swt.events.SelectionAdapter
import org.eclipse.swt.events.SelectionEvent
import org.eclipse.swt.graphics.Image
import org.eclipse.swt.layout.GridData
import org.eclipse.swt.layout.GridLayout
import org.eclipse.swt.widgets.Composite
import org.eclipse.swt.widgets.Label
import org.eclipse.swt.widgets.Link
import static org.eclipse.jface.dialogs.IMessageProvider.NONE

/**
 * @author dhuebner - Initial contribution and API
 */
class StatusWidget extends Composite {
	Link link
	Label imageLabel
	()=>void quickFix = []

	int severity = NONE

	new(Composite parent, int style) {
		super(parent, style)
		createControls()
	}

	def protected createControls() {
		layout = new GridLayout(2, false)
		imageLabel = new Label(this, SWT.NONE)
		imageLabel.text = "   "
		imageLabel.layoutData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING) => [widthHint = 15]
		link = new Link(this, SWT.NONE)
		link.layoutData = new GridData(GridData.FILL_HORIZONTAL) => [heightHint = 30]
		link.setFont(this.getFont())
		link.text = '\n\n\n'
		link.addSelectionListener(new SelectionAdapter() {
			override widgetSelected(SelectionEvent e) {
				super.widgetSelected(e)
				quickFix.apply
			}
		})
	}

	def clearStatus() {
		setStatus(NONE, '\n\n\n', [], [])
	}

	def setStatus(int severity, String text, ()=>void quickFix, ()=>void callback) {
		this.severity = severity
		this.visible = severity !== NONE
		imageLabel.image = imageFor(severity)
		link.text = text
		val matcher = Pattern.compile('<a>(.*)</a>').matcher(text.trim)
		link.toolTipText = matcher.replaceAll('$1')
		this.quickFix = [quickFix.apply callback.apply]
	}

	def addStatus(int severity, String text) {
		if (link.text.trim.empty) {
			setStatus(severity, text, [], [])
		} else {
			link.text = link.text + "\n" + text
			val matcher = Pattern.compile('<a>(.*)</a>').matcher(text.trim)
			link.toolTipText = matcher.replaceAll('$1')
			if (severity > this.severity) {
				this.severity = severity
				this.visible = severity !== NONE
				imageLabel.image = imageFor(severity)
			}
		}
	}

	def getSevertity() {
		severity
	}

	def private Image imageFor(int type) {
		switch (type) {
			case IMessageProvider.NONE: {
				null
			}
			case IMessageProvider.INFORMATION: {
				JFaceResources.getImage(Dialog.DLG_IMG_MESSAGE_INFO)
			}
			case IMessageProvider.WARNING: {
				JFaceResources.getImage(Dialog.DLG_IMG_MESSAGE_WARNING);
			}
			case IMessageProvider.ERROR: {
				JFaceResources.getImage(Dialog.DLG_IMG_MESSAGE_ERROR);
			}
		}
	}

}