/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.HasBeforeSelectionHandlers;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Accessibility;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DeckPanel;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SourcesTabEvents;
import com.google.gwt.user.client.ui.TabBar;
import com.google.gwt.user.client.ui.TabListener;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabPanel
extends Composite
implements TabListener,
SourcesTabEvents,
HasWidgets,
HasAnimation,
IndexedPanel,
HasBeforeSelectionHandlers<Integer>,
HasSelectionHandlers<Integer> {
    private UnmodifiableTabBar tabBar = new UnmodifiableTabBar();
    private TabbedDeckPanel deck = new TabbedDeckPanel(this.tabBar);

    public TabPanel() {
        VerticalPanel panel = new VerticalPanel();
        panel.add(this.tabBar);
        panel.add(this.deck);
        panel.setCellHeight(this.deck, "100%");
        this.tabBar.setWidth("100%");
        this.tabBar.addTabListener(this);
        this.initWidget(panel);
        this.setStyleName("gwt-TabPanel");
        this.deck.setStyleName("gwt-TabPanelBottom");
        Accessibility.setRole(this.deck.getElement(), "tabpanel");
    }

    @Override
    public void add(Widget w) {
        throw new UnsupportedOperationException("A tabText parameter must be specified with add().");
    }

    public void add(Widget w, String tabText) {
        this.insert(w, tabText, this.getWidgetCount());
    }

    public void add(Widget w, String tabText, boolean asHTML) {
        this.insert(w, tabText, asHTML, this.getWidgetCount());
    }

    public void add(Widget w, Widget tabWidget) {
        this.insert(w, tabWidget, this.getWidgetCount());
    }

    @Override
    public HandlerRegistration addBeforeSelectionHandler(BeforeSelectionHandler<Integer> handler) {
        return this.addHandler(handler, BeforeSelectionEvent.getType());
    }

    @Override
    public HandlerRegistration addSelectionHandler(SelectionHandler<Integer> handler) {
        return this.addHandler(handler, SelectionEvent.getType());
    }

    @Override
    @Deprecated
    public void addTabListener(TabListener listener) {
        ListenerWrapper.WrappedTabListener.add(this, listener);
    }

    @Override
    public void clear() {
        while (this.getWidgetCount() > 0) {
            this.remove(this.getWidget(0));
        }
    }

    public DeckPanel getDeckPanel() {
        return this.deck;
    }

    public TabBar getTabBar() {
        return this.tabBar;
    }

    @Override
    public Widget getWidget(int index) {
        return this.deck.getWidget(index);
    }

    @Override
    public int getWidgetCount() {
        return this.deck.getWidgetCount();
    }

    @Override
    public int getWidgetIndex(Widget widget) {
        return this.deck.getWidgetIndex(widget);
    }

    public void insert(Widget widget, String tabText, boolean asHTML, int beforeIndex) {
        this.deck.insertProtected(widget, tabText, asHTML, beforeIndex);
    }

    public void insert(Widget widget, Widget tabWidget, int beforeIndex) {
        this.deck.insertProtected(widget, tabWidget, beforeIndex);
    }

    public void insert(Widget widget, String tabText, int beforeIndex) {
        this.insert(widget, tabText, false, beforeIndex);
    }

    @Override
    public boolean isAnimationEnabled() {
        return this.deck.isAnimationEnabled();
    }

    @Override
    public Iterator<Widget> iterator() {
        return this.deck.iterator();
    }

    @Override
    @Deprecated
    public boolean onBeforeTabSelected(SourcesTabEvents sender, int tabIndex) {
        BeforeSelectionEvent<Integer> event = BeforeSelectionEvent.fire(this, tabIndex);
        return event == null || !event.isCanceled();
    }

    @Override
    @Deprecated
    public void onTabSelected(SourcesTabEvents sender, int tabIndex) {
        this.deck.showWidget(tabIndex);
        SelectionEvent.fire(this, tabIndex);
    }

    @Override
    public boolean remove(int index) {
        return this.deck.remove(index);
    }

    @Override
    public boolean remove(Widget widget) {
        return this.deck.remove(widget);
    }

    @Override
    @Deprecated
    public void removeTabListener(TabListener listener) {
        ListenerWrapper.WrappedTabListener.remove(this, listener);
    }

    public void selectTab(int index) {
        this.tabBar.selectTab(index);
    }

    @Override
    public void setAnimationEnabled(boolean enable) {
        this.deck.setAnimationEnabled(enable);
    }

    protected SimplePanel createTabTextWrapper() {
        return null;
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        this.tabBar.ensureDebugId(baseID + "-bar");
        this.deck.ensureDebugId(baseID + "-bottom");
    }

    private static class TabbedDeckPanel
    extends DeckPanel {
        private UnmodifiableTabBar tabBar;

        public TabbedDeckPanel(UnmodifiableTabBar tabBar) {
            this.tabBar = tabBar;
        }

        public void add(Widget w) {
            throw new UnsupportedOperationException("Use TabPanel.add() to alter the DeckPanel");
        }

        public void clear() {
            throw new UnsupportedOperationException("Use TabPanel.clear() to alter the DeckPanel");
        }

        public void insert(Widget w, int beforeIndex) {
            throw new UnsupportedOperationException("Use TabPanel.insert() to alter the DeckPanel");
        }

        public boolean remove(Widget w) {
            int idx = this.getWidgetIndex(w);
            if (idx != -1) {
                this.tabBar.removeTabProtected(idx);
                return super.remove(w);
            }
            return false;
        }

        protected void insertProtected(Widget w, String tabText, boolean asHTML, int beforeIndex) {
            int idx = this.getWidgetIndex(w);
            if (idx != -1) {
                this.remove(w);
                if (idx < beforeIndex) {
                    --beforeIndex;
                }
            }
            this.tabBar.insertTabProtected(tabText, asHTML, beforeIndex);
            super.insert(w, beforeIndex);
        }

        protected void insertProtected(Widget w, Widget tabWidget, int beforeIndex) {
            int idx = this.getWidgetIndex(w);
            if (idx != -1) {
                this.remove(w);
                if (idx < beforeIndex) {
                    --beforeIndex;
                }
            }
            this.tabBar.insertTabProtected(tabWidget, beforeIndex);
            super.insert(w, beforeIndex);
        }
    }

    private class UnmodifiableTabBar
    extends TabBar {
        private UnmodifiableTabBar() {
        }

        public void insertTab(String text, boolean asHTML, int beforeIndex) {
            throw new UnsupportedOperationException("Use TabPanel.insert() to alter the TabBar");
        }

        public void insertTab(Widget widget, int beforeIndex) {
            throw new UnsupportedOperationException("Use TabPanel.insert() to alter the TabBar");
        }

        public void insertTabProtected(String text, boolean asHTML, int beforeIndex) {
            super.insertTab(text, asHTML, beforeIndex);
        }

        public void insertTabProtected(Widget widget, int beforeIndex) {
            super.insertTab(widget, beforeIndex);
        }

        public void removeTab(int index) {
            throw new UnsupportedOperationException("Use TabPanel.remove() to alter the TabBar");
        }

        public void removeTabProtected(int index) {
            super.removeTab(index);
        }

        protected SimplePanel createTabTextWrapper() {
            return TabPanel.this.createTabTextWrapper();
        }
    }
}

