/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class ColorUtils {
    public static Color getShade(Color original, float brightnessVariation, Display display) {
        brightnessVariation = ColorUtils.isInvertedColorScheme() ? -brightnessVariation : brightnessVariation;
        return new Color((Device)display, ColorUtils.getShadeRGB(original.getRGB(), brightnessVariation));
    }

    public static RGB getShadeRGB(RGB original, float brightnessVariation) {
        brightnessVariation = ColorUtils.isInvertedColorScheme() ? -brightnessVariation : brightnessVariation;
        float[] hsb = ColorUtils.RGBtoHSB(original.red, original.green, original.blue, null);
        hsb[2] = hsb[2] + brightnessVariation;
        int rgb = ColorUtils.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        return new RGB(ColorUtils.getRed(rgb), ColorUtils.getGreen(rgb), ColorUtils.getBlue(rgb));
    }

    public static Color[] getColorShades(Color source, Color destination, int n, Display display) {
        float interval = ColorUtils.getBrightnessInterval(source.getRGB(), destination.getRGB());
        interval /= (float)(n + 2);
        Color[] result = new Color[n];
        Color base = source;
        int i = 0;
        while (i < result.length) {
            result[i] = ColorUtils.getShade(base, interval, display);
            base = result[i];
            ++i;
        }
        return result;
    }

    public static float getBrightnessInterval(RGB source, RGB destination) {
        float[] sourceHSB = ColorUtils.RGBtoHSB(source.red, source.green, source.blue, null);
        float[] destinationHSB = ColorUtils.RGBtoHSB(destination.red, destination.green, destination.blue, null);
        return destinationHSB[2] - sourceHSB[2];
    }

    public static Color[] getColorShades(Color source, Color middle, Color destination, int n, Display display) {
        Color[] result = new Color[n + 1];
        Color[] temp = ColorUtils.getColorShades(source, middle, n / 2, display);
        System.arraycopy(temp, 0, result, 0, temp.length);
        int pos = temp.length;
        result[pos] = new Color((Device)display, middle.getRGB());
        temp = ColorUtils.getColorShades(middle, destination, n - temp.length, display);
        System.arraycopy(temp, 0, result, pos + 1, temp.length);
        return result;
    }

    public static RGB[] getColorShades(RGB source, RGB[] shades, RGB destination) {
        RGB[] result = new RGB[shades.length];
        int i = 0;
        while (i < shades.length) {
            RGB shade = shades[i];
            float interval = ColorUtils.getBrightnessInterval(source, shade);
            result[i] = ColorUtils.getShadeRGB(destination, interval);
            ++i;
        }
        return result;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        float s = saturation;
        float v = brightness;
        int x = Math.round(v * 255.0f);
        if (s == 0.0f) {
            return 0xFF000000 | x << 16 | x << 8 | x;
        }
        float h = hue == 1.0f ? 0.0f : (hue - (float)Math.floor(hue)) * 6.0f;
        int i = (int)Math.floor(h);
        float f = h - (float)i;
        int p = Math.round(255.0f * (v * (1.0f - s)));
        int q = Math.round(255.0f * (v * (1.0f - s * f)));
        int t = Math.round(255.0f * (v * (1.0f - s * (1.0f - f))));
        switch (i) {
            case 0: {
                return 0xFF000000 | x << 16 | t << 8 | p;
            }
            case 1: {
                return 0xFF000000 | q << 16 | x << 8 | p;
            }
            case 2: {
                return 0xFF000000 | p << 16 | x << 8 | t;
            }
            case 3: {
                return 0xFF000000 | p << 16 | q << 8 | x;
            }
            case 4: {
                return 0xFF000000 | t << 16 | p << 8 | x;
            }
            case 5: {
                return 0xFF000000 | x << 16 | p << 8 | q;
            }
        }
        return 0;
    }

    public static float[] RGBtoHSB(int red, int green, int blue, float[] hsb) {
        if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
            throw new IllegalArgumentException();
        }
        float r = (float)red / 255.0f;
        float g = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        float h = 0.0f;
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float v = max;
        float s = max != 0.0f ? (max - min) / max : 0.0f;
        if (s != 0.0f) {
            float delta = max - min;
            if (r == max) {
                h = (g - b) / delta;
            } else if (g == max) {
                h = 2.0f + (b - r) / delta;
            } else if (b == max) {
                h = 4.0f + (r - g) / delta;
            }
            h *= 60.0f;
            if (h < 0.0f) {
                h += 360.0f;
            }
            h /= 360.0f;
        }
        if (hsb == null) {
            return new float[]{h, s, v};
        }
        hsb[0] = h;
        hsb[1] = s;
        hsb[2] = v;
        return hsb;
    }

    private static final int getBlue(int rgb) {
        return rgb & 0xFF;
    }

    private static final int getGreen(int rgb) {
        return (rgb & 0xFF00) >> 8;
    }

    private static final int getRed(int rgb) {
        return (rgb & 0xFF0000) >> 16;
    }

    public static void replaceColor(ImageData data, RGB from, RGB to) {
        int x = 0;
        while (x < data.width) {
            int y = 0;
            while (y < data.height) {
                int pixel = data.getPixel(x, y);
                RGB rgb = data.palette.getRGB(pixel);
                if (rgb.equals((Object)from)) {
                    pixel = data.palette.getPixel(to);
                }
                data.setPixel(x, y, pixel);
                ++y;
            }
            ++x;
        }
    }

    public static Color getRelativeColor(Device device, int r, int g, int b) {
        Color baseForeground = Display.getCurrent().getSystemColor(24);
        Color baseBackground = Display.getCurrent().getSystemColor(25);
        int fr = baseForeground.getRed();
        int fg = baseForeground.getGreen();
        int fb = baseForeground.getBlue();
        int br = baseBackground.getRed();
        int bg = baseBackground.getGreen();
        int bb = baseBackground.getBlue();
        int nr = (int)((float)fr + (float)r * (float)(br - fr) / 255.0f);
        int ng = (int)((float)fg + (float)g * (float)(bg - fg) / 255.0f);
        int nb = (int)((float)fb + (float)b * (float)(bb - fb) / 255.0f);
        nr = Math.max(0, nr);
        nr = Math.min(255, nr);
        ng = Math.max(0, ng);
        ng = Math.min(255, ng);
        nb = Math.max(0, nb);
        nb = Math.min(255, nb);
        return new Color(null, nr, ng, nb);
    }

    public static RGB getRelativeRGB(int r, int g, int b) {
        Color baseForeground = Display.getCurrent().getSystemColor(24);
        Color baseBackground = Display.getCurrent().getSystemColor(25);
        int fr = baseForeground.getRed();
        int fg = baseForeground.getGreen();
        int fb = baseForeground.getBlue();
        int br = baseBackground.getRed();
        int bg = baseBackground.getGreen();
        int bb = baseBackground.getBlue();
        int nr = (int)((float)fr + (float)r * (float)(br - fr) / 255.0f);
        int ng = (int)((float)fg + (float)g * (float)(bg - fg) / 255.0f);
        int nb = (int)((float)fb + (float)b * (float)(bb - fb) / 255.0f);
        nr = Math.max(0, nr);
        nr = Math.min(255, nr);
        ng = Math.max(0, ng);
        ng = Math.min(255, ng);
        nb = Math.max(0, nb);
        nb = Math.min(255, nb);
        return new RGB(nr, ng, nb);
    }

    public static Color getRelativeColor(Color c) {
        Color cr = ColorUtils.getRelativeColor(null, c.getRed(), c.getGreen(), c.getBlue());
        c.dispose();
        return cr;
    }

    public static Color getRelativeColorFromSystem(Color c) {
        return ColorUtils.getRelativeColor(null, c.getRed(), c.getGreen(), c.getBlue());
    }

    public static boolean isInvertedColorScheme() {
        Color baseForeground = Display.getCurrent().getSystemColor(24);
        Color baseBackground = Display.getCurrent().getSystemColor(25);
        return baseForeground.getRed() + baseForeground.getBlue() + baseForeground.getGreen() > baseBackground.getRed() + baseBackground.getBlue() + baseBackground.getGreen();
    }

    public static RGB getLightShade(RGB rgb, int numerator, int denominator) {
        int light = 255 * numerator;
        int red = (rgb.red + light) / denominator;
        int green = (rgb.green + light) / denominator;
        int blue = (rgb.blue + light) / denominator;
        return new RGB(red, green, blue);
    }
}

