"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
function cleanupBreakpointResponse(raw) {
    if (Array.isArray(raw.bkpt)) {
        const bkpt = raw.bkpt[0];
        const multiple = raw.bkpt.slice(1);
        return {
            _class: raw._class,
            bkpt,
            multiple,
        };
    }
    return {
        _class: raw._class,
        bkpt: raw.bkpt,
    };
}
function sendBreakInsert(gdb, request) {
    return __awaiter(this, void 0, void 0, function* () {
        // Todo: lots of options
        const temp = request.temporary ? '-t ' : '';
        const ignore = request.ignoreCount ? `-i ${request.ignoreCount} ` : '';
        const source = `--source ${gdb.standardEscape(request.source)}`;
        const line = `--line ${request.line}`;
        const command = `-break-insert ${temp}${ignore}${source} ${line}`;
        const result = yield gdb.sendCommand(command);
        const clean = cleanupBreakpointResponse(result);
        if (request.condition) {
            yield gdb.sendCommand(`-break-condition ${clean.bkpt.number} ${request.condition}`);
        }
        return clean;
    });
}
exports.sendBreakInsert = sendBreakInsert;
function sendBreakDelete(gdb, request) {
    return gdb.sendCommand(`-break-delete ${request.breakpoints.join(' ')}`);
}
exports.sendBreakDelete = sendBreakDelete;
function sendBreakList(gdb) {
    return gdb.sendCommand('-break-list');
}
exports.sendBreakList = sendBreakList;
function sendBreakFunctionInsert(gdb, fn) {
    return __awaiter(this, void 0, void 0, function* () {
        const command = `-break-insert --function ${fn}`;
        const result = yield gdb.sendCommand(command);
        const clean = cleanupBreakpointResponse(result);
        return clean;
    });
}
exports.sendBreakFunctionInsert = sendBreakFunctionInsert;
//# sourceMappingURL=breakpoint.js.map