/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.internal.lifecycle;

import java.io.File;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.components.PomHierarchyComposite;
import org.eclipse.m2e.core.ui.internal.util.ParentHierarchyEntry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LifecycleMappingDialog
extends Dialog
implements ISelectionChangedListener {
    private PomHierarchyComposite pomComposite;
    private CLabel status;
    private IFile pomFile;
    private IMavenProjectFacade facade;
    private String pluginGroupId;
    private String pluginArtifactId;
    private String goal;
    private ParentHierarchyEntry pluginProject;

    public LifecycleMappingDialog(Shell parentShell, IFile pom, String pluginGroupId, String pluginArtifactId, String goal) {
        super(parentShell);
        this.facade = MavenPlugin.getMavenProjectRegistry().create(pom, true, (IProgressMonitor)new NullProgressMonitor());
        this.pluginGroupId = pluginGroupId;
        this.pluginArtifactId = pluginArtifactId;
        this.goal = goal;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NLS.bind((String)"Ignore {0}", (Object)this.goal));
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Label label = new Label(container, 0);
        label.setText("Select location to place ignore");
        this.pomComposite = new PomHierarchyComposite(container, 2048);
        this.pomComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.pomComposite.addSelectionChangedListener((ISelectionChangedListener)this);
        this.pomComposite.computeHeirarchy(this.facade, null);
        this.status = new CLabel(container, 64);
        this.status.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.pluginProject = this.locatePlugin();
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
        if (this.pluginProject != null) {
            this.pomComposite.setSelection((ISelection)new StructuredSelection((Object)this.pluginProject));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ParentHierarchyEntry project = this.pomComposite.fromSelection();
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(project != null && project.getResource() != null);
        }
        this.updateStatus(project);
    }

    private void updateStatus(ParentHierarchyEntry project) {
        if (project.getResource() == null) {
            this.status.setText("Non-workspace pom");
            this.status.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
        } else if (project.equals(this.pluginProject)) {
            this.status.setText("Plugin definition in selected pom.");
            this.status.setImage(null);
        } else {
            this.status.setText("");
            this.status.setImage(null);
        }
    }

    protected void okPressed() {
        this.pomFile = this.pomComposite.fromSelection().getResource();
        super.okPressed();
    }

    public IFile getPomFile() {
        return this.pomFile;
    }

    private ParentHierarchyEntry locatePlugin() {
        MavenProject project = this.facade.getMavenProject();
        Plugin plugin = project.getPlugin(String.valueOf(this.pluginGroupId) + ":" + this.pluginArtifactId);
        if (plugin == null) {
            return null;
        }
        InputLocation location = plugin.getLocation((Object)"");
        if (location == null || location.getSource() == null || location.getSource().getLocation() == null) {
            return null;
        }
        File basedir = new File(location.getSource().getLocation()).getParentFile();
        for (ParentHierarchyEntry other : this.pomComposite.getHierarchy()) {
            if (!basedir.equals(other.getFile().getParentFile())) continue;
            return other;
        }
        return null;
    }
}

