/*
 * Copyright (c) 2019 Ed Merks and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Ed Merks - initial API and implementation
 */
package org.eclipse.net4j.util;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * This class is a major hack to support {@link AccessibleObject#setAccessible(boolean)} in Java 9 or higher.
 * It is used only by {@link ReflectUtil#setValue(Field, Object, Object, boolean)} and then only to call {@link #setNonFinal(Field)}.
 * The other methods are unused but may be useful in the future if we must reflect across module boundaries.
 *
 * @see #setAccessible(Constructor)
 * @see #setAccessible(Field)
 * @see #setAccessible(Method)
 * @see #setNonFinal(Field)
 *
 * @author Ed Merks
 */
final class AccessUtil
{
  /**
   * The following three constants are generated by {@link #main(String[]) invoking the generator}.
   * They capture information about the bytes needed  to generate anonymous classes.
   *
   * @see #main(String[])
   */
  private static final int NAME_PATH_INDEX = 14;

  private static final int NAME_SIGNATURE_INDEX = 878;

  private static final byte[] ACCESS_CONTROLLER_BYTES = new byte[] { //
      (byte)0xca, // 0
      (byte)0xfe, // 1
      (byte)0xba, // 2
      (byte)0xbe, // 3
      0x00, // 4
      0x00, // 5
      0x00, // 6
      0x35, // 5 7
      0x00, // 8
      0x65, // e 9
      0x07, // 10
      0x00, // 11
      0x02, // 12
      0x01, // 13
      // 0x00, //
      // 0x27, // '
      // 0x6f, // o
      // 0x72, // r
      // 0x67, // g
      // 0x2f, // /
      // 0x65, // e
      // 0x78, // x
      // 0x61, // a
      // 0x6d, // m
      // 0x70, // p
      // 0x6c, // l
      // 0x65, // e
      // 0x2f, // /
      // 0x61, // a
      // 0x63, // c
      // 0x63, // c
      // 0x65, // e
      // 0x73, // s
      // 0x73, // s
      // 0x69, // i
      // 0x62, // b
      // 0x6c, // l
      // 0x65, // e
      // 0x2f, // /
      // 0x41, // A
      // 0x63, // c
      // 0x63, // c
      // 0x65, // e
      // 0x73, // s
      // 0x73, // s
      // 0x43, // C
      // 0x6f, // o
      // 0x6e, // n
      // 0x74, // t
      // 0x72, // r
      // 0x6f, // o
      // 0x6c, // l
      // 0x6c, // l
      // 0x65, // e
      // 0x72, // r
      0x07, // 14
      0x00, // 15
      0x04, // 16
      0x01, // 17
      0x00, // 18
      0x10, // 19
      0x6a, // j 20
      0x61, // a 21
      0x76, // v 22
      0x61, // a 23
      0x2f, // / 24
      0x6c, // l 25
      0x61, // a 26
      0x6e, // n 27
      0x67, // g 28
      0x2f, // / 29
      0x4f, // O 30
      0x62, // b 31
      0x6a, // j 32
      0x65, // e 33
      0x63, // c 34
      0x74, // t 35
      0x07, // 36
      0x00, // 37
      0x06, // 38
      0x01, // 39
      0x00, // 40
      0x1b, // 41
      0x6a, // j 42
      0x61, // a 43
      0x76, // v 44
      0x61, // a 45
      0x2f, // / 46
      0x75, // u 47
      0x74, // t 48
      0x69, // i 49
      0x6c, // l 50
      0x2f, // / 51
      0x66, // f 52
      0x75, // u 53
      0x6e, // n 54
      0x63, // c 55
      0x74, // t 56
      0x69, // i 57
      0x6f, // o 58
      0x6e, // n 59
      0x2f, // / 60
      0x43, // C 61
      0x6f, // o 62
      0x6e, // n 63
      0x73, // s 64
      0x75, // u 65
      0x6d, // m 66
      0x65, // e 67
      0x72, // r 68
      0x01, // 69
      0x00, // 70
      0x09, // 71
      0x4d, // M 72
      0x4f, // O 73
      0x44, // D 74
      0x49, // I 75
      0x46, // F 76
      0x49, // I 77
      0x45, // E 78
      0x52, // R 79
      0x53, // S 80
      0x01, // 81
      0x00, // 82
      0x1c, // 83
      0x4c, // L 84
      0x6a, // j 85
      0x61, // a 86
      0x76, // v 87
      0x61, // a 88
      0x2f, // / 89
      0x6c, // l 90
      0x61, // a 91
      0x6e, // n 92
      0x67, // g 93
      0x2f, // / 94
      0x69, // i 95
      0x6e, // n 96
      0x76, // v 97
      0x6f, // o 98
      0x6b, // k 99
      0x65, // e 100
      0x2f, // / 101
      0x56, // V 102
      0x61, // a 103
      0x72, // r 104
      0x48, // H 105
      0x61, // a 106
      0x6e, // n 107
      0x64, // d 108
      0x6c, // l 109
      0x65, // e 110
      0x3b, // ; 111
      0x01, // 112
      0x00, // 113
      0x08, // 114
      0x3c, // < 115
      0x63, // c 116
      0x6c, // l 117
      0x69, // i 118
      0x6e, // n 119
      0x69, // i 120
      0x74, // t 121
      0x3e, // > 122
      0x01, // 123
      0x00, // 124
      0x03, // 125
      0x28, // ( 126
      0x29, // ) 127
      0x56, // V 128
      0x01, // 129
      0x00, // 130
      0x04, // 131
      0x43, // C 132
      0x6f, // o 133
      0x64, // d 134
      0x65, // e 135
      0x07, // 136
      0x00, // 137
      0x0d, // 138
      0x01, // 139
      0x00, // 140
      0x17, // 141
      0x6a, // j 142
      0x61, // a 143
      0x76, // v 144
      0x61, // a 145
      0x2f, // / 146
      0x6c, // l 147
      0x61, // a 148
      0x6e, // n 149
      0x67, // g 150
      0x2f, // / 151
      0x72, // r 152
      0x65, // e 153
      0x66, // f 154
      0x6c, // l 155
      0x65, // e 156
      0x63, // c 157
      0x74, // t 158
      0x2f, // / 159
      0x46, // F 160
      0x69, // i 161
      0x65, // e 162
      0x6c, // l 163
      0x64, // d 164
      0x0a, // 165
      0x00, // 166
      0x0f, // 167
      0x00, // 168
      0x11, // 169
      0x07, // 170
      0x00, // 171
      0x10, // 172
      0x01, // 173
      0x00, // 174
      0x1e, // 175
      0x6a, // j 176
      0x61, // a 177
      0x76, // v 178
      0x61, // a 179
      0x2f, // / 180
      0x6c, // l 181
      0x61, // a 182
      0x6e, // n 183
      0x67, // g 184
      0x2f, // / 185
      0x69, // i 186
      0x6e, // n 187
      0x76, // v 188
      0x6f, // o 189
      0x6b, // k 190
      0x65, // e 191
      0x2f, // / 192
      0x4d, // M 193
      0x65, // e 194
      0x74, // t 195
      0x68, // h 196
      0x6f, // o 197
      0x64, // d 198
      0x48, // H 199
      0x61, // a 200
      0x6e, // n 201
      0x64, // d 202
      0x6c, // l 203
      0x65, // e 204
      0x73, // s 205
      0x0c, // 206
      0x00, // 207
      0x12, // 208
      0x00, // 209
      0x13, // 210
      0x01, // 211
      0x00, // 212
      0x06, // 213
      0x6c, // l 214
      0x6f, // o 215
      0x6f, // o 216
      0x6b, // k 217
      0x75, // u 218
      0x70, // p 219
      0x01, // 220
      0x00, // 221
      0x29, // ) 222
      0x28, // ( 223
      0x29, // ) 224
      0x4c, // L 225
      0x6a, // j 226
      0x61, // a 227
      0x76, // v 228
      0x61, // a 229
      0x2f, // / 230
      0x6c, // l 231
      0x61, // a 232
      0x6e, // n 233
      0x67, // g 234
      0x2f, // / 235
      0x69, // i 236
      0x6e, // n 237
      0x76, // v 238
      0x6f, // o 239
      0x6b, // k 240
      0x65, // e 241
      0x2f, // / 242
      0x4d, // M 243
      0x65, // e 244
      0x74, // t 245
      0x68, // h 246
      0x6f, // o 247
      0x64, // d 248
      0x48, // H 249
      0x61, // a 250
      0x6e, // n 251
      0x64, // d 252
      0x6c, // l 253
      0x65, // e 254
      0x73, // s 255
      0x24, // $ 256
      0x4c, // L 257
      0x6f, // o 258
      0x6f, // o 259
      0x6b, // k 260
      0x75, // u 261
      0x70, // p 262
      0x3b, // ; 263
      0x0a, // 264
      0x00, // 265
      0x0f, // 266
      0x00, // 267
      0x15, // 268
      0x0c, // 269
      0x00, // 270
      0x16, // 271
      0x00, // 272
      0x17, // 273
      0x01, // 274
      0x00, // 275
      0x0f, // 276
      0x70, // p 277
      0x72, // r 278
      0x69, // i 279
      0x76, // v 280
      0x61, // a 281
      0x74, // t 282
      0x65, // e 283
      0x4c, // L 284
      0x6f, // o 285
      0x6f, // o 286
      0x6b, // k 287
      0x75, // u 288
      0x70, // p 289
      0x49, // I 290
      0x6e, // n 291
      0x01, // 292
      0x00, // 293
      0x61, // a 294
      0x28, // ( 295
      0x4c, // L 296
      0x6a, // j 297
      0x61, // a 298
      0x76, // v 299
      0x61, // a 300
      0x2f, // / 301
      0x6c, // l 302
      0x61, // a 303
      0x6e, // n 304
      0x67, // g 305
      0x2f, // / 306
      0x43, // C 307
      0x6c, // l 308
      0x61, // a 309
      0x73, // s 310
      0x73, // s 311
      0x3b, // ; 312
      0x4c, // L 313
      0x6a, // j 314
      0x61, // a 315
      0x76, // v 316
      0x61, // a 317
      0x2f, // / 318
      0x6c, // l 319
      0x61, // a 320
      0x6e, // n 321
      0x67, // g 322
      0x2f, // / 323
      0x69, // i 324
      0x6e, // n 325
      0x76, // v 326
      0x6f, // o 327
      0x6b, // k 328
      0x65, // e 329
      0x2f, // / 330
      0x4d, // M 331
      0x65, // e 332
      0x74, // t 333
      0x68, // h 334
      0x6f, // o 335
      0x64, // d 336
      0x48, // H 337
      0x61, // a 338
      0x6e, // n 339
      0x64, // d 340
      0x6c, // l 341
      0x65, // e 342
      0x73, // s 343
      0x24, // $ 344
      0x4c, // L 345
      0x6f, // o 346
      0x6f, // o 347
      0x6b, // k 348
      0x75, // u 349
      0x70, // p 350
      0x3b, // ; 351
      0x29, // ) 352
      0x4c, // L 353
      0x6a, // j 354
      0x61, // a 355
      0x76, // v 356
      0x61, // a 357
      0x2f, // / 358
      0x6c, // l 359
      0x61, // a 360
      0x6e, // n 361
      0x67, // g 362
      0x2f, // / 363
      0x69, // i 364
      0x6e, // n 365
      0x76, // v 366
      0x6f, // o 367
      0x6b, // k 368
      0x65, // e 369
      0x2f, // / 370
      0x4d, // M 371
      0x65, // e 372
      0x74, // t 373
      0x68, // h 374
      0x6f, // o 375
      0x64, // d 376
      0x48, // H 377
      0x61, // a 378
      0x6e, // n 379
      0x64, // d 380
      0x6c, // l 381
      0x65, // e 382
      0x73, // s 383
      0x24, // $ 384
      0x4c, // L 385
      0x6f, // o 386
      0x6f, // o 387
      0x6b, // k 388
      0x75, // u 389
      0x70, // p 390
      0x3b, // ; 391
      0x08, // 392
      0x00, // 393
      0x19, // 394
      0x01, // 395
      0x00, // 396
      0x09, // 397
      0x6d, // m 398
      0x6f, // o 399
      0x64, // d 400
      0x69, // i 401
      0x66, // f 402
      0x69, // i 403
      0x65, // e 404
      0x72, // r 405
      0x73, // s 406
      0x09, // 407
      0x00, // 408
      0x1b, // 409
      0x00, // 410
      0x1d, // 411
      0x07, // 412
      0x00, // 413
      0x1c, // 414
      0x01, // 415
      0x00, // 416
      0x11, // 417
      0x6a, // j 418
      0x61, // a 419
      0x76, // v 420
      0x61, // a 421
      0x2f, // / 422
      0x6c, // l 423
      0x61, // a 424
      0x6e, // n 425
      0x67, // g 426
      0x2f, // / 427
      0x49, // I 428
      0x6e, // n 429
      0x74, // t 430
      0x65, // e 431
      0x67, // g 432
      0x65, // e 433
      0x72, // r 434
      0x0c, // 435
      0x00, // 436
      0x1e, // 437
      0x00, // 438
      0x1f, // 439
      0x01, // 440
      0x00, // 441
      0x04, // 442
      0x54, // T 443
      0x59, // Y 444
      0x50, // P 445
      0x45, // E 446
      0x01, // 447
      0x00, // 448
      0x11, // 449
      0x4c, // L 450
      0x6a, // j 451
      0x61, // a 452
      0x76, // v 453
      0x61, // a 454
      0x2f, // / 455
      0x6c, // l 456
      0x61, // a 457
      0x6e, // n 458
      0x67, // g 459
      0x2f, // / 460
      0x43, // C 461
      0x6c, // l 462
      0x61, // a 463
      0x73, // s 464
      0x73, // s 465
      0x3b, // ; 466
      0x0a, // 467
      0x00, // 468
      0x21, // ! 469
      0x00, // 470
      0x23, // # 471
      0x07, // 472
      0x00, // 473
      0x22, // " 474
      0x01, // 475
      0x00, // 476
      0x25, // % 477
      0x6a, // j 478
      0x61, // a 479
      0x76, // v 480
      0x61, // a 481
      0x2f, // / 482
      0x6c, // l 483
      0x61, // a 484
      0x6e, // n 485
      0x67, // g 486
      0x2f, // / 487
      0x69, // i 488
      0x6e, // n 489
      0x76, // v 490
      0x6f, // o 491
      0x6b, // k 492
      0x65, // e 493
      0x2f, // / 494
      0x4d, // M 495
      0x65, // e 496
      0x74, // t 497
      0x68, // h 498
      0x6f, // o 499
      0x64, // d 500
      0x48, // H 501
      0x61, // a 502
      0x6e, // n 503
      0x64, // d 504
      0x6c, // l 505
      0x65, // e 506
      0x73, // s 507
      0x24, // $ 508
      0x4c, // L 509
      0x6f, // o 510
      0x6f, // o 511
      0x6b, // k 512
      0x75, // u 513
      0x70, // p 514
      0x0c, // 515
      0x00, // 516
      0x24, // $ 517
      0x00, // 518
      0x25, // % 519
      0x01, // 520
      0x00, // 521
      0x0d, // 522
      0x66, // f 523
      0x69, // i 524
      0x6e, // n 525
      0x64, // d 526
      0x56, // V 527
      0x61, // a 528
      0x72, // r 529
      0x48, // H 530
      0x61, // a 531
      0x6e, // n 532
      0x64, // d 533
      0x6c, // l 534
      0x65, // e 535
      0x01, // 536
      0x00, // 537
      0x52, // R 538
      0x28, // ( 539
      0x4c, // L 540
      0x6a, // j 541
      0x61, // a 542
      0x76, // v 543
      0x61, // a 544
      0x2f, // / 545
      0x6c, // l 546
      0x61, // a 547
      0x6e, // n 548
      0x67, // g 549
      0x2f, // / 550
      0x43, // C 551
      0x6c, // l 552
      0x61, // a 553
      0x73, // s 554
      0x73, // s 555
      0x3b, // ; 556
      0x4c, // L 557
      0x6a, // j 558
      0x61, // a 559
      0x76, // v 560
      0x61, // a 561
      0x2f, // / 562
      0x6c, // l 563
      0x61, // a 564
      0x6e, // n 565
      0x67, // g 566
      0x2f, // / 567
      0x53, // S 568
      0x74, // t 569
      0x72, // r 570
      0x69, // i 571
      0x6e, // n 572
      0x67, // g 573
      0x3b, // ; 574
      0x4c, // L 575
      0x6a, // j 576
      0x61, // a 577
      0x76, // v 578
      0x61, // a 579
      0x2f, // / 580
      0x6c, // l 581
      0x61, // a 582
      0x6e, // n 583
      0x67, // g 584
      0x2f, // / 585
      0x43, // C 586
      0x6c, // l 587
      0x61, // a 588
      0x73, // s 589
      0x73, // s 590
      0x3b, // ; 591
      0x29, // ) 592
      0x4c, // L 593
      0x6a, // j 594
      0x61, // a 595
      0x76, // v 596
      0x61, // a 597
      0x2f, // / 598
      0x6c, // l 599
      0x61, // a 600
      0x6e, // n 601
      0x67, // g 602
      0x2f, // / 603
      0x69, // i 604
      0x6e, // n 605
      0x76, // v 606
      0x6f, // o 607
      0x6b, // k 608
      0x65, // e 609
      0x2f, // / 610
      0x56, // V 611
      0x61, // a 612
      0x72, // r 613
      0x48, // H 614
      0x61, // a 615
      0x6e, // n 616
      0x64, // d 617
      0x6c, // l 618
      0x65, // e 619
      0x3b, // ; 620
      0x09, // 621
      0x00, // 622
      0x01, // 623
      0x00, // 624
      0x27, // ' 625
      0x0c, // 626
      0x00, // 627
      0x07, // 628
      0x00, // 629
      0x08, // 630
      0x07, // 631
      0x00, // 632
      0x29, // ) 633
      0x01, // 634
      0x00, // 635
      0x1a, // 636
      0x6a, // j 637
      0x61, // a 638
      0x76, // v 639
      0x61, // a 640
      0x2f, // / 641
      0x6c, // l 642
      0x61, // a 643
      0x6e, // n 644
      0x67, // g 645
      0x2f, // / 646
      0x52, // R 647
      0x75, // u 648
      0x6e, // n 649
      0x74, // t 650
      0x69, // i 651
      0x6d, // m 652
      0x65, // e 653
      0x45, // E 654
      0x78, // x 655
      0x63, // c 656
      0x65, // e 657
      0x70, // p 658
      0x74, // t 659
      0x69, // i 660
      0x6f, // o 661
      0x6e, // n 662
      0x0a, // 663
      0x00, // 664
      0x28, // ( 665
      0x00, // 666
      0x2b, // + 667
      0x0c, // 668
      0x00, // 669
      0x2c, // , 670
      0x00, // 671
      0x2d, // - 672
      0x01, // 673
      0x00, // 674
      0x06, // 675
      0x3c, // < 676
      0x69, // i 677
      0x6e, // n 678
      0x69, // i 679
      0x74, // t 680
      0x3e, // > 681
      0x01, // 682
      0x00, // 683
      0x18, // 684
      0x28, // ( 685
      0x4c, // L 686
      0x6a, // j 687
      0x61, // a 688
      0x76, // v 689
      0x61, // a 690
      0x2f, // / 691
      0x6c, // l 692
      0x61, // a 693
      0x6e, // n 694
      0x67, // g 695
      0x2f, // / 696
      0x54, // T 697
      0x68, // h 698
      0x72, // r 699
      0x6f, // o 700
      0x77, // w 701
      0x61, // a 702
      0x62, // b 703
      0x6c, // l 704
      0x65, // e 705
      0x3b, // ; 706
      0x29, // ) 707
      0x56, // V 708
      0x07, // 709
      0x00, // 710
      0x2f, // / 711
      0x01, // 712
      0x00, // 713
      0x13, // 714
      0x6a, // j 715
      0x61, // a 716
      0x76, // v 717
      0x61, // a 718
      0x2f, // / 719
      0x6c, // l 720
      0x61, // a 721
      0x6e, // n 722
      0x67, // g 723
      0x2f, // / 724
      0x54, // T 725
      0x68, // h 726
      0x72, // r 727
      0x6f, // o 728
      0x77, // w 729
      0x61, // a 730
      0x62, // b 731
      0x6c, // l 732
      0x65, // e 733
      0x01, // 734
      0x00, // 735
      0x0f, // 736
      0x4c, // L 737
      0x69, // i 738
      0x6e, // n 739
      0x65, // e 740
      0x4e, // N 741
      0x75, // u 742
      0x6d, // m 743
      0x62, // b 744
      0x65, // e 745
      0x72, // r 746
      0x54, // T 747
      0x61, // a 748
      0x62, // b 749
      0x6c, // l 750
      0x65, // e 751
      0x01, // 752
      0x00, // 753
      0x12, // 754
      0x4c, // L 755
      0x6f, // o 756
      0x63, // c 757
      0x61, // a 758
      0x6c, // l 759
      0x56, // V 760
      0x61, // a 761
      0x72, // r 762
      0x69, // i 763
      0x61, // a 764
      0x62, // b 765
      0x6c, // l 766
      0x65, // e 767
      0x54, // T 768
      0x61, // a 769
      0x62, // b 770
      0x6c, // l 771
      0x65, // e 772
      0x01, // 773
      0x00, // 774
      0x27, // ' 775
      0x4c, // L 776
      0x6a, // j 777
      0x61, // a 778
      0x76, // v 779
      0x61, // a 780
      0x2f, // / 781
      0x6c, // l 782
      0x61, // a 783
      0x6e, // n 784
      0x67, // g 785
      0x2f, // / 786
      0x69, // i 787
      0x6e, // n 788
      0x76, // v 789
      0x6f, // o 790
      0x6b, // k 791
      0x65, // e 792
      0x2f, // / 793
      0x4d, // M 794
      0x65, // e 795
      0x74, // t 796
      0x68, // h 797
      0x6f, // o 798
      0x64, // d 799
      0x48, // H 800
      0x61, // a 801
      0x6e, // n 802
      0x64, // d 803
      0x6c, // l 804
      0x65, // e 805
      0x73, // s 806
      0x24, // $ 807
      0x4c, // L 808
      0x6f, // o 809
      0x6f, // o 810
      0x6b, // k 811
      0x75, // u 812
      0x70, // p 813
      0x3b, // ; 814
      0x01, // 815
      0x00, // 816
      0x02, // 817
      0x65, // e 818
      0x78, // x 819
      0x01, // 820
      0x00, // 821
      0x15, // 822
      0x4c, // L 823
      0x6a, // j 824
      0x61, // a 825
      0x76, // v 826
      0x61, // a 827
      0x2f, // / 828
      0x6c, // l 829
      0x61, // a 830
      0x6e, // n 831
      0x67, // g 832
      0x2f, // / 833
      0x54, // T 834
      0x68, // h 835
      0x72, // r 836
      0x6f, // o 837
      0x77, // w 838
      0x61, // a 839
      0x62, // b 840
      0x6c, // l 841
      0x65, // e 842
      0x3b, // ; 843
      0x01, // 844
      0x00, // 845
      0x0d, // 846
      0x53, // S 847
      0x74, // t 848
      0x61, // a 849
      0x63, // c 850
      0x6b, // k 851
      0x4d, // M 852
      0x61, // a 853
      0x70, // p 854
      0x54, // T 855
      0x61, // a 856
      0x62, // b 857
      0x6c, // l 858
      0x65, // e 859
      0x0a, // 860
      0x00, // 861
      0x03, // 862
      0x00, // 863
      0x37, // 7 864
      0x0c, // 865
      0x00, // 866
      0x2c, // , 867
      0x00, // 868
      0x0a, // 869
      0x01, // 870
      0x00, // 871
      0x04, // 872
      0x74, // t 873
      0x68, // h 874
      0x69, // i 875
      0x73, // s 876
      0x01, // 877
      // 0x00, //
      // 0x29, // )
      // 0x4c, // L
      // 0x6f, // o
      // 0x72, // r
      // 0x67, // g
      // 0x2f, // /
      // 0x65, // e
      // 0x78, // x
      // 0x61, // a
      // 0x6d, // m
      // 0x70, // p
      // 0x6c, // l
      // 0x65, // e
      // 0x2f, // /
      // 0x61, // a
      // 0x63, // c
      // 0x63, // c
      // 0x65, // e
      // 0x73, // s
      // 0x73, // s
      // 0x69, // i
      // 0x62, // b
      // 0x6c, // l
      // 0x65, // e
      // 0x2f, // /
      // 0x41, // A
      // 0x63, // c
      // 0x63, // c
      // 0x65, // e
      // 0x73, // s
      // 0x73, // s
      // 0x43, // C
      // 0x6f, // o
      // 0x6e, // n
      // 0x74, // t
      // 0x72, // r
      // 0x6f, // o
      // 0x6c, // l
      // 0x6c, // l
      // 0x65, // e
      // 0x72, // r
      // 0x3b, // ;
      0x01, // 878
      0x00, // 879
      0x0c, // 880
      0x6d, // m 881
      0x61, // a 882
      0x6b, // k 883
      0x65, // e 884
      0x4e, // N 885
      0x6f, // o 886
      0x6e, // n 887
      0x46, // F 888
      0x69, // i 889
      0x6e, // n 890
      0x61, // a 891
      0x6c, // l 892
      0x01, // 893
      0x00, // 894
      0x1c, // 895
      0x28, // ( 896
      0x4c, // L 897
      0x6a, // j 898
      0x61, // a 899
      0x76, // v 900
      0x61, // a 901
      0x2f, // / 902
      0x6c, // l 903
      0x61, // a 904
      0x6e, // n 905
      0x67, // g 906
      0x2f, // / 907
      0x72, // r 908
      0x65, // e 909
      0x66, // f 910
      0x6c, // l 911
      0x65, // e 912
      0x63, // c 913
      0x74, // t 914
      0x2f, // / 915
      0x46, // F 916
      0x69, // i 917
      0x65, // e 918
      0x6c, // l 919
      0x64, // d 920
      0x3b, // ; 921
      0x29, // ) 922
      0x56, // V 923
      0x0a, // 924
      0x00, // 925
      0x0c, // 926
      0x00, // 927
      0x3d, // = 928
      0x0c, // 929
      0x00, // 930
      0x3e, // > 931
      0x00, // 932
      0x3f, // ? 933
      0x01, // 934
      0x00, // 935
      0x0c, // 936
      0x67, // g 937
      0x65, // e 938
      0x74, // t 939
      0x4d, // M 940
      0x6f, // o 941
      0x64, // d 942
      0x69, // i 943
      0x66, // f 944
      0x69, // i 945
      0x65, // e 946
      0x72, // r 947
      0x73, // s 948
      0x01, // 949
      0x00, // 950
      0x03, // 951
      0x28, // ( 952
      0x29, // ) 953
      0x49, // I 954
      0x0a, // 955
      0x00, // 956
      0x41, // A 957
      0x00, // 958
      0x43, // C 959
      0x07, // 960
      0x00, // 961
      0x42, // B 962
      0x01, // 963
      0x00, // 964
      0x1a, // 965
      0x6a, // j 966
      0x61, // a 967
      0x76, // v 968
      0x61, // a 969
      0x2f, // / 970
      0x6c, // l 971
      0x61, // a 972
      0x6e, // n 973
      0x67, // g 974
      0x2f, // / 975
      0x72, // r 976
      0x65, // e 977
      0x66, // f 978
      0x6c, // l 979
      0x65, // e 980
      0x63, // c 981
      0x74, // t 982
      0x2f, // / 983
      0x4d, // M 984
      0x6f, // o 985
      0x64, // d 986
      0x69, // i 987
      0x66, // f 988
      0x69, // i 989
      0x65, // e 990
      0x72, // r 991
      0x0c, // 992
      0x00, // 993
      0x44, // D 994
      0x00, // 995
      0x45, // E 996
      0x01, // 997
      0x00, // 998
      0x07, // 999
      0x69, // i 1000
      0x73, // s 1001
      0x46, // F 1002
      0x69, // i 1003
      0x6e, // n 1004
      0x61, // a 1005
      0x6c, // l 1006
      0x01, // 1007
      0x00, // 1008
      0x04, // 1009
      0x28, // ( 1010
      0x49, // I 1011
      0x29, // ) 1012
      0x5a, // Z 1013
      0x0a, // 1014
      0x00, // 1015
      0x47, // G 1016
      0x00, // 1017
      0x49, // I 1018
      0x07, // 1019
      0x00, // 1020
      0x48, // H 1021
      0x01, // 1022
      0x00, // 1023
      0x1a, // 1024
      0x6a, // j 1025
      0x61, // a 1026
      0x76, // v 1027
      0x61, // a 1028
      0x2f, // / 1029
      0x6c, // l 1030
      0x61, // a 1031
      0x6e, // n 1032
      0x67, // g 1033
      0x2f, // / 1034
      0x69, // i 1035
      0x6e, // n 1036
      0x76, // v 1037
      0x6f, // o 1038
      0x6b, // k 1039
      0x65, // e 1040
      0x2f, // / 1041
      0x56, // V 1042
      0x61, // a 1043
      0x72, // r 1044
      0x48, // H 1045
      0x61, // a 1046
      0x6e, // n 1047
      0x64, // d 1048
      0x6c, // l 1049
      0x65, // e 1050
      0x0c, // 1051
      0x00, // 1052
      0x4a, // J 1053
      0x00, // 1054
      0x4b, // K 1055
      0x01, // 1056
      0x00, // 1057
      0x03, // 1058
      0x73, // s 1059
      0x65, // e 1060
      0x74, // t 1061
      0x01, // 1062
      0x00, // 1063
      0x1d, // 1064
      0x28, // ( 1065
      0x4c, // L 1066
      0x6a, // j 1067
      0x61, // a 1068
      0x76, // v 1069
      0x61, // a 1070
      0x2f, // / 1071
      0x6c, // l 1072
      0x61, // a 1073
      0x6e, // n 1074
      0x67, // g 1075
      0x2f, // / 1076
      0x72, // r 1077
      0x65, // e 1078
      0x66, // f 1079
      0x6c, // l 1080
      0x65, // e 1081
      0x63, // c 1082
      0x74, // t 1083
      0x2f, // / 1084
      0x46, // F 1085
      0x69, // i 1086
      0x65, // e 1087
      0x6c, // l 1088
      0x64, // d 1089
      0x3b, // ; 1090
      0x49, // I 1091
      0x29, // ) 1092
      0x56, // V 1093
      0x01, // 1094
      0x00, // 1095
      0x05, // 1096
      0x66, // f 1097
      0x69, // i 1098
      0x65, // e 1099
      0x6c, // l 1100
      0x64, // d 1101
      0x01, // 1102
      0x00, // 1103
      0x19, // 1104
      0x4c, // L 1105
      0x6a, // j 1106
      0x61, // a 1107
      0x76, // v 1108
      0x61, // a 1109
      0x2f, // / 1110
      0x6c, // l 1111
      0x61, // a 1112
      0x6e, // n 1113
      0x67, // g 1114
      0x2f, // / 1115
      0x72, // r 1116
      0x65, // e 1117
      0x66, // f 1118
      0x6c, // l 1119
      0x65, // e 1120
      0x63, // c 1121
      0x74, // t 1122
      0x2f, // / 1123
      0x46, // F 1124
      0x69, // i 1125
      0x65, // e 1126
      0x6c, // l 1127
      0x64, // d 1128
      0x3b, // ; 1129
      0x01, // 1130
      0x00, // 1131
      0x04, // 1132
      0x6d, // m 1133
      0x6f, // o 1134
      0x64, // d 1135
      0x73, // s 1136
      0x01, // 1137
      0x00, // 1138
      0x01, // 1139
      0x49, // I 1140
      0x01, // 1141
      0x00, // 1142
      0x06, // 1143
      0x61, // a 1144
      0x63, // c 1145
      0x63, // c 1146
      0x65, // e 1147
      0x70, // p 1148
      0x74, // t 1149
      0x01, // 1150
      0x00, // 1151
      0x27, // ' 1152
      0x28, // ( 1153
      0x4c, // L 1154
      0x6a, // j 1155
      0x61, // a 1156
      0x76, // v 1157
      0x61, // a 1158
      0x2f, // / 1159
      0x6c, // l 1160
      0x61, // a 1161
      0x6e, // n 1162
      0x67, // g 1163
      0x2f, // / 1164
      0x72, // r 1165
      0x65, // e 1166
      0x66, // f 1167
      0x6c, // l 1168
      0x65, // e 1169
      0x63, // c 1170
      0x74, // t 1171
      0x2f, // / 1172
      0x41, // A 1173
      0x63, // c 1174
      0x63, // c 1175
      0x65, // e 1176
      0x73, // s 1177
      0x73, // s 1178
      0x69, // i 1179
      0x62, // b 1180
      0x6c, // l 1181
      0x65, // e 1182
      0x4f, // O 1183
      0x62, // b 1184
      0x6a, // j 1185
      0x65, // e 1186
      0x63, // c 1187
      0x74, // t 1188
      0x3b, // ; 1189
      0x29, // ) 1190
      0x56, // V 1191
      0x0a, // 1192
      0x00, // 1193
      0x53, // S 1194
      0x00, // 1195
      0x55, // U 1196
      0x07, // 1197
      0x00, // 1198
      0x54, // T 1199
      0x01, // 1200
      0x00, // 1201
      0x22, // " 1202
      0x6a, // j 1203
      0x61, // a 1204
      0x76, // v 1205
      0x61, // a 1206
      0x2f, // / 1207
      0x6c, // l 1208
      0x61, // a 1209
      0x6e, // n 1210
      0x67, // g 1211
      0x2f, // / 1212
      0x72, // r 1213
      0x65, // e 1214
      0x66, // f 1215
      0x6c, // l 1216
      0x65, // e 1217
      0x63, // c 1218
      0x74, // t 1219
      0x2f, // / 1220
      0x41, // A 1221
      0x63, // c 1222
      0x63, // c 1223
      0x65, // e 1224
      0x73, // s 1225
      0x73, // s 1226
      0x69, // i 1227
      0x62, // b 1228
      0x6c, // l 1229
      0x65, // e 1230
      0x4f, // O 1231
      0x62, // b 1232
      0x6a, // j 1233
      0x65, // e 1234
      0x63, // c 1235
      0x74, // t 1236
      0x0c, // 1237
      0x00, // 1238
      0x56, // V 1239
      0x00, // 1240
      0x57, // W 1241
      0x01, // 1242
      0x00, // 1243
      0x0d, // 1244
      0x73, // s 1245
      0x65, // e 1246
      0x74, // t 1247
      0x41, // A 1248
      0x63, // c 1249
      0x63, // c 1250
      0x65, // e 1251
      0x73, // s 1252
      0x73, // s 1253
      0x69, // i 1254
      0x62, // b 1255
      0x6c, // l 1256
      0x65, // e 1257
      0x01, // 1258
      0x00, // 1259
      0x04, // 1260
      0x28, // ( 1261
      0x5a, // Z 1262
      0x29, // ) 1263
      0x56, // V 1264
      0x0a, // 1265
      0x00, // 1266
      0x01, // 1267
      0x00, // 1268
      0x59, // Y 1269
      0x0c, // 1270
      0x00, // 1271
      0x3a, // : 1272
      0x00, // 1273
      0x3b, // ; 1274
      0x01, // 1275
      0x00, // 1276
      0x10, // 1277
      0x61, // a 1278
      0x63, // c 1279
      0x63, // c 1280
      0x65, // e 1281
      0x73, // s 1282
      0x73, // s 1283
      0x69, // i 1284
      0x62, // b 1285
      0x6c, // l 1286
      0x65, // e 1287
      0x4f, // O 1288
      0x62, // b 1289
      0x6a, // j 1290
      0x65, // e 1291
      0x63, // c 1292
      0x74, // t 1293
      0x01, // 1294
      0x00, // 1295
      0x24, // $ 1296
      0x4c, // L 1297
      0x6a, // j 1298
      0x61, // a 1299
      0x76, // v 1300
      0x61, // a 1301
      0x2f, // / 1302
      0x6c, // l 1303
      0x61, // a 1304
      0x6e, // n 1305
      0x67, // g 1306
      0x2f, // / 1307
      0x72, // r 1308
      0x65, // e 1309
      0x66, // f 1310
      0x6c, // l 1311
      0x65, // e 1312
      0x63, // c 1313
      0x74, // t 1314
      0x2f, // / 1315
      0x41, // A 1316
      0x63, // c 1317
      0x63, // c 1318
      0x65, // e 1319
      0x73, // s 1320
      0x73, // s 1321
      0x69, // i 1322
      0x62, // b 1323
      0x6c, // l 1324
      0x65, // e 1325
      0x4f, // O 1326
      0x62, // b 1327
      0x6a, // j 1328
      0x65, // e 1329
      0x63, // c 1330
      0x74, // t 1331
      0x3b, // ; 1332
      0x01, // 1333
      0x00, // 1334
      0x15, // 1335
      0x28, // ( 1336
      0x4c, // L 1337
      0x6a, // j 1338
      0x61, // a 1339
      0x76, // v 1340
      0x61, // a 1341
      0x2f, // / 1342
      0x6c, // l 1343
      0x61, // a 1344
      0x6e, // n 1345
      0x67, // g 1346
      0x2f, // / 1347
      0x4f, // O 1348
      0x62, // b 1349
      0x6a, // j 1350
      0x65, // e 1351
      0x63, // c 1352
      0x74, // t 1353
      0x3b, // ; 1354
      0x29, // ) 1355
      0x56, // V 1356
      0x0a, // 1357
      0x00, // 1358
      0x01, // 1359
      0x00, // 1360
      0x5e, // ^ 1361
      0x0c, // 1362
      0x00, // 1363
      0x50, // P 1364
      0x00, // 1365
      0x51, // Q 1366
      0x01, // 1367
      0x00, // 1368
      0x0a, // 1369
      0x53, // S 1370
      0x6f, // o 1371
      0x75, // u 1372
      0x72, // r 1373
      0x63, // c 1374
      0x65, // e 1375
      0x46, // F 1376
      0x69, // i 1377
      0x6c, // l 1378
      0x65, // e 1379
      0x01, // 1380
      0x00, // 1381
      0x0f, // 1382
      0x41, // A 1383
      0x63, // c 1384
      0x63, // c 1385
      0x65, // e 1386
      0x73, // s 1387
      0x73, // s 1388
      0x55, // U 1389
      0x74, // t 1390
      0x69, // i 1391
      0x6c, // l 1392
      0x2e, // . 1393
      0x6a, // j 1394
      0x61, // a 1395
      0x76, // v 1396
      0x61, // a 1397
      0x01, // 1398
      0x00, // 1399
      0x09, // 1400
      0x53, // S 1401
      0x69, // i 1402
      0x67, // g 1403
      0x6e, // n 1404
      0x61, // a 1405
      0x74, // t 1406
      0x75, // u 1407
      0x72, // r 1408
      0x65, // e 1409
      0x01, // 1410
      0x00, // 1411
      0x55, // U 1412
      0x4c, // L 1413
      0x6a, // j 1414
      0x61, // a 1415
      0x76, // v 1416
      0x61, // a 1417
      0x2f, // / 1418
      0x6c, // l 1419
      0x61, // a 1420
      0x6e, // n 1421
      0x67, // g 1422
      0x2f, // / 1423
      0x4f, // O 1424
      0x62, // b 1425
      0x6a, // j 1426
      0x65, // e 1427
      0x63, // c 1428
      0x74, // t 1429
      0x3b, // ; 1430
      0x4c, // L 1431
      0x6a, // j 1432
      0x61, // a 1433
      0x76, // v 1434
      0x61, // a 1435
      0x2f, // / 1436
      0x75, // u 1437
      0x74, // t 1438
      0x69, // i 1439
      0x6c, // l 1440
      0x2f, // / 1441
      0x66, // f 1442
      0x75, // u 1443
      0x6e, // n 1444
      0x63, // c 1445
      0x74, // t 1446
      0x69, // i 1447
      0x6f, // o 1448
      0x6e, // n 1449
      0x2f, // / 1450
      0x43, // C 1451
      0x6f, // o 1452
      0x6e, // n 1453
      0x73, // s 1454
      0x75, // u 1455
      0x6d, // m 1456
      0x65, // e 1457
      0x72, // r 1458
      0x3c, // < 1459
      0x4c, // L 1460
      0x6a, // j 1461
      0x61, // a 1462
      0x76, // v 1463
      0x61, // a 1464
      0x2f, // / 1465
      0x6c, // l 1466
      0x61, // a 1467
      0x6e, // n 1468
      0x67, // g 1469
      0x2f, // / 1470
      0x72, // r 1471
      0x65, // e 1472
      0x66, // f 1473
      0x6c, // l 1474
      0x65, // e 1475
      0x63, // c 1476
      0x74, // t 1477
      0x2f, // / 1478
      0x41, // A 1479
      0x63, // c 1480
      0x63, // c 1481
      0x65, // e 1482
      0x73, // s 1483
      0x73, // s 1484
      0x69, // i 1485
      0x62, // b 1486
      0x6c, // l 1487
      0x65, // e 1488
      0x4f, // O 1489
      0x62, // b 1490
      0x6a, // j 1491
      0x65, // e 1492
      0x63, // c 1493
      0x74, // t 1494
      0x3b, // ; 1495
      0x3e, // > 1496
      0x3b, // ; 1497
      0x01, // 1498
      0x00, // 1499
      0x0c, // 1500
      0x49, // I 1501
      0x6e, // n 1502
      0x6e, // n 1503
      0x65, // e 1504
      0x72, // r 1505
      0x43, // C 1506
      0x6c, // l 1507
      0x61, // a 1508
      0x73, // s 1509
      0x73, // s 1510
      0x65, // e 1511
      0x73, // s 1512
      0x01, // 1513
      0x00, // 1514
      0x06, // 1515
      0x4c, // L 1516
      0x6f, // o 1517
      0x6f, // o 1518
      0x6b, // k 1519
      0x75, // u 1520
      0x70, // p 1521
      0x00, // 1522
      0x20, // 1523
      0x00, // 1524
      0x01, // 1525
      0x00, // 1526
      0x03, // 1527
      0x00, // 1528
      0x01, // 1529
      0x00, // 1530
      0x05, // 1531
      0x00, // 1532
      0x01, // 1533
      0x00, // 1534
      0x1a, // 1535
      0x00, // 1536
      0x07, // 1537
      0x00, // 1538
      0x08, // 1539
      0x00, // 1540
      0x00, // 1541
      0x00, // 1542
      0x05, // 1543
      0x00, // 1544
      0x08, // 1545
      0x00, // 1546
      0x09, // 1547
      0x00, // 1548
      0x0a, // 1549
      0x00, // 1550
      0x01, // 1551
      0x00, // 1552
      0x0b, // 1553
      0x00, // 1554
      0x00, // 1555
      0x00, // 1556
      0x7e, // ~ 1557
      0x00, // 1558
      0x04, // 1559
      0x00, // 1560
      0x01, // 1561
      0x00, // 1562
      0x00, // 1563
      0x00, // 1564
      0x25, // % 1565
      0x12, // 1566
      0x0c, // 1567
      (byte)0xb8, // 1568
      0x00, // 1569
      0x0e, // 1570
      (byte)0xb8, // 1571
      0x00, // 1572
      0x14, // 1573
      0x4b, // K 1574
      0x2a, // * 1575
      0x12, // 1576
      0x0c, // 1577
      0x12, // 1578
      0x18, // 1579
      (byte)0xb2, // 1580
      0x00, // 1581
      0x1a, // 1582
      (byte)0xb6, // 1583
      0x00, // 1584
      0x20, // 1585
      (byte)0xb3, // 1586
      0x00, // 1587
      0x26, // & 1588
      (byte)0xa7, // 1589
      0x00, // 1590
      0x0d, // 1591
      0x4b, // K 1592
      (byte)0xbb, // 1593
      0x00, // 1594
      0x28, // ( 1595
      0x59, // Y 1596
      0x2a, // * 1597
      (byte)0xb7, // 1598
      0x00, // 1599
      0x2a, // * 1600
      (byte)0xbf, // 1601
      (byte)0xb1, // 1602
      0x00, // 1603
      0x01, // 1604
      0x00, // 1605
      0x00, // 1606
      0x00, // 1607
      0x17, // 1608
      0x00, // 1609
      0x1a, // 1610
      0x00, // 1611
      0x2e, // . 1612
      0x00, // 1613
      0x03, // 1614
      0x00, // 1615
      0x30, // 0 1616
      0x00, // 1617
      0x00, // 1618
      0x00, // 1619
      0x16, // 1620
      0x00, // 1621
      0x05, // 1622
      0x00, // 1623
      0x00, // 1624
      0x04, // 1625
      (byte)0x85, // 1626
      0x00, // 1627
      0x09, // 1628
      0x04, // 1629
      (byte)0x86, // 1630
      0x00, // 1631
      0x17, // 1632
      0x04, // 1633
      (byte)0x87, // 1634
      0x00, // 1635
      0x1b, // 1636
      0x04, // 1637
      (byte)0x88, // 1638
      0x00, // 1639
      0x24, // $ 1640
      0x04, // 1641
      (byte)0x8a, // 1642
      0x00, // 1643
      0x31, // 1 1644
      0x00, // 1645
      0x00, // 1646
      0x00, // 1647
      0x16, // 1648
      0x00, // 1649
      0x02, // 1650
      0x00, // 1651
      0x09, // 1652
      0x00, // 1653
      0x0e, // 1654
      0x00, // 1655
      0x12, // 1656
      0x00, // 1657
      0x32, // 2 1658
      0x00, // 1659
      0x00, // 1660
      0x00, // 1661
      0x1b, // 1662
      0x00, // 1663
      0x09, // 1664
      0x00, // 1665
      0x33, // 3 1666
      0x00, // 1667
      0x34, // 4 1668
      0x00, // 1669
      0x00, // 1670
      0x00, // 1671
      0x35, // 5 1672
      0x00, // 1673
      0x00, // 1674
      0x00, // 1675
      0x07, // 1676
      0x00, // 1677
      0x02, // 1678
      0x5a, // Z 1679
      0x07, // 1680
      0x00, // 1681
      0x2e, // . 1682
      0x09, // 1683
      0x00, // 1684
      0x00, // 1685
      0x00, // 1686
      0x2c, // , 1687
      0x00, // 1688
      0x0a, // 1689
      0x00, // 1690
      0x01, // 1691
      0x00, // 1692
      0x0b, // 1693
      0x00, // 1694
      0x00, // 1695
      0x00, // 1696
      0x2f, // / 1697
      0x00, // 1698
      0x01, // 1699
      0x00, // 1700
      0x01, // 1701
      0x00, // 1702
      0x00, // 1703
      0x00, // 1704
      0x05, // 1705
      0x2a, // * 1706
      (byte)0xb7, // 1707
      0x00, // 1708
      0x36, // 6 1709
      (byte)0xb1, // 1710
      0x00, // 1711
      0x00, // 1712
      0x00, // 1713
      0x02, // 1714
      0x00, // 1715
      0x30, // 0 1716
      0x00, // 1717
      0x00, // 1718
      0x00, // 1719
      0x06, // 1720
      0x00, // 1721
      0x01, // 1722
      0x00, // 1723
      0x00, // 1724
      0x04, // 1725
      (byte)0x80, // 1726
      0x00, // 1727
      0x31, // 1 1728
      0x00, // 1729
      0x00, // 1730
      0x00, // 1731
      0x0c, // 1732
      0x00, // 1733
      0x01, // 1734
      0x00, // 1735
      0x00, // 1736
      0x00, // 1737
      0x05, // 1738
      0x00, // 1739
      0x38, // 8 1740
      0x00, // 1741
      0x39, // 9 1742
      0x00, // 1743
      0x00, // 1744
      0x00, // 1745
      0x09, // 1746
      0x00, // 1747
      0x3a, // : 1748
      0x00, // 1749
      0x3b, // ; 1750
      0x00, // 1751
      0x01, // 1752
      0x00, // 1753
      0x0b, // 1754
      0x00, // 1755
      0x00, // 1756
      0x00, // 1757
      0x64, // d 1758
      0x00, // 1759
      0x04, // 1760
      0x00, // 1761
      0x02, // 1762
      0x00, // 1763
      0x00, // 1764
      0x00, // 1765
      0x18, // 1766
      0x2a, // * 1767
      (byte)0xb6, // 1768
      0x00, // 1769
      0x3c, // < 1770
      0x3c, // < 1771
      0x1b, // 1772
      (byte)0xb8, // 1773
      0x00, // 1774
      0x40, // @ 1775
      (byte)0x99, // 1776
      0x00, // 1777
      0x0e, // 1778
      (byte)0xb2, // 1779
      0x00, // 1780
      0x26, // & 1781
      0x2a, // * 1782
      0x1b, // 1783
      0x10, // 1784
      (byte)0xef, // 1785
      0x7e, // ~ 1786
      (byte)0xb6, // 1787
      0x00, // 1788
      0x46, // F 1789
      (byte)0xb1, // 1790
      0x00, // 1791
      0x00, // 1792
      0x00, // 1793
      0x03, // 1794
      0x00, // 1795
      0x30, // 0 1796
      0x00, // 1797
      0x00, // 1798
      0x00, // 1799
      0x12, // 1800
      0x00, // 1801
      0x04, // 1802
      0x00, // 1803
      0x00, // 1804
      0x04, // 1805
      (byte)0x8d, // 1806
      0x00, // 1807
      0x05, // 1808
      0x04, // 1809
      (byte)0x8e, // 1810
      0x00, // 1811
      0x0c, // 1812
      0x04, // 1813
      (byte)0x8f, // 1814
      0x00, // 1815
      0x17, // 1816
      0x04, // 1817
      (byte)0x91, // 1818
      0x00, // 1819
      0x31, // 1 1820
      0x00, // 1821
      0x00, // 1822
      0x00, // 1823
      0x16, // 1824
      0x00, // 1825
      0x02, // 1826
      0x00, // 1827
      0x00, // 1828
      0x00, // 1829
      0x18, // 1830
      0x00, // 1831
      0x4c, // L 1832
      0x00, // 1833
      0x4d, // M 1834
      0x00, // 1835
      0x00, // 1836
      0x00, // 1837
      0x05, // 1838
      0x00, // 1839
      0x13, // 1840
      0x00, // 1841
      0x4e, // N 1842
      0x00, // 1843
      0x4f, // O 1844
      0x00, // 1845
      0x01, // 1846
      0x00, // 1847
      0x35, // 5 1848
      0x00, // 1849
      0x00, // 1850
      0x00, // 1851
      0x06, // 1852
      0x00, // 1853
      0x01, // 1854
      (byte)0xfc, // 1855
      0x00, // 1856
      0x17, // 1857
      0x01, // 1858
      0x00, // 1859
      0x01, // 1860
      0x00, // 1861
      0x50, // P 1862
      0x00, // 1863
      0x51, // Q 1864
      0x00, // 1865
      0x01, // 1866
      0x00, // 1867
      0x0b, // 1868
      0x00, // 1869
      0x00, // 1870
      0x00, // 1871
      0x5d, // ] 1872
      0x00, // 1873
      0x02, // 1874
      0x00, // 1875
      0x02, // 1876
      0x00, // 1877
      0x00, // 1878
      0x00, // 1879
      0x14, // 1880
      0x2b, // + 1881
      0x04, // 1882
      (byte)0xb6, // 1883
      0x00, // 1884
      0x52, // R 1885
      0x2b, // + 1886
      (byte)0xc1, // 1887
      0x00, // 1888
      0x0c, // 1889
      (byte)0x99, // 1890
      0x00, // 1891
      0x0a, // 1892
      0x2b, // + 1893
      (byte)0xc0, // 1894
      0x00, // 1895
      0x0c, // 1896
      (byte)0xb8, // 1897
      0x00, // 1898
      0x58, // X 1899
      (byte)0xb1, // 1900
      0x00, // 1901
      0x00, // 1902
      0x00, // 1903
      0x03, // 1904
      0x00, // 1905
      0x30, // 0 1906
      0x00, // 1907
      0x00, // 1908
      0x00, // 1909
      0x12, // 1910
      0x00, // 1911
      0x04, // 1912
      0x00, // 1913
      0x00, // 1914
      0x04, // 1915
      (byte)0x95, // 1916
      0x00, // 1917
      0x05, // 1918
      0x04, // 1919
      (byte)0x96, // 1920
      0x00, // 1921
      0x0c, // 1922
      0x04, // 1923
      (byte)0x97, // 1924
      0x00, // 1925
      0x13, // 1926
      0x04, // 1927
      (byte)0x99, // 1928
      0x00, // 1929
      0x31, // 1 1930
      0x00, // 1931
      0x00, // 1932
      0x00, // 1933
      0x16, // 1934
      0x00, // 1935
      0x02, // 1936
      0x00, // 1937
      0x00, // 1938
      0x00, // 1939
      0x14, // 1940
      0x00, // 1941
      0x38, // 8 1942
      0x00, // 1943
      0x39, // 9 1944
      0x00, // 1945
      0x00, // 1946
      0x00, // 1947
      0x00, // 1948
      0x00, // 1949
      0x14, // 1950
      0x00, // 1951
      0x5a, // Z 1952
      0x00, // 1953
      0x5b, // [ 1954
      0x00, // 1955
      0x01, // 1956
      0x00, // 1957
      0x35, // 5 1958
      0x00, // 1959
      0x00, // 1960
      0x00, // 1961
      0x03, // 1962
      0x00, // 1963
      0x01, // 1964
      0x13, // 1965
      0x10, // 1966
      0x41, // A 1967
      0x00, // 1968
      0x50, // P 1969
      0x00, // 1970
      0x5c, // \ 1971
      0x00, // 1972
      0x01, // 1973
      0x00, // 1974
      0x0b, // 1975
      0x00, // 1976
      0x00, // 1977
      0x00, // 1978
      0x29, // ) 1979
      0x00, // 1980
      0x02, // 1981
      0x00, // 1982
      0x02, // 1983
      0x00, // 1984
      0x00, // 1985
      0x00, // 1986
      0x09, // 1987
      0x2a, // * 1988
      0x2b, // + 1989
      (byte)0xc0, // 1990
      0x00, // 1991
      0x53, // S 1992
      (byte)0xb6, // 1993
      0x00, // 1994
      0x5d, // ] 1995
      (byte)0xb1, // 1996
      0x00, // 1997
      0x00, // 1998
      0x00, // 1999
      0x02, // 2000
      0x00, // 2001
      0x30, // 0 2002
      0x00, // 2003
      0x00, // 2004
      0x00, // 2005
      0x06, // 2006
      0x00, // 2007
      0x01, // 2008
      0x00, // 2009
      0x00, // 2010
      0x00, // 2011
      0x01, // 2012
      0x00, // 2013
      0x31, // 1 2014
      0x00, // 2015
      0x00, // 2016
      0x00, // 2017
      0x02, // 2018
      0x00, // 2019
      0x00, // 2020
      0x00, // 2021
      0x03, // 2022
      0x00, // 2023
      0x5f, // _ 2024
      0x00, // 2025
      0x00, // 2026
      0x00, // 2027
      0x02, // 2028
      0x00, // 2029
      0x60, // ` 2030
      0x00, // 2031
      0x61, // a 2032
      0x00, // 2033
      0x00, // 2034
      0x00, // 2035
      0x02, // 2036
      0x00, // 2037
      0x62, // b 2038
      0x00, // 2039
      0x63, // c 2040
      0x00, // 2041
      0x00, // 2042
      0x00, // 2043
      0x0a, // 2044
      0x00, // 2045
      0x01, // 2046
      0x00, // 2047
      0x21, // ! 2048
      0x00, // 2049
      0x0f, // 2050
      0x00, // 2051
      0x64, // d 2052
      0x00, // 2053
      0x19, // 2054
  };

  private static final Object UNSAFE_INSTANCE;

  private static final Method DEFINE_ANONYMOUS_CLASS_METHOD;

  private static final Method ALLOCATE_INSTANCE_METHOD;

  private static final Method CONSUMER_ACCEPT_METHOD;

  static
  {
    Object unsafeInstance = null;
    Method defineAnonymousClassMethod = null;
    Method allocateInstanceMethod = null;
    Method consumerAcceptMethod = null;

    try
    {
      // InaccessibleObjectException is new to Java 9.
      // If it can't be loaded we don't need any special support so we will drop out of this block and initialize the
      // fields to null.
      Class.forName("java.lang.reflect.InaccessibleObjectException");

      // Use reflection on Unsafe to avoid having to compile against it.
      Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
      Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");

      // Deep reflection is allowed on sun.misc package even for java 9.
      theUnsafeField.setAccessible(true);

      // Get the singleton from the static field.
      unsafeInstance = theUnsafeField.get(null);

      // We will use the Unsafe.defineAnonymousClass method to a create class that will be able to make an
      // AccessibleObject accessible.
      defineAnonymousClassMethod = unsafeClass.getMethod("defineAnonymousClass", Class.class, byte[].class, Object[].class);

      allocateInstanceMethod = unsafeClass.getDeclaredMethod("allocateInstance", Class.class);

      // We'd like to use Consumer directly but that's not available in the current BREE.
      consumerAcceptMethod = Class.forName("java.util.function.Consumer").getMethod("accept", Object.class);
    }
    catch (Throwable throwable)
    {
      //$FALL-THROUGH$
      //
      // If the Unsafe class can't be loaded, then it must be unsupported and we won't be able to do anything special to
      // support making members accessible.
      // The static final fields will be initialized to null.
    }

    UNSAFE_INSTANCE = unsafeInstance;
    DEFINE_ANONYMOUS_CLASS_METHOD = defineAnonymousClassMethod;
    ALLOCATE_INSTANCE_METHOD = allocateInstanceMethod;
    CONSUMER_ACCEPT_METHOD = consumerAcceptMethod;
  }

  private static final Map<String, Object> PACKAGE_ACCESSIBILITY_CONTROL_MAP = Collections.synchronizedMap(new HashMap<String, Object>());

  private AccessUtil()
  {
  }

  public static void setNonFinal(Field field)
  {
    if (UNSAFE_INSTANCE == null || !interalSetAccessible(field, Field.class))
    {
      try
      {
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & ~Modifier.FINAL);
        field.setAccessible(true);
      }
      catch (RuntimeException ex)
      {
        throw ex;
      }
      catch (Exception ex)
      {
        throw WrappedException.wrap(ex);
      }
    }
  }

  public static void setAccessible(Field field)
  {
    if (UNSAFE_INSTANCE == null || !interalSetAccessible(field))
    {
      field.setAccessible(true);
    }
  }

  public static void setAccessible(Method method)
  {
    if (UNSAFE_INSTANCE == null || !interalSetAccessible(method))
    {
      method.setAccessible(true);
    }
  }

  public static void setAccessible(Constructor<?> constructor)
  {
    if (UNSAFE_INSTANCE == null || !interalSetAccessible(constructor))
    {
      constructor.setAccessible(true);
    }
  }

  private static boolean interalSetAccessible(Member member)
  {
    // Get the declaring class' name to determine the package name.
    Class<?> declaringClass = member.getDeclaringClass();
    return interalSetAccessible(member, declaringClass);
  }

  private static boolean interalSetAccessible(Member member, Class<?> declaringClass)
  {
    try
    {
      String name = declaringClass.getName();
      int lastDotIndex = name.lastIndexOf('.');
      if (lastDotIndex == -1)
      {
        // There is no package name, so no need for special support.
        // Instruct the caller to set accessibility in the normal way.
        return false;
      }

      // Extract the package name.
      String packageName = name.substring(0, lastDotIndex);

      // If there is already an access controller instance created for
      // this package...
      Object accessController = PACKAGE_ACCESSIBILITY_CONTROL_MAP.get(packageName);
      if (accessController == null)
      {
        // Convert the package name to to a path.
        String packageNamePath = packageName.replace('.', '/');

        // Build the class' name path.
        String classNamePath = packageNamePath + "/AccessController";

        // Build the class' signature.
        String classSignature = "L" + packageNamePath + "/AccessController;";

        // Convert the class name path to its UTF 8 bytes.
        byte[] classNamePathBytes = classNamePath.getBytes("UTF-8");
        int classNamePathBytesLength = classNamePathBytes.length;

        // Convert the class signature to it's UTF 8 bytes.
        byte[] classSignatureBytes = classSignature.getBytes("UTF-8");
        int classSignatureBytesLength = classSignatureBytes.length;

        // Create a bytes array big enough to hold all the template
        // bytes as well as the bytes for the class name path and the
        // class signature,
        // including the 2 bytes used for the length of each of those.
        byte[] bytes = new byte[ACCESS_CONTROLLER_BYTES.length + classNamePathBytesLength + classSignatureBytesLength + 4];

        // Copy the initial template bytes.
        System.arraycopy(ACCESS_CONTROLLER_BYTES, 0, bytes, 0, NAME_PATH_INDEX);

        // Copy the bytes for the class name path's length followed by
        // the UTF 8 bytes for the class name path to be after initial
        // template bytes.
        bytes[NAME_PATH_INDEX] = (byte)(classNamePathBytesLength >> 8);
        bytes[NAME_PATH_INDEX + 1] = (byte)(classNamePathBytesLength & 0xFF);
        System.arraycopy(classNamePathBytes, 0, bytes, NAME_PATH_INDEX + 2, classNamePathBytesLength);

        // Copy the intervening template bytes to be after the end of
        // the class name path bytes.
        int index = NAME_PATH_INDEX + classNamePathBytesLength + 2;
        System.arraycopy(ACCESS_CONTROLLER_BYTES, NAME_PATH_INDEX, bytes, index, NAME_SIGNATURE_INDEX - NAME_PATH_INDEX);

        // Compute the index for the point after the intervening
        // template bytes.
        index += NAME_SIGNATURE_INDEX - NAME_PATH_INDEX;

        // Copy the bytes for the class signature's length followed by
        // the UTF 8 bytes for the class signature.
        bytes[index] = (byte)(classSignatureBytesLength >> 8);
        bytes[++index] = (byte)(classSignatureBytesLength & 0xFF);
        System.arraycopy(classSignatureBytes, 0, bytes, ++index, classSignatureBytesLength);

        // Copy the trailing template bytes.
        index += classSignatureBytesLength;
        System.arraycopy(ACCESS_CONTROLLER_BYTES, NAME_SIGNATURE_INDEX, bytes, index, ACCESS_CONTROLLER_BYTES.length - NAME_SIGNATURE_INDEX);

        // Define an anonymous class in the declaring class' package
        // using the computed class bytes.
        Class<?> theAnonymousClass = (Class<?>)DEFINE_ANONYMOUS_CLASS_METHOD.invoke(UNSAFE_INSTANCE, declaringClass, bytes, null);

        // Because the template bytes were computed class local to this
        // file, the class isn't public and we're not allowed by Java 9
        // to create an instance in the normal way.
        // So we create an instance without calling the constructor.
        Object newAccessController = ALLOCATE_INSTANCE_METHOD.invoke(UNSAFE_INSTANCE, theAnonymousClass);

        // Cache this access controller instance for subsequent reuse.
        PACKAGE_ACCESSIBILITY_CONTROL_MAP.put(packageName, newAccessController);

        // Set the access controller to use.
        accessController = newAccessController;
      }

      // Use that instance to set the accessibility.
      CONSUMER_ACCEPT_METHOD.invoke(accessController, member);

      // We don't want the caller to set the accessibility in the normal way.
      return true;
    }
    catch (IOException ex)
    {
      throw new RuntimeException(ex);
    }
    catch (IllegalAccessException ex)
    {
      throw new RuntimeException(ex);
    }
    catch (IllegalArgumentException ex)
    {
      throw new RuntimeException(ex);
    }
    catch (InvocationTargetException ex)
    {
      throw new RuntimeException(ex);
    }
    catch (SecurityException ex)
    {
      throw new RuntimeException(ex);
    }
  }

  /**
   * This method invokes the generator.
   * You must uncomment the two classes in this file below for this method to find the generator class and to generate the declarations used at the start of this class.
   * The results printed on the console can be copied to replace the three constants at  the start of this class.
   * This must be done by compiling against Java 9 or higher so you'll have to temporarily increase the Java version for this project.
   *
   * @see #NAME_PATH_INDEX
   * @see #NAME_SIGNATURE_INDEX
   * @see #ACCESS_CONTROLLER_BYTES
   */
  public static void main(String[] args) throws Exception
  {
    Class<?> classBytesGeneratorClass = Class.forName(AccessUtil.class.getName().replace(AccessUtil.class.getSimpleName(), "ClassBytesGenerator"));
    classBytesGeneratorClass.getMethod("generate").invoke(null);
  }
}

// Disable the formatter for the remainder of this file.
// @formatter:off
/*
 * class ClassBytesGenerator { public static void generate() { generate(AccessController.class); } private static void
 * generate(Class<?> targetClass) { String name = targetClass.getName(); StringBuilder builder = new StringBuilder();
 * java.net.URL resource = targetClass.getResource(name.substring(name.lastIndexOf('.') + 1) + ".class"); try {
 * java.io.InputStream input = resource.openStream(); for (int value = input.read(); value != -1; value = input.read())
 * { builder.append((char)value); } input.close(); String namePath = name.replace('.', '/'); String nameSignature = 'L'
 * + namePath + ';'; int namePathIndex = builder.indexOf(namePath); int nameSignatureIndex =
 * builder.indexOf(nameSignature); int namePathStart = namePathIndex - 2; int namePathEnd = namePathIndex +
 * namePath.length(); int nameSignatureStart = nameSignatureIndex - 2; int nameSignatureEnd = nameSignatureIndex +
 * +nameSignature.length(); System.out.println("private static final int NAME_PATH_INDEX = " + namePathStart + ";");
 * System.out.println("private static final int NAME_SIGNATURE_INDEX = " + (nameSignatureStart - (namePathEnd -
 * namePathStart)) + ";"); System.out.println("private static final byte[] ACCESS_CONTROLLER_BYTES = new byte[]");
 * System.out.println("  { //"); for (int i = 0, length = builder.length(), count = 0; i < length; ++i) { int value =
 * builder.charAt(i); System.out.print("    "); boolean exclude = i >= namePathStart && i < namePathEnd || i >=
 * nameSignatureStart && i < nameSignatureEnd; if (exclude) { System.out.print("// 0x"); } else { ++count; if (value >
 * 127) { System.out.print("(byte)"); } System.out.print("0x"); } String hexString =
 * Integer.toHexString(Byte.toUnsignedInt((byte)value)); if (hexString.length() == 1) { System.out.print('0'); }
 * System.out.print(hexString); System.out.print(", //"); if (value > 32 && value < 128) { System.out.print(' ');
 * System.out.print((char)value); } if (!exclude) { System.out.print(" " + (count - 1)); } System.out.println(); }
 * System.out.println("  };"); } catch (IOException ex) { ex.printStackTrace(); } } } class AccessController implements
 * Consumer<AccessibleObject> { private static final VarHandle MODIFIERS; static { try { Lookup lookup =
 * MethodHandles.privateLookupIn(Field.class, MethodHandles.lookup()); MODIFIERS = lookup.findVarHandle(Field.class,
 * "modifiers", int.class); } catch (Throwable ex) { throw new RuntimeException(ex); } } public static void
 * makeNonFinal(Field field) { int mods = field.getModifiers(); if (Modifier.isFinal(mods)) { MODIFIERS.set(field, mods
 * & ~Modifier.FINAL); } }
 * @Override public void accept(AccessibleObject accessibleObject) { accessibleObject.setAccessible(true); if
 * (accessibleObject instanceof Field) { makeNonFinal((Field)accessibleObject); } } } //
 */
