/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.architecture.ArchitecturePackage;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.architecture.impl.ADElementImpl;
import org.eclipse.papyrus.infra.core.architecture.util.ArchitectureCommandUtils;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;

public abstract class ArchitectureContextImpl
extends ADElementImpl
implements ArchitectureContext {
    protected EList<ArchitectureViewpoint> viewpoints;
    protected EList<ArchitectureViewpoint> defaultViewpoints;
    protected EList<ElementTypeSetConfiguration> elementTypes;
    protected static final String EXTENSION_PREFIX_EDEFAULT = null;
    protected String extensionPrefix = EXTENSION_PREFIX_EDEFAULT;
    protected static final String CREATION_COMMAND_CLASS_EDEFAULT = null;
    protected String creationCommandClass = CREATION_COMMAND_CLASS_EDEFAULT;
    protected static final String CONVERSION_COMMAND_CLASS_EDEFAULT = null;
    protected String conversionCommandClass = CONVERSION_COMMAND_CLASS_EDEFAULT;

    protected ArchitectureContextImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT;
    }

    @Override
    public EList<ArchitectureViewpoint> getViewpoints() {
        if (this.viewpoints == null) {
            this.viewpoints = new EObjectContainmentWithInverseEList(ArchitectureViewpoint.class, (InternalEObject)this, 5, 7);
        }
        return this.viewpoints;
    }

    @Override
    public EList<ArchitectureViewpoint> getDefaultViewpoints() {
        if (this.defaultViewpoints == null) {
            this.defaultViewpoints = new EObjectResolvingEList(ArchitectureViewpoint.class, (InternalEObject)this, 6);
        }
        return this.defaultViewpoints;
    }

    @Override
    public EList<ElementTypeSetConfiguration> getElementTypes() {
        if (this.elementTypes == null) {
            this.elementTypes = new EObjectResolvingEList(ElementTypeSetConfiguration.class, (InternalEObject)this, 7);
        }
        return this.elementTypes;
    }

    @Override
    public String getExtensionPrefix() {
        return this.extensionPrefix;
    }

    @Override
    public void setExtensionPrefix(String newExtensionPrefix) {
        String oldExtensionPrefix = this.extensionPrefix;
        this.extensionPrefix = newExtensionPrefix;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldExtensionPrefix, (Object)this.extensionPrefix));
        }
    }

    @Override
    public String getCreationCommandClass() {
        return this.creationCommandClass;
    }

    @Override
    public void setCreationCommandClass(String newCreationCommandClass) {
        String oldCreationCommandClass = this.creationCommandClass;
        this.creationCommandClass = newCreationCommandClass;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldCreationCommandClass, (Object)this.creationCommandClass));
        }
    }

    @Override
    public String getConversionCommandClass() {
        return this.conversionCommandClass;
    }

    @Override
    public void setConversionCommandClass(String newConversionCommandClass) {
        String oldConversionCommandClass = this.conversionCommandClass;
        this.conversionCommandClass = newConversionCommandClass;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldConversionCommandClass, (Object)this.conversionCommandClass));
        }
    }

    @Override
    public boolean ceationCommandClassExists(DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.creationCommandClass != null) {
            boolean exists = false;
            Object javaClass = ArchitectureCommandUtils.getCommandClass(this, (EStructuralFeature)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CREATION_COMMAND_CLASS);
            boolean bl = exists = javaClass != null;
            if (!exists) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.core.architecture", 1, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"ceationCommandClassExists", EObjectValidator.getObjectLabel((EObject)this, context)}), new Object[]{this}));
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean conversionCommandClassExists(DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.conversionCommandClass != null) {
            boolean exists = false;
            Object javaClass = ArchitectureCommandUtils.getCommandClass(this, (EStructuralFeature)ArchitecturePackage.Literals.ARCHITECTURE_CONTEXT__CONVERSION_COMMAND_CLASS);
            boolean bl = exists = javaClass != null;
            if (!exists) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.papyrus.infra.core.architecture", 2, EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[]{"conversionCommandClassExists", EObjectValidator.getObjectLabel((EObject)this, context)}), new Object[]{this}));
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public ArchitectureDomain getDomain() {
        if (this.eContainerFeatureID() != 8) {
            return null;
        }
        return (ArchitectureDomain)this.eInternalContainer();
    }

    public NotificationChain basicSetDomain(ArchitectureDomain newDomain, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newDomain, 8, msgs);
        return msgs;
    }

    @Override
    public void setDomain(ArchitectureDomain newDomain) {
        if (newDomain != this.eInternalContainer() || this.eContainerFeatureID() != 8 && newDomain != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newDomain)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newDomain != null) {
                msgs = ((InternalEObject)newDomain).eInverseAdd((InternalEObject)this, 7, ArchitectureDomain.class, msgs);
            }
            if ((msgs = this.basicSetDomain(newDomain, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)newDomain, (Object)newDomain));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getViewpoints()).basicAdd((Object)otherEnd, msgs);
            }
            case 8: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetDomain((ArchitectureDomain)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return ((InternalEList)this.getViewpoints()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return this.basicSetDomain(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 8: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 7, ArchitectureDomain.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getViewpoints();
            }
            case 6: {
                return this.getDefaultViewpoints();
            }
            case 7: {
                return this.getElementTypes();
            }
            case 8: {
                return this.getDomain();
            }
            case 9: {
                return this.getExtensionPrefix();
            }
            case 10: {
                return this.getCreationCommandClass();
            }
            case 11: {
                return this.getConversionCommandClass();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.getViewpoints().clear();
                this.getViewpoints().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getDefaultViewpoints().clear();
                this.getDefaultViewpoints().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getElementTypes().clear();
                this.getElementTypes().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.setDomain((ArchitectureDomain)newValue);
                return;
            }
            case 9: {
                this.setExtensionPrefix((String)newValue);
                return;
            }
            case 10: {
                this.setCreationCommandClass((String)newValue);
                return;
            }
            case 11: {
                this.setConversionCommandClass((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.getViewpoints().clear();
                return;
            }
            case 6: {
                this.getDefaultViewpoints().clear();
                return;
            }
            case 7: {
                this.getElementTypes().clear();
                return;
            }
            case 8: {
                this.setDomain(null);
                return;
            }
            case 9: {
                this.setExtensionPrefix(EXTENSION_PREFIX_EDEFAULT);
                return;
            }
            case 10: {
                this.setCreationCommandClass(CREATION_COMMAND_CLASS_EDEFAULT);
                return;
            }
            case 11: {
                this.setConversionCommandClass(CONVERSION_COMMAND_CLASS_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.viewpoints != null && !this.viewpoints.isEmpty();
            }
            case 6: {
                return this.defaultViewpoints != null && !this.defaultViewpoints.isEmpty();
            }
            case 7: {
                return this.elementTypes != null && !this.elementTypes.isEmpty();
            }
            case 8: {
                return this.getDomain() != null;
            }
            case 9: {
                return EXTENSION_PREFIX_EDEFAULT == null ? this.extensionPrefix != null : !EXTENSION_PREFIX_EDEFAULT.equals(this.extensionPrefix);
            }
            case 10: {
                return CREATION_COMMAND_CLASS_EDEFAULT == null ? this.creationCommandClass != null : !CREATION_COMMAND_CLASS_EDEFAULT.equals(this.creationCommandClass);
            }
            case 11: {
                return CONVERSION_COMMAND_CLASS_EDEFAULT == null ? this.conversionCommandClass != null : !CONVERSION_COMMAND_CLASS_EDEFAULT.equals(this.conversionCommandClass);
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.ceationCommandClassExists((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 1: {
                return this.conversionCommandClassExists((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (extensionPrefix: ");
        result.append(this.extensionPrefix);
        result.append(", creationCommandClass: ");
        result.append(this.creationCommandClass);
        result.append(", conversionCommandClass: ");
        result.append(this.conversionCommandClass);
        result.append(')');
        return result.toString();
    }
}

