/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.util;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.architecture.impl.ArchitecturePlugin;
import org.eclipse.papyrus.infra.tools.util.ClasspathHelper;
import org.osgi.framework.Bundle;

public class ArchitectureCommandUtils {
    private static final String CLASS_CONSTRAINT = "classConstraint";
    private static final String BUNDLECLASS = "bundleclass";
    private static final Map<EStructuralFeature, Class<?>> commandClassConstraints = new ConcurrentHashMap();

    public static Optional<Class<?>> getCommandType(EStructuralFeature commandClassFeature) {
        return Optional.ofNullable(commandClassConstraints.computeIfAbsent(commandClassFeature, ArchitectureCommandUtils::loadClassAnnotation));
    }

    private static Class<?> loadClassAnnotation(EStructuralFeature feature) {
        Class<?> result = null;
        String classURI = EcoreUtil.getAnnotation((EModelElement)feature, (String)"http://www.eclipse.org/papyrus/infra/core/architecture", (String)CLASS_CONSTRAINT);
        if (classURI != null) {
            URI uri = URI.createURI((String)classURI);
            if (!BUNDLECLASS.equals(uri.scheme())) {
                result = ArchitectureCommandUtils.fail("Constraint class URI does not have bundleclass scheme: " + uri);
            } else if (uri.authority() == null) {
                result = ArchitectureCommandUtils.fail("Constraint class URI does not have an authority: " + uri);
            } else if (uri.segmentCount() != 1) {
                result = ArchitectureCommandUtils.fail("Constraint class URI must have exactly one segment: " + uri);
            } else {
                Bundle bundle = Platform.getBundle((String)uri.authority());
                if (bundle == null) {
                    result = ArchitectureCommandUtils.fail("No such bundle in constraint class URI: " + uri);
                } else {
                    try {
                        result = bundle.loadClass(uri.segment(0));
                    }
                    catch (Exception e) {
                        result = ArchitectureCommandUtils.fail(e);
                    }
                }
            }
        }
        return result;
    }

    private static Class<?> fail(String message) {
        return ArchitectureCommandUtils.fail(new IllegalArgumentException(message));
    }

    private static Class<?> fail(Throwable exception) {
        ArchitecturePlugin.INSTANCE.log(exception);
        return Void.class;
    }

    public static Object getCommandClass(EObject modelObject, EStructuralFeature commandClassFeature) {
        if (commandClassFeature.getEType().getInstanceClass() == Class.class) {
            return modelObject.eGet(commandClassFeature);
        }
        String className = Optional.ofNullable(modelObject.eGet(commandClassFeature)).map(String::valueOf).orElse(null);
        if (className == null) {
            return null;
        }
        Optional<Class<?>> registeredType = ArchitectureCommandUtils.getCommandType(commandClassFeature);
        URI context = EcoreUtil.getURI((EObject)modelObject).trimFragment();
        return ClasspathHelper.INSTANCE.findClass(className, context, (Class)registeredType.orElse(null));
    }
}

