/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.hierarchy.FakeType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.contexts.ClassStaticMemberContext;
import org.eclipse.php.internal.core.codeassist.contexts.IClassMemberContext;
import org.eclipse.php.internal.core.codeassist.strategies.ClassMembersStrategy;
import org.eclipse.php.internal.core.typeinference.FakeField;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class ClassFieldsStrategy
extends ClassMembersStrategy {
    private static final String CLASS_KEYWORD = "class";
    private static final String STD_CLASS = "stdClass";

    public ClassFieldsStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public ClassFieldsStrategy(ICompletionContext context) {
        super(context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof IClassMemberContext) || !(context instanceof AbstractCompletionContext)) {
            return;
        }
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        IClassMemberContext concreteContext = (IClassMemberContext)context;
        CompletionRequestor requestor = abstractContext.getCompletionRequestor();
        String prefix = abstractContext.getPrefix();
        ISourceRange replaceRange = this.getReplacementRange(concreteContext);
        LinkedList<Object> result = new LinkedList<Object>();
        IType[] iTypeArray = concreteContext.getLhsTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType iType = iTypeArray[n2];
            try {
                ITypeHierarchy hierarchy = this.getCompanion().getSuperTypeHierarchy(iType, null);
                IField[] fields = null;
                if (concreteContext instanceof ClassStaticMemberContext && concreteContext.getTriggerType() == IClassMemberContext.Trigger.CLASS && ((ClassStaticMemberContext)concreteContext).isParent()) {
                    ArrayList<IField> superTypes = new ArrayList<IField>();
                    IType[] iTypeArray2 = hierarchy.getAllSupertypes(iType);
                    int n3 = iTypeArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IType currType = iTypeArray2[n4];
                        superTypes.addAll(Arrays.asList(PHPModelUtils.getTypeField(currType, prefix, requestor.isContextInformationMode())));
                        ++n4;
                    }
                    fields = superTypes.toArray(new IField[superTypes.size()]);
                } else {
                    fields = PHPModelUtils.getTypeHierarchyField(iType, hierarchy, prefix, requestor.isContextInformationMode(), null);
                }
                for (IField field : this.removeOverriddenElements(Arrays.asList(fields))) {
                    if (this.isFiltered((IMember)field, iType, concreteContext)) continue;
                    result.add(field);
                }
            }
            catch (CoreException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        if (concreteContext instanceof ClassStaticMemberContext && concreteContext.getTriggerType() == IClassMemberContext.Trigger.CLASS && PHPVersion.PHP5_4.isLessThan(this.getCompanion().getPHPVersion()) && (CLASS_KEYWORD.startsWith(prefix.toLowerCase()) || CLASS_KEYWORD.equals(prefix.toLowerCase()))) {
            try {
                void var9_16;
                ITextRegion iTextRegion = this.getCompanion().getPHPScriptRegion().getPHPToken(this.getCompanion().getPHPToken().getStart() - 1);
                if ("PHP_PAAMAYIM_NEKUDOTAYIM".equals(iTextRegion.getType())) {
                    ITextRegion iTextRegion2 = this.getCompanion().getPHPToken(iTextRegion.getStart() - 1);
                }
                if (this.isStaticCall(var9_16.getType())) {
                    result.add((Object)new FakeField((ModelElement)new FakeType((ModelElement)this.getCompanion().getSourceModule(), STD_CLASS), CLASS_KEYWORD, 66));
                }
            }
            catch (BadLocationException badLocationException) {
                Logger.logException(badLocationException);
            }
        }
        for (IField iField : result) {
            reporter.reportField(iField, this.getSuffix(), replaceRange, concreteContext.getTriggerType() == IClassMemberContext.Trigger.OBJECT);
        }
    }

    private boolean isStaticCall(String type) {
        return "PHP_LABEL".equals(type) || "PHP_PARENT".equals(type) || "PHP_SELF".equals(type) || "PHP_NS_SEPARATOR".equals(type) || "PHP_STATIC".equals(type);
    }

    @Override
    protected boolean showNonStaticMembers(IClassMemberContext context) {
        return super.showNonStaticMembers(context) && !this.isParentCall(context);
    }

    public String getSuffix() {
        return "";
    }
}

