/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.launch.variables;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.ems.core.IEnvManager;
import org.eclipse.ptp.internal.etfw.launch.Activator;
import org.eclipse.ptp.internal.etfw.launch.variables.ETFWVariableResolver;
import org.eclipse.ptp.internal.rm.jaxb.control.core.JAXBControlCorePlugin;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.remote.core.launch.IRemoteLaunchConfigService;

public class ETFWVariableMap
implements IVariableMap {
    private static final Object monitor = new Object();
    private final Map<String, AttributeType> variables = Collections.synchronizedMap(new TreeMap());
    private final Map<String, AttributeType> discovered = Collections.synchronizedMap(new TreeMap());
    private boolean initialized = false;
    private IEnvManager envManager;

    public static Map<String, Object> getValidAttributes(ILaunchConfiguration config) throws CoreException {
        IRemoteLaunchConfigService launchConfigService = Activator.getService(IRemoteLaunchConfigService.class);
        String rmId = launchConfigService.getActiveConnection(config).getConnectionType().getId();
        rmId = String.valueOf(rmId) + ".";
        int len = rmId.length();
        Map attrs = config.getAttributes();
        TreeMap<String, Object> current = new TreeMap<String, Object>();
        HashMap rmAttr = new HashMap();
        HashSet<String> include = new HashSet<String>();
        for (String name : attrs.keySet()) {
            Object value = attrs.get(name);
            if (value == null || "".equals(value)) continue;
            if (name.startsWith(rmId)) {
                if (ETFWVariableMap.isFixedValid(name = name.substring(len))) {
                    current.put(name, value);
                    continue;
                }
                rmAttr.put(name, value);
                continue;
            }
            if (!ETFWVariableMap.isExternal(name)) continue;
            current.put(name, value);
        }
        String id = (String)rmAttr.get("current_controller");
        String valid = (String)rmAttr.get("valid_" + id);
        if (valid != null) {
            String[] split;
            String[] stringArray = split = valid.split(" ");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                include.add(s);
                ++n2;
            }
        }
        for (String var : rmAttr.keySet()) {
            Object value = rmAttr.get(var);
            if (!include.contains(var)) continue;
            current.put(var, value);
        }
        return current;
    }

    public static boolean isDynamic(String name) {
        return name.equals("os.arch") || name.equals("os.name") || name.equals("os.version");
    }

    public static boolean isExternal(String name) {
        return name.startsWith("org.eclipse.debug") || name.startsWith("org.eclipse.ptp");
    }

    public static boolean isFixedValid(String name) {
        return name.startsWith("control.") || name.equals("directory") || name.equals("executablePath") || name.equals("executableDirectory") || name.equals("progArgs") || name.equals("debuggerExecutablePath") || name.equals("debuggerArgs") || name.equals("debuggerId") || name.equals("stdout_remote_path") || name.equals("stderr_remote_path") || name.equals("ptpDirectory") || name.equals("working.directory");
    }

    public void clear() {
        this.variables.clear();
        this.discovered.clear();
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dereference(String expression) throws CoreException {
        if (expression == null) {
            return null;
        }
        Object object = monitor;
        synchronized (object) {
            ETFWVariableResolver.setActive(this);
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(expression);
        }
    }

    public AttributeType get(String name) {
        if (name == null) {
            return null;
        }
        AttributeType a = this.variables.get(name);
        if (a == null) {
            a = this.discovered.get(name);
        }
        return a;
    }

    public Map<String, AttributeType> getAttributes() {
        return this.variables;
    }

    public String getDefault(String name) {
        return null;
    }

    public Map<String, AttributeType> getDiscovered() {
        return this.discovered;
    }

    public IEnvManager getEnvManager() {
        return this.envManager;
    }

    public String getString(String value) {
        return this.getString(null, value);
    }

    public String getString(String jobId, String value) {
        try {
            if (jobId != null) {
                value = value.replaceAll("@jobId", jobId);
            }
            return this.dereference(value);
        }
        catch (CoreException t) {
            JAXBControlCorePlugin.log((Throwable)t);
            return value;
        }
    }

    public Object getValue(String name) {
        AttributeType a = this.variables.get(name);
        if (a != null) {
            return a.getValue();
        }
        return null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void maybeAddAttribute(String name, Object value, boolean visible) {
        if (name == null) {
            return;
        }
        AttributeType a = this.get(name);
        if (a == null) {
            a = new AttributeType();
            a.setName(name);
            this.variables.put(name, a);
        }
        if (value != null) {
            a.setValue(value);
            a.setVisible(Boolean.valueOf(visible));
        }
    }

    public void overwrite(String key1, String key2, Map<String, Object> map) throws CoreException {
        Object value = map.get(key2);
        if (value != null) {
            this.maybeAddAttribute(key1, value, false);
        }
    }

    public void put(String name, AttributeType value) {
        if (name == null) {
            return;
        }
        this.variables.put(name, value);
    }

    public void putValue(String name, Object value) {
        if (name == null || "".equals(name)) {
            return;
        }
        if (value != null) {
            AttributeType a = this.variables.get(name);
            if (a == null) {
                a = new AttributeType();
                a.setName(name);
                a.setValue(value);
                this.variables.put(name, a);
            }
            a.setValue(value);
        }
    }

    public AttributeType remove(String name) {
        if (name == null) {
            return null;
        }
        AttributeType o = this.variables.remove(name);
        if (o == null) {
            o = this.discovered.remove(name);
        }
        return o;
    }

    public void setDefault(String name, String defaultValue) {
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

