/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.featureextensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.featureextensions.FeatureExtensionServices;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DFeatureExtension;
import org.eclipse.sirius.viewpoint.description.FeatureExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public abstract class AbstractFeatureExtensionServices
implements FeatureExtensionServices {
    protected abstract Class<? extends FeatureExtensionDescription> getFeatureExtensionDescriptionClass();

    protected abstract Class<? extends DFeatureExtension> getFeatureExtensionClass();

    @Override
    public <T extends FeatureExtensionDescription> List<T> getFeatureExtensionDescriptions(Viewpoint viewpoint, Class<T> clazz) {
        if (this.getFeatureExtensionDescriptionClass().isAssignableFrom(clazz)) {
            ArrayList<FeatureExtensionDescription> descs = new ArrayList<FeatureExtensionDescription>();
            for (FeatureExtensionDescription desc : viewpoint.getOwnedFeatureExtensions()) {
                if (!this.getFeatureExtensionDescriptionClass().isInstance(desc)) continue;
                descs.add(desc);
            }
            return descs;
        }
        return null;
    }

    @Override
    public Collection<DFeatureExtension> retrieveFeatureExtensionData(String id, Session session) {
        Collection<EObject> data = session.getServices().getCustomData("DFEATUREEXTENSION", null);
        ArrayList<DFeatureExtension> conformanceExtensions = new ArrayList<DFeatureExtension>();
        for (EObject pieceOfData : data) {
            if (!this.getFeatureExtensionClass().isInstance(pieceOfData)) continue;
            conformanceExtensions.add((DFeatureExtension)pieceOfData);
        }
        return conformanceExtensions;
    }

    @Override
    public void saveFeatureExtensionData(String id, Session session, EObject associatedInstance, DFeatureExtension data) {
        session.getServices().putCustomData("DFEATUREEXTENSION", associatedInstance, data);
    }
}

