/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.markers;

import com.google.common.collect.Lists;
import com.google.common.collect.RangeSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.markers.Marker;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSegment;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSet;
import org.eclipse.tracecompass.internal.tmf.core.markers.SubMarker;
import org.eclipse.tracecompass.internal.tmf.ui.markers.MarkerUtils;
import org.eclipse.tracecompass.tmf.core.signal.TmfMarkerEventSourceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.trace.AbstractTmfTraceAdapterFactory;
import org.eclipse.tracecompass.tmf.core.trace.ICyclesConverter;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.colors.ColorUtils;
import org.eclipse.tracecompass.tmf.ui.markers.IMarkerReferenceProvider;
import org.eclipse.tracecompass.tmf.ui.markers.PeriodicMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;

public class ConfigurableMarkerEventSource
implements IMarkerEventSource,
AbstractTmfTraceAdapterFactory.IDisposableAdapter {
    private static final long NANO_PER_MILLI = 1000000L;
    private static final long NANO_PER_MICRO = 1000L;
    private static final int MIN_PERIOD = 5;
    private static final int ALPHA = 10;
    private static final String COLOR_REGEX = "#[A-Fa-f0-9]{6}";
    private List<IConfigurableMarkerEventSource> fMarkerEventSources;
    private Map<Marker, RGBA> fColors = new HashMap<Marker, RGBA>();
    private final ITmfTrace fTrace;

    public ConfigurableMarkerEventSource(ITmfTrace trace) {
        this.fMarkerEventSources = new ArrayList<IConfigurableMarkerEventSource>();
        this.fTrace = trace;
        TmfSignalManager.register((Object)this);
    }

    public void dispose() {
        TmfSignalManager.deregister((Object)this);
    }

    public void configure(MarkerSet markerSet) {
        this.fMarkerEventSources.clear();
        if (markerSet != null) {
            for (Marker marker : markerSet.getMarkers()) {
                this.configure(marker);
            }
        }
    }

    private void configure(Marker marker) {
        if (marker instanceof Marker.PeriodicMarker) {
            IMarkerReferenceProvider adapter;
            Marker.PeriodicMarker periodicMarker = (Marker.PeriodicMarker)marker;
            String referenceId = periodicMarker.getReferenceId();
            PeriodicMarkerEventSource.Reference baseReference = null;
            if (this.fTrace instanceof IAdaptable && !referenceId.isEmpty() && (adapter = (IMarkerReferenceProvider)((IAdaptable)this.fTrace).getAdapter(IMarkerReferenceProvider.class)) != null) {
                baseReference = adapter.getReference(referenceId);
            }
            if (baseReference == null) {
                baseReference = PeriodicMarkerEventSource.Reference.ZERO;
            }
            long rollover = periodicMarker.getRange().hasUpperBound() ? (Long)periodicMarker.getRange().upperEndpoint() - (Long)periodicMarker.getRange().lowerEndpoint() + 1L : 0L;
            RGBA evenColor = this.getColor((Marker)periodicMarker);
            RGBA oddColor = ConfigurableMarkerEventSource.getOddColor(evenColor);
            double period = this.convertToNanos(periodicMarker.getPeriod(), periodicMarker.getUnit());
            PeriodicMarkerEventSource.Reference reference = new PeriodicMarkerEventSource.Reference(baseReference.getTime() + Math.round(this.convertToNanos(periodicMarker.getOffset(), periodicMarker.getUnit())), baseReference.getIndex());
            ConfigurablePeriodicMarkerEventSource markerEventSource = new ConfigurablePeriodicMarkerEventSource(marker, (String)NonNullUtils.checkNotNull((Object)periodicMarker.getName()), reference, period, rollover, evenColor, oddColor, false, (Long)periodicMarker.getRange().lowerEndpoint(), (String)NonNullUtils.checkNotNull((Object)periodicMarker.getLabel()), (RangeSet<Long>)periodicMarker.getIndexRange());
            this.fMarkerEventSources.add(markerEventSource);
        }
    }

    private double convertToNanos(double number, String unit) {
        ICyclesConverter adapter;
        if (unit.equalsIgnoreCase("ms")) {
            return number * 1000000.0;
        }
        if (unit.equalsIgnoreCase("us")) {
            return number * 1000.0;
        }
        if (unit.equalsIgnoreCase("ns")) {
            return number;
        }
        if (unit.equalsIgnoreCase("cycles") && this.fTrace instanceof IAdaptable && (adapter = (ICyclesConverter)((IAdaptable)this.fTrace).getAdapter(ICyclesConverter.class)) != null) {
            return adapter.cyclesToNanos((long)number);
        }
        return number;
    }

    private @NonNull RGBA getColor(Marker marker) {
        RGBA color = this.fColors.get(marker);
        if (color == null) {
            color = ConfigurableMarkerEventSource.parseColor(marker.getColor());
            this.fColors.put(marker, color);
        }
        return color;
    }

    private static @NonNull RGBA getOddColor(RGBA color) {
        return new RGBA(color.rgb.red, color.rgb.green, color.rgb.blue, 0);
    }

    private static @NonNull RGBA parseColor(String color) {
        RGB rgb = null;
        if (color.matches(COLOR_REGEX)) {
            rgb = ColorUtils.fromHexColor(color);
        } else {
            rgb = ColorUtils.fromX11Color(color);
            if (rgb == null) {
                rgb = new RGB(0, 0, 0);
            }
        }
        return new RGBA(rgb.red, rgb.green, rgb.blue, 10);
    }

    @Override
    public List<String> getMarkerCategories() {
        LinkedHashSet<String> categories = new LinkedHashSet<String>();
        for (IConfigurableMarkerEventSource source : this.fMarkerEventSources) {
            categories.addAll(source.getMarkerCategories());
            this.getSubMarkerCategories(categories, source.getSubMarkers());
        }
        return (List)NonNullUtils.checkNotNull((Object)Lists.newArrayList(categories));
    }

    private void getSubMarkerCategories(Set<String> categories, List<SubMarker> subMarkers) {
        for (SubMarker subMarker : subMarkers) {
            categories.add(subMarker.getName());
            this.getSubMarkerCategories(categories, subMarker.getSubMarkers());
            if (!(subMarker instanceof SubMarker.WeightedMarker)) continue;
            for (MarkerSegment segment : ((SubMarker.WeightedMarker)subMarker).getSegments()) {
                this.getSubMarkerCategories(categories, segment.getSubMarkers());
            }
        }
    }

    @Override
    public List<IMarkerEvent> getMarkerList(String category, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        return this.getMarkerList(startTime, endTime, resolution, monitor).stream().filter(marker -> marker.getCategory().equals(category)).collect(Collectors.toList());
    }

    @Override
    public List<IMarkerEvent> getMarkerList(long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        @NonNull ArrayList<@NonNull IMarkerEvent> markerList = new ArrayList<IMarkerEvent>();
        for (IConfigurableMarkerEventSource source : this.fMarkerEventSources) {
            long minDuration = resolution * 5L;
            if (!(source.getMaxDuration() > (double)minDuration)) continue;
            @NonNull List<@NonNull IMarkerEvent> list = source.getMarkerList(startTime, endTime, resolution, monitor);
            for (IMarkerEvent markerEvent : list) {
                for (SubMarker subMarker : source.getSubMarkers()) {
                    this.getSubMarkerList(subMarker, markerEvent, markerList, startTime, endTime, minDuration);
                }
                markerList.add(markerEvent);
            }
        }
        markerList.sort(Comparator.comparingLong(marker -> marker.getTime()));
        return markerList;
    }

    private void getSubMarkerList(SubMarker subMarker, IMarkerEvent markerEvent, @NonNull List<@NonNull IMarkerEvent> markerList, long startTime, long endTime, long minDuration) {
        if (subMarker instanceof SubMarker.SplitMarker) {
            this.getSubMarkerList((SubMarker.SplitMarker)subMarker, markerEvent, markerList, startTime, endTime, minDuration);
        } else if (subMarker instanceof SubMarker.WeightedMarker) {
            this.getSubMarkerList((SubMarker.WeightedMarker)subMarker, markerEvent, markerList, startTime, endTime, minDuration);
        }
    }

    private void getSubMarkerList(SubMarker.SplitMarker splitMarker, IMarkerEvent markerEvent, @NonNull List<@NonNull IMarkerEvent> markerList, long startTime, long endTime, long minDuration) {
        if (markerEvent.getTime() > endTime || markerEvent.getTime() + markerEvent.getDuration() < startTime) {
            return;
        }
        long lower = (Long)splitMarker.getRange().lowerEndpoint();
        long upper = (Long)splitMarker.getRange().upperEndpoint();
        long segments = upper - lower + 1L;
        long start = markerEvent.getTime();
        int i = 0;
        while ((long)i < segments) {
            long end = markerEvent.getTime() + Math.round((double)(i + 1) / (double)segments * (double)markerEvent.getDuration());
            long duration = end - start;
            long labelIndex = lower + (long)i;
            if (end >= startTime && duration > minDuration && splitMarker.getIndexRange().contains((Comparable)Long.valueOf(labelIndex))) {
                RGBA color = (labelIndex & 1L) == 0L ? this.getColor((Marker)splitMarker) : ConfigurableMarkerEventSource.getOddColor(this.getColor((Marker)splitMarker));
                MarkerEvent subMarkerEvent = new MarkerEvent(null, start, end - start, splitMarker.getName(), color, String.format(splitMarker.getLabel(), labelIndex), false);
                for (SubMarker subMarker : splitMarker.getSubMarkers()) {
                    this.getSubMarkerList(subMarker, (IMarkerEvent)subMarkerEvent, markerList, startTime, endTime, minDuration);
                }
                markerList.add(subMarkerEvent);
            }
            if (start >= endTime) break;
            start = end;
            ++i;
        }
    }

    private void getSubMarkerList(SubMarker.WeightedMarker weightedMarker, IMarkerEvent markerEvent, @NonNull List<@NonNull IMarkerEvent> markerList, long startTime, long endTime, long minDuration) {
        if (markerEvent.getTime() > endTime || markerEvent.getTime() + markerEvent.getDuration() < startTime) {
            return;
        }
        long start = markerEvent.getTime();
        long length = 0L;
        int i = 0;
        while (i < weightedMarker.getSegments().size()) {
            MarkerSegment segment = (MarkerSegment)weightedMarker.getSegments().get(i);
            long end = markerEvent.getTime() + Math.round((double)(length += (long)segment.getLength()) / (double)weightedMarker.getTotalLength() * (double)markerEvent.getDuration());
            long duration = end - start;
            if (end >= startTime && duration > minDuration && !segment.getColor().isEmpty()) {
                RGBA color = this.getColor((Marker)segment);
                MarkerEvent subMarkerEvent = new MarkerEvent(null, start, end - start, weightedMarker.getName(), color, String.format(segment.getLabel(), i), false);
                for (SubMarker subMarker : segment.getSubMarkers()) {
                    this.getSubMarkerList(subMarker, (IMarkerEvent)subMarkerEvent, markerList, startTime, endTime, minDuration);
                }
                for (SubMarker subMarker : weightedMarker.getSubMarkers()) {
                    this.getSubMarkerList(subMarker, (IMarkerEvent)subMarkerEvent, markerList, startTime, endTime, minDuration);
                }
                markerList.add(subMarkerEvent);
            }
            if (start >= endTime) break;
            start = end;
            ++i;
        }
    }

    @TmfSignalHandler
    public void markerEventSourceUpdated(TmfMarkerEventSourceUpdatedSignal signal) {
        this.configure(MarkerUtils.getDefaultMarkerSet());
    }

    private class ConfigurablePeriodicMarkerEventSource
    extends PeriodicMarkerEventSource
    implements IConfigurableMarkerEventSource {
        private final Marker fMarker;
        private final long fStartIndex;
        private final String fLabel;
        private final RangeSet<Long> fIndexRange;
        private final double fMaxDuration;

        public ConfigurablePeriodicMarkerEventSource(@NonNull Marker marker, @NonNull String category, PeriodicMarkerEventSource.Reference reference, double period, @NonNull long rollover, @NonNull RGBA evenColor, RGBA oddColor, boolean foreground, @NonNull long startIndex, String label, RangeSet<Long> indexRange) {
            super(category, reference, period, rollover, evenColor, oddColor, foreground);
            this.fMarker = marker;
            this.fStartIndex = startIndex;
            this.fLabel = label;
            this.fIndexRange = indexRange;
            this.fMaxDuration = period;
        }

        @Override
        public @NonNull String getMarkerLabel(long index) {
            return (String)NonNullUtils.checkNotNull((Object)String.format(this.fLabel, this.fStartIndex + index));
        }

        @Override
        public boolean isApplicable(long index) {
            if (this.fIndexRange != null) {
                return this.fIndexRange.contains((Comparable)Long.valueOf(this.fStartIndex + index));
            }
            return true;
        }

        @Override
        public double getMaxDuration() {
            return this.fMaxDuration;
        }

        @Override
        public List<SubMarker> getSubMarkers() {
            return this.fMarker.getSubMarkers();
        }
    }

    private static interface IConfigurableMarkerEventSource
    extends IMarkerEventSource {
        public double getMaxDuration();

        public List<SubMarker> getSubMarkers();
    }
}

