/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors.report2;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.errors.report2.IReportEntry;

public final class ProjectReportEntry
implements IReportEntry {
    private static final long MAX_FILE_SIZE = 358400L;
    private final IProject m_project;

    public ProjectReportEntry(IProject project) {
        this.m_project = project;
    }

    @Override
    public void write(final ZipOutputStream zipStream) throws Exception {
        this.m_project.refreshLocal(2, null);
        this.m_project.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                block8: {
                    block7: {
                        long fileSize = ProjectReportEntry.getResourceSize(resource);
                        if (fileSize != 0L && fileSize <= 358400L) break block7;
                        return true;
                    }
                    String fileExtension = resource.getFileExtension();
                    if (fileExtension != null && !fileExtension.equalsIgnoreCase("class")) break block8;
                    return false;
                }
                try {
                    IFile file = (IFile)resource;
                    InputStream fileStream = file.getContents();
                    String filePath = "project/" + StringUtils.removeStart((String)file.getFullPath().toPortableString(), (String)File.separator);
                    zipStream.putNextEntry(new ZipEntry(filePath));
                    try {
                        IOUtils.copy((InputStream)fileStream, (OutputStream)zipStream);
                    }
                    finally {
                        zipStream.closeEntry();
                        IOUtils.closeQuietly((InputStream)fileStream);
                    }
                }
                catch (Throwable e) {
                    DesignerPlugin.log(e);
                }
                return true;
            }
        });
    }

    private static long getResourceSize(IResource resource) {
        if (resource.getType() != 1) {
            return 0L;
        }
        IFile file = (IFile)resource;
        URI location = file.getLocationURI();
        if (location == null) {
            return 0L;
        }
        return new File(location.getSchemeSpecificPart()).length();
    }
}

