/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.metamodel.util.CSSMetaModelUtil;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSCharsetRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSImportRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.SelectionCollector;
import org.eclipse.wst.css.ui.internal.contentassist.CSSCACandidate;
import org.eclipse.wst.css.ui.internal.contentassist.CSSContentAssistContext;
import org.eclipse.wst.css.ui.internal.contentassist.CSSProposalGenerator;
import org.eclipse.wst.css.ui.internal.image.CSSImageType;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

class CSSProposalGeneratorForAtmarkRule
extends CSSProposalGenerator {
    private boolean fUseUpperCase = CSSCorePlugin.getDefault().getPluginPreferences().getInt("identifierCase") == 2;
    private static final String CHARSET = "@charset";
    private static final String FONT_FACE = "@font-face";
    private static final String IMPORT = "@import";
    private static final String MEDIA = "@media";
    private static final String PAGE = "@page";

    CSSProposalGeneratorForAtmarkRule(CSSContentAssistContext context) {
        super(context);
    }

    private CSSCACandidate getCandidateCharsetRule() {
        CSSMetaModelUtil util = new CSSMetaModelUtil(this.fContext.getMetaModel());
        if (!util.collectNodesByType("CSSMM.CharsetRule").hasNext()) {
            return null;
        }
        if (this.fContext.getModel().getStyleSheetType() == "embeddedCSS") {
            return null;
        }
        int offset = this.fContext.getCursorPos();
        if (offset > 0) {
            SelectionCollector trav = new SelectionCollector();
            trav.setRegion(0, offset - 1);
            trav.apply((ICSSNode)this.fContext.getModel().getDocument());
            for (Object obj : trav.getSelectedNodes()) {
                if (!(obj instanceof ICSSNode) || obj instanceof ICSSDocument) continue;
                return null;
            }
        }
        int cursorPos = 0;
        String ident = this.fUseUpperCase ? CHARSET.toUpperCase() : CHARSET.toLowerCase();
        StringBuffer buf = new StringBuffer();
        buf.append(ident);
        buf.append(" ");
        cursorPos = buf.length();
        CSSProposalGenerator.StringAndOffset sao = this.generateQuotes();
        buf.append(sao.fString);
        cursorPos += sao.fOffset;
        sao = this.generateSemicolon();
        buf.append(sao.fString);
        String text = buf.toString();
        if (this.isMatch(text)) {
            CSSCACandidate item = new CSSCACandidate();
            item.setReplacementString(text);
            item.setCursorPosition(cursorPos);
            item.setDisplayString(ident);
            item.setImageType(CSSImageType.RULE_CHARSET);
            return item;
        }
        return null;
    }

    private CSSCACandidate getCandidateFontFaceRule() {
        CSSMetaModelUtil util = new CSSMetaModelUtil(this.fContext.getMetaModel());
        if (!util.collectNodesByType("CSSMM.FontFaceRule").hasNext()) {
            return null;
        }
        int cursorPos = 0;
        String ident = this.fUseUpperCase ? FONT_FACE.toUpperCase() : FONT_FACE.toLowerCase();
        StringBuffer buf = new StringBuffer();
        buf.append(ident);
        buf.append(" ");
        cursorPos = buf.length();
        CSSProposalGenerator.StringAndOffset sao = this.generateBraces();
        buf.append(sao.fString);
        cursorPos += sao.fOffset;
        String text = buf.toString();
        if (this.isMatch(text)) {
            CSSCACandidate item = new CSSCACandidate();
            item.setReplacementString(buf.toString());
            item.setCursorPosition(cursorPos);
            item.setDisplayString(ident);
            item.setImageType(CSSImageType.RULE_FONTFACE);
            return item;
        }
        return null;
    }

    private CSSCACandidate getCandidateImportRule() {
        CSSMetaModelUtil util = new CSSMetaModelUtil(this.fContext.getMetaModel());
        if (!util.collectNodesByType("CSSMM.ImportRule").hasNext()) {
            return null;
        }
        int offset = this.fContext.getCursorPos();
        if (offset > 0) {
            SelectionCollector trav = new SelectionCollector();
            trav.setRegion(0, offset - 1);
            trav.apply((ICSSNode)this.fContext.getModel().getDocument());
            for (Object obj : trav.getSelectedNodes()) {
                if (!(obj instanceof ICSSNode) || obj instanceof ICSSDocument || obj instanceof ICSSCharsetRule || obj instanceof ICSSImportRule) continue;
                return null;
            }
        }
        int cursorPos = 0;
        String ident = this.fUseUpperCase ? IMPORT.toUpperCase() : IMPORT.toLowerCase();
        StringBuffer buf = new StringBuffer();
        buf.append(ident);
        buf.append(" ");
        cursorPos = buf.length();
        CSSProposalGenerator.StringAndOffset sao = this.generateURI();
        buf.append(sao.fString);
        cursorPos += sao.fOffset;
        sao = this.generateSemicolon();
        buf.append(sao.fString);
        String text = buf.toString();
        if (this.isMatch(text)) {
            CSSCACandidate item = new CSSCACandidate();
            item.setReplacementString(buf.toString());
            item.setCursorPosition(cursorPos);
            item.setDisplayString(ident);
            item.setImageType(CSSImageType.RULE_IMPORT);
            return item;
        }
        return null;
    }

    private CSSCACandidate getCandidateMediaRule() {
        CSSMetaModelUtil util = new CSSMetaModelUtil(this.fContext.getMetaModel());
        if (!util.collectNodesByType("CSSMM.MediaRule").hasNext()) {
            return null;
        }
        int cursorPos = 0;
        String ident = this.fUseUpperCase ? MEDIA.toUpperCase() : MEDIA.toLowerCase();
        StringBuffer buf = new StringBuffer();
        buf.append(ident);
        buf.append("  ");
        cursorPos = buf.length() - 1;
        CSSProposalGenerator.StringAndOffset sao = this.generateBraces();
        buf.append(sao.fString);
        String text = buf.toString();
        if (this.isMatch(text)) {
            CSSCACandidate item = new CSSCACandidate();
            item.setReplacementString(buf.toString());
            item.setCursorPosition(cursorPos);
            item.setDisplayString(ident);
            item.setImageType(CSSImageType.RULE_MEDIA);
            return item;
        }
        return null;
    }

    private CSSCACandidate getCandidatePageRule() {
        CSSMetaModelUtil util = new CSSMetaModelUtil(this.fContext.getMetaModel());
        if (!util.collectNodesByType("CSSMM.PageRule").hasNext()) {
            return null;
        }
        int cursorPos = 0;
        String ident = this.fUseUpperCase ? PAGE.toUpperCase() : PAGE.toLowerCase();
        StringBuffer buf = new StringBuffer();
        buf.append(ident);
        buf.append(" ");
        cursorPos = buf.length();
        CSSProposalGenerator.StringAndOffset sao = this.generateBraces();
        buf.append(sao.fString);
        cursorPos += sao.fOffset;
        String text = buf.toString();
        if (this.isMatch(text)) {
            CSSCACandidate item = new CSSCACandidate();
            item.setReplacementString(buf.toString());
            item.setCursorPosition(cursorPos);
            item.setDisplayString(ident);
            item.setImageType(CSSImageType.RULE_PAGE);
            return item;
        }
        return null;
    }

    @Override
    protected Iterator getCandidates() {
        String type;
        ArrayList<CSSCACandidate> candidates = new ArrayList<CSSCACandidate>();
        ITextRegion region = this.fContext.getTargetRegionPrevious();
        if (region != null && (type = region.getType()) != "RBRACE" && type != "DELIMITER") {
            return candidates.iterator();
        }
        CSSCACandidate item = this.getCandidateImportRule();
        if (item != null) {
            candidates.add(item);
        }
        if ((item = this.getCandidateCharsetRule()) != null) {
            candidates.add(item);
        }
        if ((item = this.getCandidateMediaRule()) != null) {
            candidates.add(item);
        }
        if ((item = this.getCandidatePageRule()) != null) {
            candidates.add(item);
        }
        if ((item = this.getCandidateFontFaceRule()) != null) {
            candidates.add(item);
        }
        return candidates.iterator();
    }
}

