/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.refactoring;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.ide.refactoring.DispatchMethodRenameContext;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.ui.refactoring.participant.JvmMemberRenameStrategy;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.impl.DefaultRenameStrategyProvider;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.ui.jvmmodel.refactoring.DefaultJvmModelRenameStrategy;

public class DispatchMethodRenameStrategy
implements DefaultRenameStrategyProvider.IInitializable {
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private Provider<XtendDispatchMethodChildStrategy> childStrategyProvider;
    @Inject
    private Provider<JavaDispatchMethodChildStrategy> javaStrategyProvider;
    private List<IRenameStrategy> children = Lists.newArrayList();
    private List<JvmOperation> dispatchers = Lists.newArrayList();

    public boolean initialize(EObject xtendMethod, IRenameElementContext context) {
        Assert.isLegal((boolean)(xtendMethod instanceof XtendFunction));
        Assert.isLegal((boolean)((XtendFunction)xtendMethod).isDispatch());
        Assert.isLegal((boolean)(context instanceof DispatchMethodRenameContext));
        ResourceSet resourceSet = xtendMethod.eResource().getResourceSet();
        Map jvm2JavaElements = ((DispatchMethodRenameContext)context).getJvm2JavaElements();
        for (URI dispatchOperationURI : jvm2JavaElements.keySet()) {
            JvmOperation dispatchOperation = (JvmOperation)resourceSet.getEObject(dispatchOperationURI, true);
            XtendFunction xtendDispatchMethod = this.associations.getXtendFunction(dispatchOperation);
            if (xtendDispatchMethod != null) {
                if (Strings.equal((String)xtendDispatchMethod.getName(), (String)dispatchOperation.getSimpleName())) {
                    this.dispatchers.add(dispatchOperation);
                    continue;
                }
                XtendDispatchMethodChildStrategy xtendChildStrategy = (XtendDispatchMethodChildStrategy)((Object)this.childStrategyProvider.get());
                xtendChildStrategy.initialize((EObject)xtendDispatchMethod, context);
                this.children.add((IRenameStrategy)xtendChildStrategy);
                continue;
            }
            JavaDispatchMethodChildStrategy jvmChildStrategy = (JavaDispatchMethodChildStrategy)((Object)this.javaStrategyProvider.get());
            jvmChildStrategy.initialize((JvmMember)dispatchOperation, context);
            this.children.add((IRenameStrategy)jvmChildStrategy);
        }
        return !this.children.isEmpty();
    }

    public String getOriginalName() {
        return this.children.get(0).getOriginalName();
    }

    public RefactoringStatus validateNewName(String newName) {
        RefactoringStatus status = new RefactoringStatus();
        for (IRenameStrategy child : this.children) {
            status.merge(child.validateNewName(newName));
        }
        return status;
    }

    public void applyDeclarationChange(String newName, ResourceSet resourceSet) {
        for (IRenameStrategy child : this.children) {
            child.applyDeclarationChange(newName, resourceSet);
        }
        for (JvmOperation dispatcher : this.dispatchers) {
            dispatcher.setSimpleName(newName);
        }
    }

    public void revertDeclarationChange(ResourceSet resourceSet) {
        for (IRenameStrategy child : this.children) {
            child.revertDeclarationChange(resourceSet);
        }
        for (JvmOperation dispatcher : this.dispatchers) {
            dispatcher.setSimpleName(this.getOriginalName());
        }
    }

    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        for (IRenameStrategy child : this.children) {
            child.createDeclarationUpdates(newName, resourceSet, updateAcceptor);
        }
    }

    public static class JavaDispatchMethodChildStrategy
    extends JvmMemberRenameStrategy {
        public void applyDeclarationChange(String newName, ResourceSet resourceSet) {
            super.applyDeclarationChange("_" + newName, resourceSet);
        }
    }

    public static class XtendDispatchMethodChildStrategy
    extends DefaultJvmModelRenameStrategy {
        protected void setInferredJvmElementName(String name, EObject renamedElement) {
            super.setInferredJvmElementName("_" + name, renamedElement);
        }
    }
}

