/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.reviewdb.Account;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AccountInfoCache {
    private static final AccountInfoCache EMPTY = new AccountInfoCache();
    protected Map<Account.Id, AccountInfo> accounts;

    public static AccountInfoCache empty() {
        return EMPTY;
    }

    protected AccountInfoCache() {
    }

    public AccountInfoCache(Iterable<AccountInfo> list) {
        this.accounts = new HashMap<Account.Id, AccountInfo>();
        for (AccountInfo ai : list) {
            this.accounts.put(ai.getId(), ai);
        }
    }

    public AccountInfo get(Account.Id id) {
        if (id == null) {
            return null;
        }
        AccountInfo r = this.accounts.get(id);
        if (r == null) {
            r = new AccountInfo(id);
            this.accounts.put(id, r);
        }
        return r;
    }

    public void merge(AccountInfoCache other) {
        assert (this != EMPTY);
        this.accounts.putAll(other.accounts);
    }

    static {
        AccountInfoCache.EMPTY.accounts = Collections.emptyMap();
    }
}

