/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import com.google.gerrit.reviewdb.PatchSetApproval;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApprovalType {
    protected ApprovalCategory category;
    protected List<ApprovalCategoryValue> values;
    protected short maxNegative;
    protected short maxPositive;
    private transient Map<Short, ApprovalCategoryValue> byValue;

    protected ApprovalType() {
    }

    public ApprovalType(ApprovalCategory ac, List<ApprovalCategoryValue> valueList) {
        this.category = ac;
        this.values = new ArrayList<ApprovalCategoryValue>(valueList);
        Collections.sort(this.values, new Comparator<ApprovalCategoryValue>(){

            @Override
            public int compare(ApprovalCategoryValue o1, ApprovalCategoryValue o2) {
                return o1.getValue() - o2.getValue();
            }
        });
        this.maxNegative = Short.MIN_VALUE;
        this.maxPositive = Short.MAX_VALUE;
        if (this.values.size() > 0) {
            if (this.values.get(0).getValue() < 0) {
                this.maxNegative = this.values.get(0).getValue();
            }
            if (this.values.get(this.values.size() - 1).getValue() > 0) {
                this.maxPositive = this.values.get(this.values.size() - 1).getValue();
            }
        }
    }

    public ApprovalCategory getCategory() {
        return this.category;
    }

    public List<ApprovalCategoryValue> getValues() {
        return this.values;
    }

    public ApprovalCategoryValue getMin() {
        if (this.values.isEmpty()) {
            return null;
        }
        return this.values.get(0);
    }

    public ApprovalCategoryValue getMax() {
        if (this.values.isEmpty()) {
            return null;
        }
        ApprovalCategoryValue v = this.values.get(this.values.size() - 1);
        return v.getValue() > 0 ? v : null;
    }

    public boolean isMaxNegative(PatchSetApproval ca) {
        return this.maxNegative == ca.getValue();
    }

    public boolean isMaxPositive(PatchSetApproval ca) {
        return this.maxPositive == ca.getValue();
    }

    public ApprovalCategoryValue getValue(short value) {
        this.initByValue();
        return this.byValue.get(value);
    }

    public ApprovalCategoryValue getValue(PatchSetApproval ca) {
        this.initByValue();
        return this.byValue.get(ca.getValue());
    }

    private void initByValue() {
        if (this.byValue == null) {
            this.byValue = new HashMap<Short, ApprovalCategoryValue>();
            for (ApprovalCategoryValue acv : this.values) {
                this.byValue.put(acv.getValue(), acv);
            }
        }
    }
}

