/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.resource;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.util.DOMUtil;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Assign;
import org.eclipse.bpel.model.BPELExtensibleElement;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Branches;
import org.eclipse.bpel.model.Catch;
import org.eclipse.bpel.model.CatchAll;
import org.eclipse.bpel.model.Compensate;
import org.eclipse.bpel.model.CompensateScope;
import org.eclipse.bpel.model.CompensationHandler;
import org.eclipse.bpel.model.CompletionCondition;
import org.eclipse.bpel.model.Condition;
import org.eclipse.bpel.model.Copy;
import org.eclipse.bpel.model.Correlation;
import org.eclipse.bpel.model.CorrelationSet;
import org.eclipse.bpel.model.CorrelationSets;
import org.eclipse.bpel.model.Correlations;
import org.eclipse.bpel.model.Documentation;
import org.eclipse.bpel.model.Else;
import org.eclipse.bpel.model.ElseIf;
import org.eclipse.bpel.model.Empty;
import org.eclipse.bpel.model.EventHandler;
import org.eclipse.bpel.model.Exit;
import org.eclipse.bpel.model.Expression;
import org.eclipse.bpel.model.Extension;
import org.eclipse.bpel.model.ExtensionActivity;
import org.eclipse.bpel.model.Extensions;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.Flow;
import org.eclipse.bpel.model.ForEach;
import org.eclipse.bpel.model.From;
import org.eclipse.bpel.model.FromPart;
import org.eclipse.bpel.model.FromParts;
import org.eclipse.bpel.model.If;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.model.Links;
import org.eclipse.bpel.model.MessageExchange;
import org.eclipse.bpel.model.MessageExchanges;
import org.eclipse.bpel.model.OnAlarm;
import org.eclipse.bpel.model.OnEvent;
import org.eclipse.bpel.model.OnMessage;
import org.eclipse.bpel.model.OpaqueActivity;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.PartnerLinks;
import org.eclipse.bpel.model.Pick;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Query;
import org.eclipse.bpel.model.Receive;
import org.eclipse.bpel.model.RepeatUntil;
import org.eclipse.bpel.model.Reply;
import org.eclipse.bpel.model.Rethrow;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.model.Sequence;
import org.eclipse.bpel.model.ServiceRef;
import org.eclipse.bpel.model.Source;
import org.eclipse.bpel.model.Sources;
import org.eclipse.bpel.model.Target;
import org.eclipse.bpel.model.Targets;
import org.eclipse.bpel.model.TerminationHandler;
import org.eclipse.bpel.model.Throw;
import org.eclipse.bpel.model.To;
import org.eclipse.bpel.model.ToPart;
import org.eclipse.bpel.model.ToParts;
import org.eclipse.bpel.model.Validate;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.Variables;
import org.eclipse.bpel.model.Wait;
import org.eclipse.bpel.model.While;
import org.eclipse.bpel.model.adapters.INamespaceMap;
import org.eclipse.bpel.model.extensions.BPELActivitySerializer;
import org.eclipse.bpel.model.extensions.BPELExtensionRegistry;
import org.eclipse.bpel.model.extensions.BPELExtensionSerializer;
import org.eclipse.bpel.model.extensions.ServiceReferenceSerializer;
import org.eclipse.bpel.model.messageproperties.Property;
import org.eclipse.bpel.model.partnerlinktype.PartnerLinkType;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.bpel.model.proxy.IBPELServicesProxy;
import org.eclipse.bpel.model.reordering.IExtensibilityElementListHandler;
import org.eclipse.bpel.model.reordering.extensions.ExtensionFactory;
import org.eclipse.bpel.model.resource.BPELResource;
import org.eclipse.bpel.model.util.BPELConstants;
import org.eclipse.bpel.model.util.BPELServicesUtility;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.ExtensibleElement;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class BPELWriter {
    public static final String SKIP_AUTO_IMPORT = "bpel.skip.auto.import";
    static final String EMPTY_STRING = "";
    private Document document = null;
    private BPELResource fBPELResource = null;
    private WsdlImportsManager wsdlNamespacePrefixManager;
    private List<IExtensibilityElementListHandler> extensibilityElementListHandlers = null;
    protected BPELPackage bpelPackage = null;
    private final BPELExtensionRegistry extensionRegistry = BPELExtensionRegistry.getInstance();

    public BPELWriter() {
    }

    public BPELWriter(BPELResource resource, Document document) {
        this();
        this.fBPELResource = resource;
        this.document = document;
    }

    public BPELResource getResource() {
        return this.fBPELResource;
    }

    public void write(BPELResource resource, OutputStream out, Map<?, ?> args) throws IOException {
        try {
            DocumentBuilderFactoryImpl documentBuilderFactory = new DocumentBuilderFactoryImpl();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            this.document = builder.newDocument();
            this.bpelPackage = BPELPackage.eINSTANCE;
            this.fBPELResource = resource;
            Process process = resource.getProcess();
            this.wsdlNamespacePrefixManager = new WsdlImportsManager(process);
            Boolean skipAutoImport = (Boolean)args.get(SKIP_AUTO_IMPORT);
            if (skipAutoImport == null || !skipAutoImport.booleanValue()) {
                this.walkExternalReferences();
            }
            this.document = this.resource2XML(resource);
            OutputFormat fmt = new OutputFormat(this.document);
            fmt.setIndenting(true);
            fmt.setIndent(4);
            XMLSerializer serializer = new XMLSerializer(out, fmt);
            serializer.serialize(this.document);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String toXML(EObject eObj) {
        DocumentBuilderFactoryImpl documentBuilderFactory = new DocumentBuilderFactoryImpl();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        DocumentBuilder builder = null;
        try {
            builder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception ex) {
            return EMPTY_STRING;
        }
        this.document = builder.newDocument();
        this.bpelPackage = BPELPackage.eINSTANCE;
        this.wsdlNamespacePrefixManager = eObj instanceof Process ? new WsdlImportsManager((Process)eObj) : null;
        this.anyBPELObject2xml(eObj);
        OutputFormat fmt = new OutputFormat(this.document);
        fmt.setIndenting(true);
        fmt.setIndent(4);
        fmt.setOmitDocumentType(true);
        fmt.setOmitXMLDeclaration(true);
        StringWriter out = new StringWriter();
        XMLSerializer serializer = new XMLSerializer((Writer)out, fmt);
        try {
            serializer.serialize(this.document);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out.toString();
    }

    protected Document anyBPELObject2xml(EObject eObj) {
        Element element = this.anyObject2xml(eObj);
        this.document.appendChild(element);
        this.serializePrefixes(eObj, element);
        return this.document;
    }

    protected Element anyObject2xml(EObject eObj) {
        String methodName = eObj.eClass().getName();
        methodName = String.valueOf(Character.toLowerCase(methodName.charAt(0))) + methodName.substring(1) + "2XML";
        Method serializeMethod = this.lookupMethod(this.getClass(), methodName, EObject.class);
        if (serializeMethod == null) {
            throw new IllegalArgumentException("No serialize method " + methodName);
        }
        Class<?> paramClazz = serializeMethod.getParameterTypes()[0];
        try {
            return (Element)serializeMethod.invoke((Object)this, paramClazz.cast(eObj));
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IllegalArgumentException("Cannot serialize object " + eObj);
        }
    }

    Method lookupMethod(Class<?> target, String methodName, Class<?> ... args) {
        if (target == null || target == Object.class) {
            return null;
        }
        Method[] methodArray = target.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (methodName.equals(m.getName()) && m.getParameterTypes().length == args.length) {
                Class<?>[] argTypes = m.getParameterTypes();
                int i = 0;
                while (i < args.length) {
                    if (!args[i].isAssignableFrom(argTypes[i])) {
                        // empty if block
                    }
                    ++i;
                }
                return m;
            }
            ++n2;
        }
        return this.lookupMethod(target.getSuperclass(), methodName, args);
    }

    protected Document resource2XML(BPELResource resource) {
        Process process = resource.getProcess();
        Element procElement = this.process2XML(process);
        this.document.appendChild(procElement);
        this.serializePrefixes((EObject)process, procElement);
        return this.document;
    }

    protected Element process2XML(Process process) {
        Element processElement = this.createBPELElement("process");
        if (process.getName() != null) {
            processElement.setAttribute("name", process.getName());
        }
        if (process.getTargetNamespace() != null) {
            processElement.setAttribute("targetNamespace", process.getTargetNamespace());
        }
        if (process.isSetSuppressJoinFailure()) {
            processElement.setAttribute("suppressJoinFailure", BPELUtils.boolean2XML(process.getSuppressJoinFailure()));
        }
        if (process.getExitOnStandardFault() != null) {
            processElement.setAttribute("exitOnStandardFault", BPELUtils.boolean2XML(process.getExitOnStandardFault()));
        }
        if (process.isSetVariableAccessSerializable()) {
            processElement.setAttribute("variableAccessSerializable", BPELUtils.boolean2XML(process.getVariableAccessSerializable()));
        }
        if (process.isSetQueryLanguage()) {
            processElement.setAttribute("queryLanguage", process.getQueryLanguage());
        }
        if (process.isSetExpressionLanguage()) {
            processElement.setAttribute("expressionLanguage", process.getExpressionLanguage());
        }
        if (process.isSetAbstractProcessProfile()) {
            processElement.setAttribute("abstractProcessProfile", process.getAbstractProcessProfile());
        }
        for (Object next : process.getImports()) {
            processElement.appendChild(this.import2XML((Import)next));
        }
        if (process.getPartnerLinks() != null && !process.getPartnerLinks().getChildren().isEmpty()) {
            processElement.appendChild(this.partnerLinks2XML(process.getPartnerLinks()));
        }
        if (process.getVariables() != null && !process.getVariables().getChildren().isEmpty()) {
            processElement.appendChild(this.variables2XML(process.getVariables()));
        }
        if (process.getCorrelationSets() != null && !process.getCorrelationSets().getChildren().isEmpty()) {
            processElement.appendChild(this.correlationSets2XML(process.getCorrelationSets()));
        }
        if (process.getExtensions() != null) {
            processElement.appendChild(this.extensions2XML(process.getExtensions()));
        }
        if (process.getFaultHandlers() != null) {
            processElement.appendChild(this.faultHandlers2XML(process.getFaultHandlers()));
        }
        if (process.getEventHandlers() != null) {
            processElement.appendChild(this.eventHandler2XML(process.getEventHandlers()));
        }
        if (process.getMessageExchanges() != null && !process.getMessageExchanges().getChildren().isEmpty()) {
            processElement.appendChild(this.messageExchanges2XML(process.getMessageExchanges()));
        }
        if (process.getActivity() != null) {
            processElement.appendChild(this.activity2XML(process.getActivity()));
        }
        this.extensibleElement2XML(process, processElement);
        return processElement;
    }

    protected void walkExternalReferences() {
        Map crossReferences = EcoreUtil.ExternalCrossReferencer.find((Resource)this.getResource());
        for (Object name : crossReferences.keySet()) {
            EObject externalObject = (EObject)name;
            String namespace = this.getNamespace(externalObject);
            if ("http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                this.addNewRootPrefix("xsd", namespace);
                continue;
            }
            if (namespace == null || externalObject.eResource() == null) continue;
            this.wsdlNamespacePrefixManager.ensureImported(externalObject.eResource(), namespace);
        }
    }

    protected QName getQName(EObject object) {
        QName qname = null;
        if (object.eIsProxy() && object instanceof IBPELServicesProxy) {
            qname = ((IBPELServicesProxy)object).getQName();
        } else if (object instanceof PartnerLinkType) {
            qname = BPELServicesUtility.getQName((PartnerLinkType)object);
        } else if (object instanceof Property) {
            qname = BPELServicesUtility.getQName((Property)object);
        }
        return qname;
    }

    protected String getNamespace(EObject object) {
        String namespace = null;
        if (object instanceof IBPELServicesProxy) {
            return ((IBPELServicesProxy)object).getQName().getNamespaceURI();
        }
        if (object instanceof PartnerLinkType || object instanceof Property) {
            Definition def = ((ExtensibilityElement)object).getEnclosingDefinition();
            if (def != null) {
                namespace = def.getTargetNamespace();
            }
        } else {
            if (object instanceof XSDNamedComponent) {
                return ((XSDNamedComponent)object).getTargetNamespace();
            }
            Iterator featureIt = object.eClass().getEAllAttributes().iterator();
            while (featureIt.hasNext() && namespace == null) {
                QName qName;
                EAttribute attr = (EAttribute)featureIt.next();
                if (!attr.getName().equals("qName") || (qName = (QName)object.eGet((EStructuralFeature)attr)) == null) continue;
                namespace = qName.getNamespaceURI();
            }
        }
        return namespace;
    }

    protected String getOperationSignature(Operation op) {
        String signature = EMPTY_STRING;
        if (op != null) {
            signature = op.getName();
        }
        return signature;
    }

    protected Element import2XML(Import imp) {
        Element importElement = this.createBPELElement("import");
        if (imp.getNamespace() != null) {
            importElement.setAttribute("namespace", imp.getNamespace());
        }
        if (imp.getLocation() != null) {
            importElement.setAttribute("location", imp.getLocation());
        }
        if (imp.getImportType() != null) {
            importElement.setAttribute("importType", imp.getImportType());
        }
        this.serializePrefixes((EObject)imp, importElement);
        return importElement;
    }

    protected Element partnerLinks2XML(PartnerLinks partnerLinks) {
        if (partnerLinks.getChildren().isEmpty()) {
            return null;
        }
        Element partnerLinksElement = this.createBPELElement("partnerLinks");
        for (Object next : partnerLinks.getChildren()) {
            partnerLinksElement.appendChild(this.partnerLink2XML((PartnerLink)next));
        }
        this.serializePrefixes((EObject)partnerLinks, partnerLinksElement);
        this.extensibleElement2XML(partnerLinks, partnerLinksElement);
        return partnerLinksElement;
    }

    protected Element partnerLink2XML(PartnerLink partnerLink) {
        PartnerLinkType plt;
        Element partnerLinkElement = this.createBPELElement("partnerLink");
        if (partnerLink.getName() != null) {
            partnerLinkElement.setAttribute("name", partnerLink.getName());
        }
        if (partnerLink.isSetInitializePartnerRole()) {
            partnerLinkElement.setAttribute("initializePartnerRole", BPELUtils.boolean2XML(partnerLink.getInitializePartnerRole()));
        }
        if ((plt = partnerLink.getPartnerLinkType()) != null) {
            Role partnerRole;
            String qnameStr = this.qNameToString((EObject)partnerLink, this.getQName((EObject)plt));
            partnerLinkElement.setAttribute("partnerLinkType", qnameStr);
            Role myRole = partnerLink.getMyRole();
            if (myRole != null) {
                partnerLinkElement.setAttribute("myRole", myRole.getName());
            }
            if ((partnerRole = partnerLink.getPartnerRole()) != null) {
                partnerLinkElement.setAttribute("partnerRole", partnerRole.getName());
            }
        }
        this.serializePrefixes((EObject)partnerLink, partnerLinkElement);
        this.extensibleElement2XML(partnerLink, partnerLinkElement);
        return partnerLinkElement;
    }

    protected Element variables2XML(Variables variables) {
        if (variables.getChildren().isEmpty()) {
            return null;
        }
        Element variablesElement = this.createBPELElement("variables");
        for (Object next : variables.getChildren()) {
            Variable variable = (Variable)next;
            variablesElement.appendChild(this.variable2XML(variable));
        }
        this.extensibleElement2XML(variables, variablesElement);
        this.serializePrefixes((EObject)variables, variablesElement);
        this.extensibleElement2XML(variables, variablesElement);
        return variablesElement;
    }

    protected Element variable2XML(Variable variable) {
        From from;
        QName qname;
        Message msg;
        Element variableElement = this.createBPELElement("variable");
        if (variable.getName() != null) {
            variableElement.setAttribute("name", variable.getName());
        }
        if ((msg = variable.getMessageType()) != null) {
            variableElement.setAttribute("messageType", this.qNameToString((EObject)variable, msg.getQName()));
        }
        if (variable.getType() != null) {
            XSDTypeDefinition type = variable.getType();
            qname = new QName(type.getTargetNamespace(), type.getName());
            variableElement.setAttribute("type", this.qNameToString((EObject)variable, qname));
        }
        if (variable.getXSDElement() != null) {
            XSDElementDeclaration element = variable.getXSDElement();
            qname = new QName(element.getTargetNamespace(), element.getName());
            variableElement.setAttribute("element", this.qNameToString((EObject)variable, qname));
        }
        if ((from = variable.getFrom()) != null) {
            Element fromElement = this.createBPELElement("from");
            this.from2XML(from, fromElement);
            variableElement.appendChild(fromElement);
        }
        this.serializePrefixes((EObject)variable, variableElement);
        this.extensibleElement2XML(variable, variableElement);
        return variableElement;
    }

    protected Element fromPart2XML(FromPart fromPart) {
        Element fromPartElement = this.createBPELElement("fromPart");
        if (fromPart.getPart() != null) {
            fromPartElement.setAttribute("part", fromPart.getPart().getName());
        }
        if (fromPart.getToVariable() != null) {
            fromPartElement.setAttribute("toVariable", fromPart.getToVariable().getName());
        }
        this.serializePrefixes((EObject)fromPart, fromPartElement);
        return fromPartElement;
    }

    protected Element toPart2XML(ToPart toPart) {
        Element toPartElement = this.createBPELElement("toPart");
        if (toPart.getPart() != null) {
            toPartElement.setAttribute("part", toPart.getPart().getName());
        }
        if (toPart.getFromVariable() != null) {
            toPartElement.setAttribute("fromVariable", toPart.getFromVariable().getName());
        }
        this.serializePrefixes((EObject)toPart, toPartElement);
        return toPartElement;
    }

    protected Element extensions2XML(Extensions extensions) {
        Element extensionsElement = this.createBPELElement("extensions");
        for (Extension extension : extensions.getChildren()) {
            extensionsElement.appendChild(this.extension2XML(extension));
        }
        this.serializePrefixes((EObject)extensions, extensionsElement);
        this.extensibleElement2XML(extensions, extensionsElement);
        return extensionsElement;
    }

    protected Element extension2XML(Extension extension) {
        Element extensionElement = this.createBPELElement("extension");
        if (extension.getNamespace() != null) {
            extensionElement.setAttribute("namespace", extension.getNamespace());
        }
        if (extension.isSetMustUnderstand()) {
            extensionElement.setAttribute("mustUnderstand", BPELUtils.boolean2XML(extension.getMustUnderstand()));
        }
        this.serializePrefixes((EObject)extension, extensionElement);
        this.extensibleElement2XML(extension, extensionElement);
        return extensionElement;
    }

    protected Element correlationSets2XML(CorrelationSets correlationSets) {
        if (correlationSets.getChildren().isEmpty()) {
            return null;
        }
        Element correlationSetsElement = this.createBPELElement("correlationSets");
        for (CorrelationSet correlationSet : correlationSets.getChildren()) {
            correlationSetsElement.appendChild(this.correlationSet2XML(correlationSet));
        }
        this.serializePrefixes((EObject)correlationSets, correlationSetsElement);
        this.extensibleElement2XML(correlationSets, correlationSetsElement);
        return correlationSetsElement;
    }

    protected Element correlationSet2XML(CorrelationSet correlationSet) {
        String propertiesList;
        Element correlationSetElement = this.createBPELElement("correlationSet");
        if (correlationSet.getName() != null) {
            correlationSetElement.setAttribute("name", correlationSet.getName());
        }
        if ((propertiesList = this.properties2XML(correlationSet)).length() > 0) {
            correlationSetElement.setAttribute("properties", propertiesList);
        }
        this.serializePrefixes((EObject)correlationSet, correlationSetElement);
        this.extensibleElement2XML(correlationSet, correlationSetElement);
        return correlationSetElement;
    }

    protected String properties2XML(CorrelationSet correlationSet) {
        StringBuffer propertiesList = new StringBuffer();
        Iterator properties = correlationSet.getProperties().iterator();
        while (properties.hasNext()) {
            Property property = (Property)properties.next();
            String qnameStr = this.qNameToString((EObject)correlationSet, this.getQName((EObject)property));
            propertiesList.append(qnameStr);
            if (!properties.hasNext()) continue;
            propertiesList.append(" ");
        }
        return propertiesList.toString();
    }

    protected Element messageExchanges2XML(MessageExchanges messageExchanges) {
        if (messageExchanges.getChildren().isEmpty()) {
            return null;
        }
        Element messageExchangesElement = this.createBPELElement("messageExchanges");
        for (Object next : messageExchanges.getChildren()) {
            messageExchangesElement.appendChild(this.messageExchange2XML((MessageExchange)next));
        }
        this.serializePrefixes((EObject)messageExchanges, messageExchangesElement);
        this.extensibleElement2XML(messageExchanges, messageExchangesElement);
        return messageExchangesElement;
    }

    protected Element messageExchange2XML(MessageExchange messageExchange) {
        Element messageExchangeElement = this.createBPELElement("messageExchange");
        if (messageExchange.getName() != null) {
            messageExchangeElement.setAttribute("name", messageExchange.getName());
        }
        this.serializePrefixes((EObject)messageExchange, messageExchangeElement);
        this.extensibleElement2XML(messageExchange, messageExchangeElement);
        return messageExchangeElement;
    }

    protected Element fromParts2XML(FromParts fromParts) {
        Element fromPartsElement = this.createBPELElement("fromParts");
        for (Object next : fromParts.getChildren()) {
            FromPart fromPart = (FromPart)next;
            fromPartsElement.appendChild(this.fromPart2XML(fromPart));
        }
        this.extensibleElement2XML(fromParts, fromPartsElement);
        this.serializePrefixes((EObject)fromParts, fromPartsElement);
        this.extensibleElement2XML(fromParts, fromPartsElement);
        return fromPartsElement;
    }

    protected Element toParts2XML(ToParts toParts) {
        Element toPartsElement = this.createBPELElement("toParts");
        for (Object next : toParts.getChildren()) {
            ToPart toPart = (ToPart)next;
            toPartsElement.appendChild(this.toPart2XML(toPart));
        }
        this.extensibleElement2XML(toParts, toPartsElement);
        this.serializePrefixes((EObject)toParts, toPartsElement);
        this.extensibleElement2XML(toParts, toPartsElement);
        return toPartsElement;
    }

    protected Element correlations2XML(Correlations correlations) {
        Element correlationsElement = this.createBPELElement("correlations");
        for (Correlation correlation : correlations.getChildren()) {
            correlationsElement.appendChild(this.correlation2XML(correlation));
        }
        this.serializePrefixes((EObject)correlations, correlationsElement);
        this.extensibleElement2XML(correlations, correlationsElement);
        return correlationsElement;
    }

    protected Element correlation2XML(Correlation correlation) {
        Element correlationElement = this.createBPELElement("correlation");
        if (correlation.getSet() != null && correlation.getSet().getName() != null) {
            correlationElement.setAttribute("set", correlation.getSet().getName());
        }
        if (correlation.isSetInitiate()) {
            correlationElement.setAttribute("initiate", correlation.getInitiate());
        }
        if (correlation.isSetPattern()) {
            correlationElement.setAttribute("pattern", correlation.getPattern().getLiteral());
        }
        this.serializePrefixes((EObject)correlation, correlationElement);
        this.extensibleElement2XML(correlation, correlationElement);
        return correlationElement;
    }

    protected Element faultHandlers2XML(FaultHandler faultHandler) {
        Element faultHandlersElement = this.createBPELElement("faultHandlers");
        this.faultHandler2XML(faultHandlersElement, faultHandler);
        this.serializePrefixes((EObject)faultHandler, faultHandlersElement);
        this.extensibleElement2XML(faultHandler, faultHandlersElement);
        return faultHandlersElement;
    }

    protected void faultHandler2XML(Element parentElement, FaultHandler faultHandler) {
        for (Catch _catch : faultHandler.getCatch()) {
            parentElement.appendChild(this.catch2XML(_catch));
        }
        if (faultHandler.getCatchAll() != null) {
            parentElement.appendChild(this.catchAll2XML(faultHandler.getCatchAll()));
        }
    }

    protected Element compensationHandler2XML(CompensationHandler compensationHandler) {
        Element compensationHandlerElement = this.createBPELElement("compensationHandler");
        if (compensationHandler.getActivity() != null) {
            Element activityElement = this.activity2XML(compensationHandler.getActivity());
            compensationHandlerElement.appendChild(activityElement);
        }
        this.serializePrefixes((EObject)compensationHandler, compensationHandlerElement);
        this.extensibleElement2XML(compensationHandler, compensationHandlerElement);
        return compensationHandlerElement;
    }

    protected Element terminationHandler2XML(TerminationHandler terminationHandler) {
        Element terminationHandlerElement = this.createBPELElement("terminationHandler");
        if (terminationHandler.getActivity() != null) {
            Element activityElement = this.activity2XML(terminationHandler.getActivity());
            terminationHandlerElement.appendChild(activityElement);
        }
        this.serializePrefixes((EObject)terminationHandler, terminationHandlerElement);
        this.extensibleElement2XML(terminationHandler, terminationHandlerElement);
        return terminationHandlerElement;
    }

    protected Element eventHandler2XML(EventHandler eventHandler) {
        Element eventHandlerElement = this.createBPELElement("eventHandlers");
        for (Object name : eventHandler.getEvents()) {
            OnEvent onEvent = (OnEvent)name;
            eventHandlerElement.appendChild(this.onEvent2XML(onEvent));
        }
        for (Object name : eventHandler.getAlarm()) {
            OnAlarm onAlarm = (OnAlarm)name;
            eventHandlerElement.appendChild(this.onAlarm2XML(onAlarm));
        }
        this.serializePrefixes((EObject)eventHandler, eventHandlerElement);
        this.extensibleElement2XML(eventHandler, eventHandlerElement);
        return eventHandlerElement;
    }

    public Element activity2XML(Activity activity) {
        Element activityElement = null;
        if (activity instanceof ExtensionActivity) {
            activityElement = this.extensionActivity2XML((ExtensionActivity)activity);
        } else if (activity instanceof Empty) {
            activityElement = this.empty2XML((Empty)activity);
        } else if (activity instanceof Invoke) {
            activityElement = this.invoke2XML((Invoke)activity);
        } else if (activity instanceof Assign) {
            activityElement = this.assign2XML((Assign)activity);
        } else if (activity instanceof Reply) {
            activityElement = this.reply2XML((Reply)activity);
        } else if (activity instanceof Receive) {
            activityElement = this.receive2XML((Receive)activity);
        } else if (activity instanceof Wait) {
            activityElement = this.wait2XML((Wait)activity);
        } else if (activity instanceof Throw) {
            activityElement = this.throw2XML((Throw)activity);
        } else if (activity instanceof Exit) {
            activityElement = this.exit2XML((Exit)activity);
        } else if (activity instanceof Flow) {
            activityElement = this.flow2XML((Flow)activity);
        } else if (activity instanceof If) {
            activityElement = this.if2XML((If)activity);
        } else if (activity instanceof While) {
            activityElement = this.while2XML((While)activity);
        } else if (activity instanceof Sequence) {
            activityElement = this.sequence2XML((Sequence)activity);
        } else if (activity instanceof Pick) {
            activityElement = this.pick2XML((Pick)activity);
        } else if (activity instanceof Scope) {
            activityElement = this.scope2XML((Scope)activity);
        } else if (activity instanceof Compensate) {
            activityElement = this.compensate2XML((Compensate)activity);
        } else if (activity instanceof CompensateScope) {
            activityElement = this.compensateScope2XML((CompensateScope)activity);
        } else if (activity instanceof Rethrow) {
            activityElement = this.rethrow2XML((Rethrow)activity);
        } else if (activity instanceof OpaqueActivity) {
            activityElement = this.opaqueActivity2XML((OpaqueActivity)activity);
        } else if (activity instanceof ForEach) {
            activityElement = this.forEach2XML((ForEach)activity);
        } else if (activity instanceof RepeatUntil) {
            activityElement = this.repeatUntil2XML((RepeatUntil)activity);
        } else if (activity instanceof Validate) {
            activityElement = this.validate2XML((Validate)activity);
        }
        return activityElement;
    }

    protected Element addCommonActivityItems(Element activityElement, Activity activity) {
        this.addStandardAttributes(activityElement, activity);
        this.addStandardElements(activityElement, activity);
        this.serializePrefixes((EObject)activity, activityElement);
        this.extensibleElement2XML(activity, activityElement);
        return activityElement;
    }

    protected void addStandardAttributes(Element activityElement, Activity activity) {
        if (activity.getName() != null) {
            activityElement.setAttribute("name", activity.getName());
        }
        if (activity.isSetSuppressJoinFailure()) {
            activityElement.setAttribute("suppressJoinFailure", BPELUtils.boolean2XML(activity.getSuppressJoinFailure()));
        }
    }

    protected void addStandardElements(Element activityElement, Activity activity) {
        Sources sources;
        Node firstChild = activityElement.getFirstChild();
        Targets targets = activity.getTargets();
        if (targets != null) {
            activityElement.insertBefore(this.targets2XML(targets), firstChild);
        }
        if ((sources = activity.getSources()) != null) {
            activityElement.insertBefore(this.sources2XML(sources), firstChild);
        }
    }

    protected Element catch2XML(Catch _catch) {
        Element catchElement = this.createBPELElement("catch");
        if (_catch.getFaultName() != null) {
            catchElement.setAttribute("faultName", this.qNameToString((EObject)_catch, _catch.getFaultName()));
        }
        if (_catch.getFaultVariable() != null) {
            catchElement.setAttribute("faultVariable", _catch.getFaultVariable().getName());
        }
        if (_catch.getFaultMessageType() != null) {
            catchElement.setAttribute("faultMessageType", this.qNameToString((EObject)_catch, _catch.getFaultMessageType().getQName()));
        }
        if (_catch.getFaultElement() != null) {
            XSDElementDeclaration element = _catch.getFaultElement();
            QName qname = new QName(element.getTargetNamespace(), element.getName());
            catchElement.setAttribute("faultElement", this.qNameToString((EObject)_catch, qname));
        }
        if (_catch.getActivity() != null) {
            catchElement.appendChild(this.activity2XML(_catch.getActivity()));
        }
        this.serializePrefixes((EObject)_catch, catchElement);
        this.extensibleElement2XML(_catch, catchElement);
        return catchElement;
    }

    protected Element catchAll2XML(CatchAll catchAll) {
        Element catchAllElement = this.createBPELElement("catchAll");
        Activity activity = catchAll.getActivity();
        if (activity != null) {
            catchAllElement.appendChild(this.activity2XML(activity));
        }
        this.serializePrefixes((EObject)catchAll, catchAllElement);
        this.extensibleElement2XML(catchAll, catchAllElement);
        return catchAllElement;
    }

    protected Element empty2XML(Empty empty) {
        Element activityElement = this.createBPELElement("empty");
        this.addCommonActivityItems(activityElement, empty);
        return activityElement;
    }

    protected Element opaqueActivity2XML(OpaqueActivity activity) {
        Element activityElement = this.createBPELElement("opaqueActivity");
        INamespaceMap<String, String> nsMap = BPELUtils.getNamespaceMap((EObject)this.fBPELResource.getProcess());
        if (this.fBPELResource.getOptionUseNSPrefix()) {
            nsMap.remove(EMPTY_STRING);
            List<String> prefix = nsMap.getReverse(this.fBPELResource.getNamespaceURI());
            if (prefix.isEmpty()) {
                nsMap.put("bpel", "http://docs.oasis-open.org/wsbpel/2.0/process/abstract");
            } else {
                nsMap.put(prefix.get(0), "http://docs.oasis-open.org/wsbpel/2.0/process/abstract");
            }
        } else {
            nsMap.put(EMPTY_STRING, "http://docs.oasis-open.org/wsbpel/2.0/process/abstract");
        }
        this.fBPELResource.setNamespaceURI("http://docs.oasis-open.org/wsbpel/2.0/process/abstract");
        Process process = this.fBPELResource.getProcess();
        if (!process.isSetAbstractProcessProfile()) {
            process.setAbstractProcessProfile("http://docs.oasis-open.org/wsbpel/2.0/process/abstract/simple-template/2006/08");
        }
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element forEach2XML(ForEach forEach) {
        CompletionCondition completionCondition;
        Element activityElement = this.createBPELElement("forEach");
        if (forEach.getParallel() != null) {
            activityElement.setAttribute("parallel", BPELUtils.boolean2XML(forEach.getParallel()));
        }
        if (forEach.getCounterName() != null) {
            activityElement.setAttribute("counterName", forEach.getCounterName().getName());
        }
        if (forEach.getStartCounterValue() != null) {
            activityElement.appendChild(this.expression2XML(forEach.getStartCounterValue(), "startCounterValue"));
        }
        if (forEach.getFinalCounterValue() != null) {
            activityElement.appendChild(this.expression2XML(forEach.getFinalCounterValue(), "finalCounterValue"));
        }
        if ((completionCondition = forEach.getCompletionCondition()) != null) {
            Element completionConditionElement = this.completionCondition2XML(completionCondition);
            activityElement.appendChild(completionConditionElement);
        }
        if (forEach.getActivity() != null) {
            activityElement.appendChild(this.activity2XML(forEach.getActivity()));
        }
        this.addCommonActivityItems(activityElement, forEach);
        return activityElement;
    }

    protected Element completionCondition2XML(CompletionCondition completionCondition) {
        Element completionConditionElement = this.createBPELElement("completionCondition");
        if (completionCondition.getBranches() != null) {
            Element branchesElement = this.branches2XML(completionCondition.getBranches());
            completionConditionElement.appendChild(branchesElement);
        }
        return completionConditionElement;
    }

    protected Element branches2XML(Branches branches) {
        Element branchesElement = this.expression2XML(branches, "branches");
        if (branches.isSetCountCompletedBranchesOnly()) {
            branchesElement.setAttribute("successfulBranchesOnly", BPELUtils.boolean2XML(branches.getCountCompletedBranchesOnly()));
        }
        return branchesElement;
    }

    protected Element rethrow2XML(Rethrow activity) {
        Element activityElement = this.createBPELElement("rethrow");
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element validate2XML(Validate activity) {
        Element activityElement = this.createBPELElement("validate");
        StringBuilder variablesList = new StringBuilder();
        Iterator variables = activity.getVariables().iterator();
        while (variables.hasNext()) {
            Variable variable = (Variable)variables.next();
            variablesList.append(variable.getName());
            if (!variables.hasNext()) continue;
            variablesList.append(" ");
        }
        if (variablesList.length() > 0) {
            activityElement.setAttribute("variables", variablesList.toString());
        }
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element extensionActivity2XML(ExtensionActivity activity) {
        Element activityElement = this.createBPELElement("extensionActivity");
        String localName = activity.eClass().getName();
        String namespace = activity.eClass().getEPackage().getNsURI();
        QName qName = new QName(namespace, localName);
        BPELActivitySerializer serializer = this.extensionRegistry.getActivitySerializer(qName);
        DocumentFragment fragment = null;
        if (serializer != null) {
            fragment = this.document.createDocumentFragment();
            serializer.marshall(qName, activity, fragment, this.getProcess(), this);
            Element child = this.getFirstChildElement(fragment);
            if (child != null) {
                activityElement.appendChild(child);
            }
        }
        return activityElement;
    }

    protected Element invoke2XML(Invoke activity) {
        FaultHandler faultHandler;
        Element activityElement = this.createBPELElement("invoke");
        if (activity.getPartnerLink() != null) {
            activityElement.setAttribute("partnerLink", activity.getPartnerLink().getName());
        }
        if (activity.getPortType() != null) {
            activityElement.setAttribute("portType", this.qNameToString((EObject)activity, activity.getPortType().getQName()));
        }
        if (activity.getOperation() != null) {
            activityElement.setAttribute("operation", this.getOperationSignature(activity.getOperation()));
        }
        if (activity.getInputVariable() != null) {
            activityElement.setAttribute("inputVariable", activity.getInputVariable().getName());
        }
        if (activity.getOutputVariable() != null) {
            activityElement.setAttribute("outputVariable", activity.getOutputVariable().getName());
        }
        if (activity.getCorrelations() != null) {
            activityElement.appendChild(this.correlations2XML(activity.getCorrelations()));
        }
        if ((faultHandler = activity.getFaultHandler()) != null) {
            this.faultHandler2XML(activityElement, faultHandler);
        }
        if (activity.getCompensationHandler() != null) {
            activityElement.appendChild(this.compensationHandler2XML(activity.getCompensationHandler()));
        }
        if (activity.getFromParts() != null) {
            activityElement.appendChild(this.fromParts2XML(activity.getFromParts()));
        }
        if (activity.getToParts() != null) {
            activityElement.appendChild(this.toParts2XML(activity.getToParts()));
        }
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element receive2XML(Receive activity) {
        Element activityElement = this.createBPELElement("receive");
        if (activity.getPartnerLink() != null) {
            activityElement.setAttribute("partnerLink", activity.getPartnerLink().getName());
        }
        if (activity.getPortType() != null) {
            activityElement.setAttribute("portType", this.qNameToString((EObject)activity, activity.getPortType().getQName()));
        }
        if (activity.getOperation() != null) {
            activityElement.setAttribute("operation", this.getOperationSignature(activity.getOperation()));
        }
        if (activity.getVariable() != null) {
            activityElement.setAttribute("variable", activity.getVariable().getName());
        }
        if (activity.isSetCreateInstance()) {
            activityElement.setAttribute("createInstance", BPELUtils.boolean2XML(activity.getCreateInstance()));
        }
        if (activity.getMessageExchange() != null) {
            activityElement.setAttribute("messageExchange", activity.getMessageExchange().getName());
        }
        if (activity.getCorrelations() != null) {
            activityElement.appendChild(this.correlations2XML(activity.getCorrelations()));
        }
        if (activity.getFromParts() != null) {
            activityElement.appendChild(this.fromParts2XML(activity.getFromParts()));
        }
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element reply2XML(Reply activity) {
        Element activityElement = this.createBPELElement("reply");
        if (activity.getPartnerLink() != null) {
            activityElement.setAttribute("partnerLink", activity.getPartnerLink().getName());
        }
        if (activity.getPortType() != null) {
            activityElement.setAttribute("portType", this.qNameToString((EObject)activity, activity.getPortType().getQName()));
        }
        if (activity.getOperation() != null) {
            activityElement.setAttribute("operation", this.getOperationSignature(activity.getOperation()));
        }
        if (activity.getVariable() != null) {
            activityElement.setAttribute("variable", activity.getVariable().getName());
        }
        if (activity.getFaultName() != null) {
            activityElement.setAttribute("faultName", this.qNameToString((EObject)activity, activity.getFaultName()));
        }
        if (activity.getMessageExchange() != null) {
            activityElement.setAttribute("messageExchange", activity.getMessageExchange().getName());
        }
        if (activity.getCorrelations() != null) {
            activityElement.appendChild(this.correlations2XML(activity.getCorrelations()));
        }
        if (activity.getToParts() != null) {
            activityElement.appendChild(this.toParts2XML(activity.getToParts()));
        }
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element assign2XML(Assign activity) {
        EList<Copy> copies;
        Element activityElement = this.createBPELElement("assign");
        if (activity.getValidate() != null) {
            activityElement.setAttribute("validate", BPELUtils.boolean2XML(activity.getValidate()));
        }
        if (!(copies = activity.getCopy()).isEmpty()) {
            for (Object name : copies) {
                Copy copy = (Copy)name;
                activityElement.appendChild(this.copy2XML(copy));
            }
        }
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element copy2XML(Copy copy) {
        To to;
        From from;
        Element copyElement = this.createBPELElement("copy");
        if (copy.isSetKeepSrcElementName()) {
            copyElement.setAttribute("keepSrcElementName", BPELUtils.boolean2XML(copy.getKeepSrcElementName()));
        }
        if (copy.isSetIgnoreMissingFromData()) {
            copyElement.setAttribute("ignoreMissingFromData", BPELUtils.boolean2XML(copy.getIgnoreMissingFromData()));
        }
        if ((from = copy.getFrom()) != null) {
            Element fromElement = this.createBPELElement("from");
            this.from2XML(from, fromElement);
            copyElement.appendChild(fromElement);
        }
        if ((to = copy.getTo()) != null) {
            Element toElement = this.createBPELElement("to");
            this.to2XML(to, toElement);
            copyElement.appendChild(toElement);
        }
        this.serializePrefixes((EObject)copy, copyElement);
        this.extensibleElement2XML(copy, copyElement);
        return copyElement;
    }

    protected void from2XML(From from, Element fromElement) {
        Property property;
        if (from.getVariable() != null) {
            fromElement.setAttribute("variable", from.getVariable().getName());
        }
        if (from.getPart() != null) {
            fromElement.setAttribute("part", from.getPart().getName());
        }
        if (from.getPartnerLink() != null) {
            fromElement.setAttribute("partnerLink", from.getPartnerLink().getName());
        }
        if ((property = from.getProperty()) != null) {
            String qnameStr = this.qNameToString(from, this.getQName((EObject)property));
            fromElement.setAttribute("property", qnameStr);
        }
        if (from.getQuery() != null) {
            Query query = from.getQuery();
            Element queryElement = this.query2XML(query);
            fromElement.appendChild(queryElement);
        }
        if (from.isSetEndpointReference()) {
            fromElement.setAttribute("endpointReference", from.getEndpointReference().toString());
        }
        if (from.isSetOpaque()) {
            fromElement.setAttribute("opaque", BPELUtils.boolean2XML(from.getOpaque()));
        }
        if (from.isSetLiteral() && from.getLiteral() != null && !from.getLiteral().equals(EMPTY_STRING)) {
            Node node = null;
            Element literal = this.createBPELElement("literal");
            fromElement.appendChild(literal);
            if (Boolean.TRUE.equals(from.getUnsafeLiteral())) {
                node = BPELUtils.convertStringToNode(from, from.getLiteral(), this.getResource());
            }
            if (node != null) {
                Node child = node.getFirstChild();
                while (child != null) {
                    DOMUtil.copyInto((Node)child, (Node)literal);
                    child = child.getNextSibling();
                }
            } else {
                CDATASection cdata = BPELUtils.createCDATASection(this.document, from.getLiteral());
                fromElement.appendChild(cdata);
            }
        }
        if (from.getServiceRef() != null) {
            fromElement.appendChild(this.serviceRef2XML(from.getServiceRef()));
        }
        if (from.getExpression() != null) {
            Expression expression = from.getExpression();
            if (expression.getExpressionLanguage() != null) {
                fromElement.setAttribute("expressionLanguage", expression.getExpressionLanguage());
            }
            if (expression.getBody() != null) {
                CDATASection cdata = BPELUtils.createCDATASection(this.document, (String)expression.getBody());
                fromElement.appendChild(cdata);
            }
        }
        if (from.getType() != null) {
            XSDTypeDefinition type = from.getType();
            QName qname = new QName(type.getTargetNamespace(), type.getName());
            fromElement.setAttribute("xsi:type", this.qNameToString(from, qname));
        }
        this.serializePrefixes(from, fromElement);
        this.extensibleElement2XML(from, fromElement);
    }

    protected Element serviceRef2XML(ServiceRef serviceRef) {
        Node valueNode;
        Element serviceRefElement = this.createBPELElement("service-ref");
        String referenceScheme = serviceRef.getReferenceScheme();
        if (referenceScheme != null) {
            serviceRefElement.setAttribute("reference-scheme", referenceScheme);
        }
        if (serviceRef.getValue() != null && (valueNode = this.serviceRefValue2XML(serviceRef)) != null) {
            serviceRefElement.appendChild(valueNode);
        }
        return serviceRefElement;
    }

    protected Node serviceRefValue2XML(ServiceRef serviceRef) {
        Object value = serviceRef.getValue();
        if (value instanceof javax.wsdl.extensions.ExtensibilityElement) {
            javax.wsdl.extensions.ExtensibilityElement extensibilityElement = (javax.wsdl.extensions.ExtensibilityElement)value;
            BPELExtensionSerializer serializer = null;
            QName qname = extensibilityElement.getElementType();
            try {
                serializer = (BPELExtensionSerializer)this.extensionRegistry.querySerializer(BPELExtensibleElement.class, qname);
            }
            catch (WSDLException wSDLException) {
                // empty catch block
            }
            if (serializer != null) {
                DocumentFragment fragment = this.document.createDocumentFragment();
                try {
                    serializer.marshall(BPELExtensibleElement.class, qname, extensibilityElement, fragment, this.getProcess(), this.extensionRegistry, this);
                    Element child = this.getFirstChildElement(fragment);
                    return child;
                }
                catch (WSDLException e) {
                    throw new WrappedException((Exception)((Object)e));
                }
            }
        } else if (serviceRef.getValue() != null) {
            ServiceReferenceSerializer serializer = this.extensionRegistry.getServiceReferenceSerializer(serviceRef.getReferenceScheme());
            if (serializer != null) {
                DocumentFragment fragment = this.document.createDocumentFragment();
                serializer.marshall(value, fragment, this.getProcess(), serviceRef.eContainer(), this);
                Element child = this.getFirstChildElement(fragment);
                return child;
            }
            CDATASection cdata = BPELUtils.createCDATASection(this.document, serviceRef.getValue().toString());
            return cdata;
        }
        return null;
    }

    protected Element query2XML(Query query) {
        Element queryElement = this.createBPELElement("query");
        if (query.getQueryLanguage() != null) {
            queryElement.setAttribute("queryLanguage", query.getQueryLanguage());
        }
        if (query.getValue() != null) {
            CDATASection cdata = BPELUtils.createCDATASection(this.document, query.getValue());
            queryElement.appendChild(cdata);
        }
        return queryElement;
    }

    protected void to2XML(To to, Element toElement) {
        Property property;
        if (to.getVariable() != null) {
            toElement.setAttribute("variable", to.getVariable().getName());
        }
        if (to.getPart() != null) {
            toElement.setAttribute("part", to.getPart().getName());
        }
        if (to.getPartnerLink() != null) {
            toElement.setAttribute("partnerLink", to.getPartnerLink().getName());
        }
        if ((property = to.getProperty()) != null) {
            String qnameStr = this.qNameToString(to, this.getQName((EObject)property));
            toElement.setAttribute("property", qnameStr);
        }
        if (to.getQuery() != null) {
            Query query = to.getQuery();
            Element queryElement = this.query2XML(query);
            toElement.appendChild(queryElement);
        }
        if (to.getExpression() != null) {
            Expression expression = to.getExpression();
            if (expression.getExpressionLanguage() != null) {
                toElement.setAttribute("expressionLanguage", expression.getExpressionLanguage());
            }
            if (expression.getBody() != null) {
                CDATASection cdata = BPELUtils.createCDATASection(this.document, (String)expression.getBody());
                toElement.appendChild(cdata);
            }
        }
        this.serializePrefixes(to, toElement);
        this.extensibleElement2XML(to, toElement);
    }

    protected Element wait2XML(Wait activity) {
        Element activityElement = this.createBPELElement("wait");
        if (activity.getFor() != null) {
            activityElement.appendChild(this.expression2XML(activity.getFor(), "for"));
        }
        if (activity.getUntil() != null) {
            activityElement.appendChild(this.expression2XML(activity.getUntil(), "until"));
        }
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element throw2XML(Throw activity) {
        Element activityElement = this.createBPELElement("throw");
        if (activity.getFaultVariable() != null && activity.getFaultVariable().getName() != null) {
            activityElement.setAttribute("faultVariable", activity.getFaultVariable().getName());
        }
        if (activity.getFaultName() != null) {
            activityElement.setAttribute("faultName", this.qNameToString((EObject)activity, activity.getFaultName()));
        }
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element exit2XML(Exit activity) {
        Element activityElement = this.createBPELElement("exit");
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    void addActivities(Element activityElement, List<?> listOfActivities) {
        for (Object next : listOfActivities) {
            activityElement.appendChild(this.activity2XML((Activity)next));
        }
    }

    protected Element flow2XML(Flow activity) {
        CompletionCondition completionCondition;
        Element activityElement = this.createBPELElement("flow");
        Links links = activity.getLinks();
        if (links != null) {
            Element linksElement = this.links2XML(links);
            activityElement.appendChild(linksElement);
        }
        if ((completionCondition = activity.getCompletionCondition()) != null) {
            Element completionConditionElement = this.completionCondition2XML(completionCondition);
            activityElement.appendChild(completionConditionElement);
        }
        this.addActivities(activityElement, (List<?>)activity.getActivities());
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element documentation2XML(Documentation documentation) {
        Element documentationElement = this.createBPELElement("documentation");
        if (documentation.getSource() != null) {
            documentationElement.setAttribute("source", documentation.getSource());
        }
        if (documentation.getLang() != null) {
            documentationElement.setAttribute("xml:lang", documentation.getLang());
        }
        if (documentation.getValue() != null && documentation.getValue().length() > 0) {
            Text textNode = documentationElement.getOwnerDocument().createTextNode(documentation.getValue());
            documentationElement.appendChild(textNode);
        }
        return documentationElement;
    }

    protected Element links2XML(Links links) {
        Element linksElement = this.createBPELElement("links");
        for (Object next : links.getChildren()) {
            linksElement.appendChild(this.link2XML((Link)next));
        }
        this.serializePrefixes((EObject)links, linksElement);
        this.extensibleElement2XML(links, linksElement);
        return linksElement;
    }

    protected Element link2XML(Link link) {
        Element linkElement = this.createBPELElement("link");
        if (link.getName() != null) {
            linkElement.setAttribute("name", link.getName());
        }
        this.serializePrefixes((EObject)link, linkElement);
        this.extensibleElement2XML(link, linkElement);
        return linkElement;
    }

    protected Element if2XML(If activity) {
        Else _else;
        EList<ElseIf> elseIfs;
        Element ifElement = this.createBPELElement("if");
        if (activity.getCondition() != null) {
            ifElement.appendChild(this.expression2XML(activity.getCondition(), "condition"));
        }
        if (activity.getActivity() != null) {
            ifElement.appendChild(this.activity2XML(activity.getActivity()));
        }
        if (!(elseIfs = activity.getElseIf()).isEmpty()) {
            for (Object next : elseIfs) {
                ElseIf elseIf = (ElseIf)next;
                ifElement.appendChild(this.elseIf2XML(elseIf));
            }
        }
        if ((_else = activity.getElse()) != null) {
            Element elseElement = this.else2XML(_else);
            ifElement.appendChild(elseElement);
        }
        this.addCommonActivityItems(ifElement, activity);
        return ifElement;
    }

    protected Element elseIf2XML(ElseIf elseIf) {
        Element elseIfElement = this.createBPELElement("elseif");
        if (elseIf.getCondition() != null) {
            elseIfElement.appendChild(this.expression2XML(elseIf.getCondition(), "condition"));
        }
        if (elseIf.getActivity() != null) {
            elseIfElement.appendChild(this.activity2XML(elseIf.getActivity()));
        }
        this.serializePrefixes((EObject)elseIf, elseIfElement);
        this.extensibleElement2XML(elseIf, elseIfElement);
        return elseIfElement;
    }

    protected Element else2XML(Else _else) {
        Element elseElement = this.createBPELElement("else");
        if (_else.getActivity() != null) {
            Element activityElement = this.activity2XML(_else.getActivity());
            elseElement.appendChild(activityElement);
        }
        this.serializePrefixes((EObject)_else, elseElement);
        this.extensibleElement2XML(_else, elseElement);
        return elseElement;
    }

    protected Element while2XML(While activity) {
        Element activityElement = this.createBPELElement("while");
        if (activity.getCondition() != null) {
            activityElement.appendChild(this.expression2XML(activity.getCondition(), "condition"));
        }
        if (activity.getActivity() != null) {
            activityElement.appendChild(this.activity2XML(activity.getActivity()));
        }
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element repeatUntil2XML(RepeatUntil activity) {
        Element activityElement = this.createBPELElement("repeatUntil");
        if (activity.getActivity() != null) {
            activityElement.appendChild(this.activity2XML(activity.getActivity()));
        }
        if (activity.getCondition() != null) {
            activityElement.appendChild(this.expression2XML(activity.getCondition(), "condition"));
        }
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element expression2XML(Expression expression, String elementName) {
        Element expressionElement = this.createBPELElement(elementName);
        if (expression.getExpressionLanguage() != null) {
            expressionElement.setAttribute("expressionLanguage", expression.getExpressionLanguage());
        }
        if (expression.getOpaque() != null) {
            expressionElement.setAttribute("opaque", BPELUtils.boolean2XML(expression.getOpaque()));
        }
        if (expression.getBody() != null) {
            Object body = expression.getBody();
            if (body instanceof javax.wsdl.extensions.ExtensibilityElement) {
                javax.wsdl.extensions.ExtensibilityElement extensibilityElement = (javax.wsdl.extensions.ExtensibilityElement)body;
                Element child = this.extensibilityElement2XML(extensibilityElement);
                if (child != null) {
                    expressionElement.appendChild(child);
                }
            } else {
                CDATASection cdata = BPELUtils.createCDATASection(this.document, expression.getBody().toString());
                expressionElement.appendChild(cdata);
            }
        }
        return expressionElement;
    }

    protected Element sequence2XML(Sequence activity) {
        Element activityElement = this.createBPELElement("sequence");
        this.addActivities(activityElement, (List<?>)activity.getActivities());
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element sources2XML(Sources sources) {
        Element sourcesElement = this.createBPELElement("sources");
        for (Object next : sources.getChildren()) {
            sourcesElement.appendChild(this.source2XML((Source)next));
        }
        this.extensibleElement2XML(sources, sourcesElement);
        return sourcesElement;
    }

    protected Element source2XML(Source source) {
        Element sourceElement = this.createBPELElement("source");
        sourceElement.setAttribute("linkName", source.getLink().getName());
        Condition transitionCondition = source.getTransitionCondition();
        if (transitionCondition != null) {
            sourceElement.appendChild(this.expression2XML(transitionCondition, "transitionCondition"));
        }
        this.extensibleElement2XML(source, sourceElement);
        return sourceElement;
    }

    protected Element targets2XML(Targets targets) {
        Element targetsElement = this.createBPELElement("targets");
        Condition joinCondition = targets.getJoinCondition();
        if (joinCondition != null) {
            targetsElement.appendChild(this.expression2XML(joinCondition, "joinCondition"));
        }
        for (Object next : targets.getChildren()) {
            targetsElement.appendChild(this.target2XML((Target)next));
        }
        this.extensibleElement2XML(targets, targetsElement);
        return targetsElement;
    }

    protected Element target2XML(Target target) {
        Element targetElement = this.createBPELElement("target");
        targetElement.setAttribute("linkName", target.getLink().getName());
        this.extensibleElement2XML(target, targetElement);
        return targetElement;
    }

    protected Element onMessage2XML(OnMessage onMsg) {
        Element onMessageElement = this.createBPELElement("onMessage");
        if (onMsg.getPartnerLink() != null && onMsg.getPartnerLink().getName() != null) {
            onMessageElement.setAttribute("partnerLink", onMsg.getPartnerLink().getName());
        }
        if (onMsg.getPortType() != null && onMsg.getPortType().getQName() != null) {
            onMessageElement.setAttribute("portType", this.qNameToString((EObject)onMsg, onMsg.getPortType().getQName()));
        }
        if (onMsg.getOperation() != null) {
            onMessageElement.setAttribute("operation", this.getOperationSignature(onMsg.getOperation()));
        }
        if (onMsg.getVariable() != null && onMsg.getVariable().getName() != null) {
            onMessageElement.setAttribute("variable", onMsg.getVariable().getName());
        }
        if (onMsg.getMessageExchange() != null) {
            onMessageElement.setAttribute("messageExchange", onMsg.getMessageExchange().getName());
        }
        if (onMsg.getCorrelations() != null) {
            onMessageElement.appendChild(this.correlations2XML(onMsg.getCorrelations()));
        }
        if (onMsg.getActivity() != null) {
            onMessageElement.appendChild(this.activity2XML(onMsg.getActivity()));
        }
        if (onMsg.getFromParts() != null) {
            onMessageElement.appendChild(this.fromParts2XML(onMsg.getFromParts()));
        }
        this.serializePrefixes((EObject)onMsg, onMessageElement);
        this.extensibleElement2XML(onMsg, onMessageElement);
        return onMessageElement;
    }

    protected Element onEvent2XML(OnEvent onEvent) {
        Element onEventElement = this.createBPELElement("onEvent");
        if (onEvent.getPartnerLink() != null && onEvent.getPartnerLink().getName() != null) {
            onEventElement.setAttribute("partnerLink", onEvent.getPartnerLink().getName());
        }
        if (onEvent.getPortType() != null && onEvent.getPortType().getQName() != null) {
            onEventElement.setAttribute("portType", this.qNameToString((EObject)onEvent, onEvent.getPortType().getQName()));
        }
        if (onEvent.getOperation() != null) {
            onEventElement.setAttribute("operation", this.getOperationSignature(onEvent.getOperation()));
        }
        if (onEvent.getVariable() != null && onEvent.getVariable().getName() != null) {
            onEventElement.setAttribute("variable", onEvent.getVariable().getName());
        }
        if (onEvent.getMessageExchange() != null) {
            onEventElement.setAttribute("messageExchange", onEvent.getMessageExchange().getName());
        }
        if (onEvent.getMessageType() != null) {
            onEventElement.setAttribute("messageType", this.qNameToString((EObject)onEvent, onEvent.getMessageType().getQName()));
        }
        if (onEvent.getXSDElement() != null) {
            onEventElement.setAttribute("element", onEvent.getXSDElement().getQName());
        }
        if (onEvent.getCorrelationSets() != null) {
            onEventElement.appendChild(this.correlationSets2XML(onEvent.getCorrelationSets()));
        }
        if (onEvent.getCorrelations() != null) {
            onEventElement.appendChild(this.correlations2XML(onEvent.getCorrelations()));
        }
        if (onEvent.getActivity() != null) {
            onEventElement.appendChild(this.activity2XML(onEvent.getActivity()));
        }
        if (onEvent.getFromParts() != null) {
            onEventElement.appendChild(this.fromParts2XML(onEvent.getFromParts()));
        }
        this.serializePrefixes((EObject)onEvent, onEventElement);
        this.extensibleElement2XML(onEvent, onEventElement);
        return onEventElement;
    }

    protected Element onAlarm2XML(OnAlarm onAlarm) {
        Element onAlarmElement = this.createBPELElement("onAlarm");
        if (onAlarm.getFor() != null) {
            onAlarmElement.appendChild(this.expression2XML(onAlarm.getFor(), "for"));
        }
        if (onAlarm.getUntil() != null) {
            onAlarmElement.appendChild(this.expression2XML(onAlarm.getUntil(), "until"));
        }
        if (onAlarm.getRepeatEvery() != null) {
            onAlarmElement.appendChild(this.expression2XML(onAlarm.getRepeatEvery(), "repeatEvery"));
        }
        if (onAlarm.getActivity() != null) {
            onAlarmElement.appendChild(this.activity2XML(onAlarm.getActivity()));
        }
        this.serializePrefixes((EObject)onAlarm, onAlarmElement);
        this.extensibleElement2XML(onAlarm, onAlarmElement);
        return onAlarmElement;
    }

    protected Element pick2XML(Pick activity) {
        Element activityElement = this.createBPELElement("pick");
        if (activity.isSetCreateInstance()) {
            activityElement.setAttribute("createInstance", BPELUtils.boolean2XML(activity.getCreateInstance()));
        }
        for (Object next : activity.getMessages()) {
            activityElement.appendChild(this.onMessage2XML((OnMessage)next));
        }
        for (Object next : activity.getAlarm()) {
            activityElement.appendChild(this.onAlarm2XML((OnAlarm)next));
        }
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element scope2XML(Scope activity) {
        Element activityElement = this.createBPELElement("scope");
        if (activity.isSetIsolated()) {
            activityElement.setAttribute("isolated", BPELUtils.boolean2XML(activity.getIsolated()));
        }
        if (activity.isSetExitOnStandardFault()) {
            activityElement.setAttribute("exitOnStandardFault", BPELUtils.boolean2XML(activity.getExitOnStandardFault()));
        }
        if (activity.getVariables() != null && !activity.getVariables().getChildren().isEmpty()) {
            activityElement.appendChild(this.variables2XML(activity.getVariables()));
        }
        if (activity.getCorrelationSets() != null && !activity.getCorrelationSets().getChildren().isEmpty()) {
            activityElement.appendChild(this.correlationSets2XML(activity.getCorrelationSets()));
        }
        if (activity.getPartnerLinks() != null && !activity.getPartnerLinks().getChildren().isEmpty()) {
            activityElement.appendChild(this.partnerLinks2XML(activity.getPartnerLinks()));
        }
        if (activity.getFaultHandlers() != null) {
            activityElement.appendChild(this.faultHandlers2XML(activity.getFaultHandlers()));
        }
        if (activity.getCompensationHandler() != null) {
            activityElement.appendChild(this.compensationHandler2XML(activity.getCompensationHandler()));
        }
        if (activity.getTerminationHandler() != null) {
            activityElement.appendChild(this.terminationHandler2XML(activity.getTerminationHandler()));
        }
        if (activity.getEventHandlers() != null) {
            activityElement.appendChild(this.eventHandler2XML(activity.getEventHandlers()));
        }
        if (activity.getMessageExchanges() != null && !activity.getMessageExchanges().getChildren().isEmpty()) {
            activityElement.appendChild(this.messageExchanges2XML(activity.getMessageExchanges()));
        }
        if (activity.getActivity() != null) {
            activityElement.appendChild(this.activity2XML(activity.getActivity()));
        }
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element compensateScope2XML(CompensateScope activity) {
        Element activityElement = this.createBPELElement("compensateScope");
        Activity scopeOrInvoke = activity.getTarget();
        if (scopeOrInvoke != null) {
            activityElement.setAttribute("scope", scopeOrInvoke.getName());
        }
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected Element compensate2XML(Compensate activity) {
        Element activityElement = this.createBPELElement("compensate");
        this.addCommonActivityItems(activityElement, activity);
        return activityElement;
    }

    protected QName getQName(ExtensibilityElement element, String localName) {
        EObject container = null;
        container = element.eContainer();
        while (container != null && !(container instanceof Definition)) {
            container = container.eContainer();
        }
        if (container == null) {
            return null;
        }
        return new QName(((Definition)container).getTargetNamespace(), localName);
    }

    protected void extensibleElement2XML(BPELExtensibleElement extensibleElement, Element element) {
        List<ExtensibleElement> extensibilityElements;
        if (extensibleElement.getDocumentation() != null) {
            Node firstChild = element.getFirstChild();
            Element element2 = this.documentation2XML(extensibleElement.getDocumentation());
            if (firstChild == null) {
                element.appendChild(element2);
            } else {
                element.insertBefore(element2, firstChild);
            }
        }
        if (Platform.isRunning()) {
            if (this.extensibilityElementListHandlers == null) {
                this.extensibilityElementListHandlers = ExtensionFactory.INSTANCE.createHandlers("extensions_reordering");
            }
            extensibilityElements = BPELUtils.reorderExtensibilityList(this.extensibilityElementListHandlers, extensibleElement);
        } else {
            extensibilityElements = extensibleElement.getExtensibilityElements();
        }
        for (Object e : extensibilityElements) {
            javax.wsdl.extensions.ExtensibilityElement extensibilityElement = (javax.wsdl.extensions.ExtensibilityElement)e;
            BPELExtensionSerializer serializer = null;
            QName qname = extensibilityElement.getElementType();
            try {
                serializer = (BPELExtensionSerializer)this.extensionRegistry.querySerializer(BPELExtensibleElement.class, qname);
            }
            catch (WSDLException wSDLException) {
                // empty catch block
            }
            if (serializer == null) continue;
            DocumentFragment fragment = this.document.createDocumentFragment();
            try {
                serializer.marshall(BPELExtensibleElement.class, qname, extensibilityElement, fragment, this.getProcess(), this.extensionRegistry, this);
            }
            catch (WSDLException e2) {
                throw new WrappedException((Exception)((Object)e2));
            }
            Node tempElement = fragment.getFirstChild();
            if (tempElement == null) {
                return;
            }
            String nodeName = tempElement.getNodeName();
            if ((nodeName = nodeName.substring(nodeName.lastIndexOf(58) + 1)).equals("extensibilityAttributes")) {
                String elementName = tempElement.getNodeName();
                String prefix = elementName.lastIndexOf(58) != -1 ? elementName.substring(0, elementName.indexOf(58)) : null;
                NamedNodeMap attributes = tempElement.getAttributes();
                int a = 0;
                int n = attributes.getLength();
                while (a < n) {
                    Attr attr = (Attr)attributes.item(a);
                    String attrName = attr.getNodeName();
                    if (attrName.indexOf(58) == -1 && prefix != null) {
                        attrName = String.valueOf(prefix) + ':' + attrName;
                    }
                    if (attrName.startsWith("xmlns:")) {
                        String localName = attrName.substring("xmlns:".length());
                        INamespaceMap<String, String> nsMap = BPELUtils.getNamespaceMap((EObject)extensibleElement);
                        if (!nsMap.containsKey(localName) || !attr.getNodeValue().equals(nsMap.get(localName))) {
                            nsMap.put(localName, attr.getNodeValue());
                        }
                    } else {
                        element.setAttribute(attrName, attr.getNodeValue());
                    }
                    ++a;
                }
                continue;
            }
            if (element.getFirstChild() == null) {
                element.appendChild(tempElement);
                continue;
            }
            element.insertBefore(tempElement, element.getFirstChild());
        }
    }

    private Process getProcess() {
        return this.getResource().getProcess();
    }

    protected Element extensibilityElement2XML(javax.wsdl.extensions.ExtensibilityElement extensibilityElement) {
        BPELExtensionSerializer serializer = null;
        QName qname = extensibilityElement.getElementType();
        try {
            serializer = (BPELExtensionSerializer)this.extensionRegistry.querySerializer(BPELExtensibleElement.class, qname);
        }
        catch (WSDLException e) {
            return null;
        }
        DocumentFragment fragment = this.document.createDocumentFragment();
        try {
            serializer.marshall(BPELExtensibleElement.class, qname, extensibilityElement, fragment, this.getProcess(), this.extensionRegistry, this);
            Element child = this.getFirstChildElement(fragment);
            return child;
        }
        catch (WSDLException e) {
            throw new WrappedException((Exception)((Object)e));
        }
    }

    protected Element createBPELElement(String tagName) {
        List<String> prefixes;
        String namespaceURI = null;
        namespaceURI = this.getResource() != null ? this.getResource().getNamespaceURI() : BPELConstants.NAMESPACE;
        if (namespaceURI != null && !(prefixes = BPELUtils.getNamespaceMap((EObject)this.getProcess()).getReverse(namespaceURI)).isEmpty() && !prefixes.get(0).equals(EMPTY_STRING)) {
            return this.document.createElementNS(namespaceURI, String.valueOf(prefixes.get(0)) + ":" + tagName);
        }
        return this.document.createElement(tagName);
    }

    private void serializePrefixes(EObject eObject, Element context) {
        INamespaceMap<String, String> nsMap = BPELUtils.getNamespaceMap(eObject);
        if (!nsMap.isEmpty()) {
            for (Map.Entry entry : nsMap.entrySet()) {
                String prefix = (String)entry.getKey();
                String namespace = (String)entry.getValue();
                if (prefix.length() == 0) {
                    context.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespace);
                    continue;
                }
                context.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
            }
        }
    }

    private String addNewRootPrefix(String basePrefix, String namespace) {
        INamespaceMap<String, String> nsMap = BPELUtils.getNamespaceMap((EObject)this.getProcess());
        List<String> prefixes = nsMap.getReverse(namespace);
        if (prefixes.isEmpty()) {
            int i = 0;
            String prefix = basePrefix;
            while (nsMap.containsKey(prefix)) {
                prefix = String.valueOf(basePrefix) + i;
                ++i;
            }
            nsMap.put(prefix, namespace);
            return prefix;
        }
        return prefixes.get(0);
    }

    private String qNameToString(EObject eObject, QName qname) {
        EObject context = eObject;
        List<String> prefixes = null;
        String namespace = qname.getNamespaceURI();
        if (namespace == null || namespace.length() == 0) {
            return qname.getLocalPart();
        }
        if (BPELConstants.isBPELNamespace(namespace)) {
            namespace = BPELConstants.NAMESPACE;
        }
        while (context != null) {
            INamespaceMap<String, String> prefixNSMap = BPELUtils.getNamespaceMap(context);
            prefixes = prefixNSMap.getReverse(namespace);
            if (!prefixes.isEmpty()) {
                String prefix = prefixes.get(0);
                if (!prefix.equals(EMPTY_STRING)) {
                    return String.valueOf(prefix) + ":" + qname.getLocalPart();
                }
                return qname.getLocalPart();
            }
            context = context.eContainer();
        }
        return String.valueOf(this.addNewRootPrefix("ns", namespace)) + ":" + qname.getLocalPart();
    }

    private Element getFirstChildElement(DocumentFragment fragment) {
        Node child = fragment.getFirstChild();
        while (child != null && !(child instanceof Element)) {
            child = child.getNextSibling();
        }
        if (child != null) {
            return (Element)child;
        }
        throw new IllegalArgumentException("Document Fragment does not contain any Elements");
    }

    class WsdlImportsManager {
        Process fProcessContext;
        private final Map<String, String> fResourceNamespaceMap;

        WsdlImportsManager(Process process) {
            this.fProcessContext = process;
            this.fResourceNamespaceMap = new HashMap<String, String>();
            for (Object next : this.fProcessContext.getImports()) {
                Import imp = (Import)next;
                if (imp.getLocation() == null) {
                    System.err.println("Import location is unexpectedly null: " + imp);
                    continue;
                }
                URI locationURI = URI.createURI((String)imp.getLocation());
                String importPath = locationURI.resolve(BPELWriter.this.getResource().getURI()).toString();
                this.fResourceNamespaceMap.put(importPath, imp.getNamespace());
            }
        }

        void ensureImported(Resource resource, String namespace) {
            if (BPELConstants.NAMESPACE.equals(namespace)) {
                return;
            }
            String key = resource.getURI().toString();
            if (this.fResourceNamespaceMap.containsKey(key)) {
                return;
            }
            String locationURI = this.getRelativeLocation(resource.getURI());
            if (locationURI != null && locationURI.length() != 0) {
                Import _import = BPELFactory.eINSTANCE.createImport();
                _import.setNamespace(namespace);
                _import.setLocation(locationURI);
                if (resource instanceof WSDLResourceImpl) {
                    _import.setImportType("http://schemas.xmlsoap.org/wsdl/");
                } else if (resource instanceof XSDResourceImpl) {
                    _import.setImportType("http://www.w3.org/2001/XMLSchema");
                }
                this.fProcessContext.getImports().add((Object)_import);
                this.fResourceNamespaceMap.put(key, namespace);
            }
        }

        String getRelativeLocation(URI importedFileUri) {
            URI relativeURI = importedFileUri.deresolve(this.getResourceURI(), true, true, false);
            return relativeURI.toString();
        }

        URI getResourceURI() {
            return BPELWriter.this.getResource().getURI();
        }
    }
}

