/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions.breakpoints;

import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.breakpoints.ToggleBreakpointAdapter;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpoints.IToggleBreakpointsTargetCExtension;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class AddEventBreakpointActionDelegate
extends ActionDelegate
implements IViewActionDelegate,
IObjectActionDelegate {
    private IViewPart fView;
    private IWorkbenchPart fPart;
    private ISelection fSelection;
    private ToggleBreakpointAdapter fDefaultToggleTarget = new ToggleBreakpointAdapter();

    public void init(IViewPart view) {
        this.setView(view);
    }

    private void setView(IViewPart view) {
        this.fView = view;
        this.fPart = this.fView;
    }

    protected IViewPart getView() {
        return this.fView;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    public void run(IAction action) {
        IToggleBreakpointsTarget toggleTarget = DebugUITools.getToggleBreakpointsTargetManager().getToggleBreakpointsTarget(this.fPart, this.fSelection);
        IToggleBreakpointsTargetCExtension cToggleTarget = null;
        cToggleTarget = toggleTarget instanceof IToggleBreakpointsTargetCExtension ? (IToggleBreakpointsTargetCExtension)toggleTarget : this.fDefaultToggleTarget;
        try {
            cToggleTarget.createEventBreakpointsInteractive(this.fPart, this.fSelection);
        }
        catch (CoreException e) {
            CDebugUIPlugin.errorDialog(ActionMessages.getString("AddEventBreakpointActionDelegate.2"), e);
        }
    }

    protected void addEventBreakpoint(String id, String arg) {
        if (this.getResource() == null) {
            return;
        }
        try {
            CDIDebugModel.createEventBreakpoint((String)id, (String)arg, (boolean)true);
        }
        catch (CoreException ce) {
            CDebugUIPlugin.errorDialog(ActionMessages.getString("AddEventBreakpointActionDelegate.0"), ce);
        }
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPart = targetPart;
    }
}

