/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.Collection;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerImageHierarchyNode;
import org.eclipse.linuxtools.internal.docker.ui.views.CopyValueAction;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerContainersView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImageHierarchyView;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerImagesView;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class BasePropertySection
extends AbstractPropertySection {
    private TreeViewer treeViewer;
    private CopyValueAction copyAction;
    private Clipboard clipboard;
    private IPageSite pageSite;

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Object input = this.getSelection(selection);
        if (this.getTreeViewer() == null) {
            return;
        }
        if (input instanceof IDockerImageHierarchyNode) {
            this.getTreeViewer().setInput(((IDockerImageHierarchyNode)input).getElement());
        } else {
            this.getTreeViewer().setInput(input);
        }
    }

    IDockerConnection getConnection(IWorkbenchPart part, ISelection selection) {
        Object input = this.getSelection(selection);
        if (part instanceof DockerContainersView) {
            return ((DockerContainersView)part).getConnection();
        }
        if (part instanceof DockerImagesView) {
            return ((DockerImagesView)part).getConnection();
        }
        if (part instanceof DockerImageHierarchyView) {
            return ((DockerImageHierarchyView)part).getConnection();
        }
        ITreeSelection treeSelection = (ITreeSelection)selection;
        return (IDockerConnection)treeSelection.getPathsFor(input)[0].getFirstSegment();
    }

    Object getSelection(ISelection selection) {
        if (selection instanceof ITreeSelection) {
            return ((ITreeSelection)selection).getFirstElement();
        }
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage propertySheetPage) {
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)parent);
        Composite container = new Composite(parent, 0);
        container.setBackground(Display.getDefault().getSystemColor(25));
        GridLayoutFactory.fillDefaults().numColumns(1).margins(5, 5).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(400, 180).applyTo((Control)container);
        this.treeViewer = this.createTableTreeViewer(container);
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        this.clipboard = new Clipboard(Display.getCurrent());
        this.pageSite = propertySheetPage.getSite();
        this.initContextMenu(this.pageSite, this.clipboard);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(this.treeViewer.getControl());
    }

    private TreeViewer createTableTreeViewer(Composite container) {
        TreeViewer treeViewer = new TreeViewer(container, 768);
        Tree tree = treeViewer.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        TreeViewerColumn propertyColumn = new TreeViewerColumn(treeViewer, 2048);
        propertyColumn.getColumn().setWidth(150);
        propertyColumn.getColumn().setText("Property");
        propertyColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Object[]) {
                    Object property = ((Object[])element)[0];
                    return property.toString();
                }
                return super.getText(element);
            }
        });
        TreeViewerColumn valueColumn = new TreeViewerColumn(treeViewer, 2048);
        valueColumn.getColumn().setWidth(500);
        valueColumn.getColumn().setText("Value");
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Object[]) {
                    Object value = ((Object[])element)[1];
                    if (value instanceof Collection) {
                        return "";
                    }
                    if (value instanceof String || value instanceof Boolean || value instanceof Integer) {
                        return value.toString();
                    }
                    return "";
                }
                return super.getText(element);
            }
        });
        return treeViewer;
    }

    TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private void initContextMenu(IPageSite pageSite, Clipboard clipboard) {
        TreeViewer treeViewer = this.getTreeViewer();
        this.copyAction = new CopyValueAction(this.getTreeViewer(), clipboard);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.addMenuListener(manager -> this.handleMenuAboutToShow(manager));
        pageSite.registerContextMenu("org.eclipse.linuxtools.docker.ui.BaseProperySection.menuid", menuMgr, (ISelectionProvider)treeViewer);
        Menu menu = menuMgr.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(menu);
        menuMgr.add((IAction)this.copyAction);
        this.configureCopy();
    }

    private void configureCopy() {
        this.getTreeViewer().getTree().addFocusListener(new FocusListener(){
            IAction viewCopyHandler;

            public void focusLost(FocusEvent e) {
                if (this.viewCopyHandler != null) {
                    this.switchTo(this.viewCopyHandler);
                }
            }

            public void focusGained(FocusEvent e) {
                this.switchTo((IAction)BasePropertySection.this.copyAction);
            }

            private void switchTo(IAction copyAction) {
                IActionBars actionBars = BasePropertySection.this.pageSite.getActionBars();
                this.viewCopyHandler = actionBars.getGlobalActionHandler(ActionFactory.COPY.getId());
                actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), copyAction);
                actionBars.updateActionBars();
            }
        });
    }

    private void handleMenuAboutToShow(IMenuManager manager) {
        ISelection selection = this.treeViewer.getSelection();
        this.copyAction.setEnabled(!selection.isEmpty());
    }

    public void dispose() {
        super.dispose();
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
    }
}

