/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.ui.internal.launch;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.internal.launch.MavenLaunchParticipantInfo;
import org.eclipse.m2e.internal.launch.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class MavenLaunchExtensionsTab
extends AbstractLaunchConfigurationTab {
    private Set<String> disabledParticipants;
    private final List<MavenLaunchParticipantInfo> participants;
    private CheckboxTableViewer checkboxTableViewer;

    public MavenLaunchExtensionsTab(List<MavenLaunchParticipantInfo> participants) {
        this.participants = participants;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label lblMavenLaunchExtensions = new Label(composite, 0);
        lblMavenLaunchExtensions.setText(Messages.MavenLaunchExtensionsTab_lblExtensions);
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67584);
        this.checkboxTableViewer.addCheckStateListener(event -> {
            if (event.getElement() instanceof MavenLaunchParticipantInfo) {
                MavenLaunchParticipantInfo participant = (MavenLaunchParticipantInfo)event.getElement();
                if (event.getChecked()) {
                    this.disabledParticipants.remove(participant.getId());
                } else {
                    this.disabledParticipants.add(participant.getId());
                }
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        });
        Table table = this.checkboxTableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.checkboxTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return null;
            }
        });
        this.checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                if (element instanceof MavenLaunchParticipantInfo) {
                    return !MavenLaunchExtensionsTab.this.disabledParticipants.contains(((MavenLaunchParticipantInfo)element).getId());
                }
                return false;
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        this.checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof MavenLaunchParticipantInfo) {
                    return ((MavenLaunchParticipantInfo)element).getName();
                }
                return null;
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.disabledParticipants = new HashSet<String>(configuration.getAttribute("M2_DISABLED_EXTENSIONS", Collections.emptySet()));
        }
        catch (CoreException ex) {
            this.disabledParticipants = new HashSet<String>();
        }
        this.checkboxTableViewer.setInput(this.participants);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Set<String> disabledParticipants = this.disabledParticipants.isEmpty() ? null : this.disabledParticipants;
        configuration.setAttribute("M2_DISABLED_EXTENSIONS", disabledParticipants);
    }

    public String getName() {
        return Messages.MavenLaunchExtensionsTab_name;
    }
}

