/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.core.runnable.command;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStreamMonitor;
import org.eclipse.ptp.internal.rm.jaxb.control.core.ICommandJobStreamsProxy;

public class CommandJobStreamsProxy
implements ICommandJobStreamsProxy {
    private ICommandJobStreamMonitor out;
    private ICommandJobStreamMonitor err;
    private OutputStream fProcInput;
    private boolean fClosed = false;
    private boolean fStarted = false;

    @Override
    public synchronized void close() {
        if (!this.fClosed) {
            if (this.out != null) {
                this.out.close();
            }
            if (this.err != null) {
                this.err.close();
            }
            this.fClosed = true;
        }
    }

    public void closeInputStream() throws IOException {
        if (this.fProcInput != null) {
            this.fProcInput.close();
        }
    }

    public IStreamMonitor getErrorStreamMonitor() {
        return this.err;
    }

    public IStreamMonitor getOutputStreamMonitor() {
        return this.out;
    }

    @Override
    public void setErrMonitor(ICommandJobStreamMonitor err) {
        this.err = err;
    }

    @Override
    public void setOutMonitor(ICommandJobStreamMonitor out) {
        this.out = out;
    }

    @Override
    public void setInputStream(OutputStream procInput) {
        this.fProcInput = procInput;
    }

    @Override
    public synchronized void startMonitors() {
        if (!this.fClosed && !this.fStarted) {
            if (this.out != null) {
                this.out.startMonitoring();
            }
            if (this.err != null) {
                this.err.startMonitoring();
            }
            this.fStarted = true;
        }
    }

    public void write(String input) throws IOException {
        if (this.fProcInput != null) {
            this.fProcInput.write(input.getBytes());
            this.fProcInput.flush();
        }
    }
}

