/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.internal.properties;

import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.launch.core.persistence.launchcontext.LaunchContextsPersistenceDelegate;
import org.eclipse.tcf.te.launch.ui.model.LaunchNode;
import org.eclipse.tcf.te.launch.ui.nls.Messages;
import org.eclipse.tcf.te.launch.ui.properties.BaseTitledSection;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class LaunchContextPropertiesSection
extends BaseTitledSection {
    private String launchContextValue = "";
    private Text launchContext;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.launchContext = this.createTextField(null, Messages.ContextSelectorSection_label);
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof LaunchNode));
        ILaunchConfiguration node = ((LaunchNode)((Object)input)).getLaunchConfiguration();
        IModelNode[] contexts = LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchConfiguration)node);
        if (contexts != null && contexts.length > 0) {
            ILabelProvider labelProvider = (ILabelProvider)contexts[0].getAdapter(ILabelProvider.class);
            this.launchContextValue = labelProvider.getText((Object)contexts[0]);
            if (labelProvider instanceof ILabelDecorator) {
                this.launchContextValue = ((ILabelDecorator)labelProvider).decorateText(this.launchContextValue, (Object)contexts[0]);
            }
            if (contexts.length > 1) {
                this.launchContextValue = String.valueOf(this.launchContextValue) + ", ...";
            }
        } else {
            this.launchContextValue = "";
        }
    }

    @Override
    public void refresh() {
        if (this.launchContext != null) {
            this.launchContext.setText(this.launchContextValue);
        }
    }

    @Override
    protected String getText() {
        return Messages.ContextSelectorSection_title;
    }
}

