/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.wst.jsdt.chromium.JsEvaluateContext;
import org.eclipse.wst.jsdt.chromium.JsValue;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugElementImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.EvaluateContext;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ExpressionTracker;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Value;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ValueBase;
import org.eclipse.wst.jsdt.chromium.debug.ui.Messages;

public class JsWatchExpressionDelegate
implements IWatchExpressionDelegate {
    private static final String[] EMPTY_STRINGS = new String[0];

    public void evaluateExpression(final String expression, IDebugElement context, final IWatchExpressionListener listener) {
        DebugElementImpl contextImpl = (DebugElementImpl)context;
        if (!contextImpl.getDebugTarget().isSuspended()) {
            listener.watchEvaluationFinished(new IWatchExpressionResult(){

                public String[] getErrorMessages() {
                    return EMPTY_STRINGS;
                }

                public DebugException getException() {
                    return null;
                }

                public String getExpressionText() {
                    return expression;
                }

                public IValue getValue() {
                    return null;
                }

                public boolean hasErrors() {
                    return false;
                }
            });
            return;
        }
        final EvaluateContext evaluateContext = (EvaluateContext)contextImpl.getAdapter(EvaluateContext.class);
        if (evaluateContext == null) {
            listener.watchEvaluationFinished((IWatchExpressionResult)new BadWatchExpressionResult(new DebugException((IStatus)new Status(4, "org.eclipse.wst.jsdt.chromium.debug.ui", "Bad debug context")), expression));
            return;
        }
        evaluateContext.getJsEvaluateContext().evaluateAsync(expression, null, new JsEvaluateContext.EvaluateCallback(){

            public void success(JsEvaluateContext.ResultOrException result) {
                ValueBase valueBase = (ValueBase)result.accept((JsEvaluateContext.ResultOrException.Visitor)new JsEvaluateContext.ResultOrException.Visitor<ValueBase>(){

                    public ValueBase visitResult(JsValue value) {
                        return Value.create((EvaluateContext)evaluateContext, (JsValue)value, (ExpressionTracker.Node)ExpressionTracker.createExpressionNode((String)expression));
                    }

                    public ValueBase visitException(JsValue exception) {
                        return new ValueBase.ErrorMessageValue(evaluateContext, "<abnormal return>", exception);
                    }
                });
                listener.watchEvaluationFinished((IWatchExpressionResult)new GoodWatchExpressionResult(valueBase, expression));
            }

            public void failure(Exception cause) {
                String message = cause.getMessage();
                listener.watchEvaluationFinished((IWatchExpressionResult)new BadWatchExpressionResult(new DebugException((IStatus)JsWatchExpressionDelegate.createErrorStatus(message == null ? Messages.JsWatchExpressionDelegate_ErrorEvaluatingExpression : message, null)), expression));
            }
        }, null);
    }

    private static Status createErrorStatus(String message, Exception e) {
        return new Status(4, "org.eclipse.wst.jsdt.chromium.debug.core", message, (Throwable)e);
    }

    private static final class BadWatchExpressionResult
    implements IWatchExpressionResult {
        private final DebugException exception;
        private final String expressionText;

        private BadWatchExpressionResult(DebugException exception, String expressionText) {
            this.exception = exception;
            this.expressionText = expressionText;
        }

        public String[] getErrorMessages() {
            return new String[]{this.exception.getStatus().getMessage()};
        }

        public DebugException getException() {
            return this.exception;
        }

        public String getExpressionText() {
            return this.expressionText;
        }

        public IValue getValue() {
            return null;
        }

        public boolean hasErrors() {
            return true;
        }
    }

    private static final class GoodWatchExpressionResult
    implements IWatchExpressionResult {
        private final String expression;
        private final ValueBase value;

        GoodWatchExpressionResult(ValueBase value, String expression) {
            this.value = value;
            this.expression = expression;
        }

        public String[] getErrorMessages() {
            return EMPTY_STRINGS;
        }

        public DebugException getException() {
            return null;
        }

        public String getExpressionText() {
            return this.expression;
        }

        public IValue getValue() {
            return this.value;
        }

        public boolean hasErrors() {
            return false;
        }
    }
}

