/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.runtime.BaseRuntimeExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.NamespaceUtil;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.resource.Resource;

public class TypeLanguageDescriptor
extends BaseRuntimeExtensionDescriptor {
    public static final String EXTENSION_NAME = "typeLanguage";
    protected String name;
    protected String uri;
    protected String prefix;
    protected List<Type> types = new ArrayList<Type>();

    public TypeLanguageDescriptor(IConfigurationElement e) {
        super(e);
        this.name = e.getAttribute("name");
        this.uri = e.getAttribute("uri");
        this.prefix = e.getAttribute("prefix");
        IConfigurationElement[] iConfigurationElementArray = e.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement c = iConfigurationElementArray[n2];
            if ("type".equals(c.getName())) {
                Type pt = new Type(this, c.getAttribute("name"), c.getAttribute("qname"));
                this.types.add(pt);
            }
            ++n2;
        }
    }

    @Override
    public void setRuntime(TargetRuntime targetRuntime) {
        super.setRuntime(targetRuntime);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.types.clear();
    }

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri;
    }

    public List<Type> getTypes() {
        if (this.types.isEmpty() && !"org.eclipse.bpmn2.modeler.runtime.none".equals(this.getId())) {
            for (TypeLanguageDescriptor d : TargetRuntime.getDefaultRuntime().getTypeLanguageDescriptors()) {
                if (!d.name.equals(this.name)) continue;
                return d.getTypes();
            }
        }
        return this.types;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public class Type {
        TypeLanguageDescriptor typeLanguage;
        String name;
        String qname;

        public Type(TypeLanguageDescriptor typeLanguage, String name, String qname) {
            this.typeLanguage = typeLanguage;
            this.name = name;
            this.qname = qname;
        }

        public String getName() {
            return this.name;
        }

        public String getQName(Resource resource) {
            if (this.qname == null) {
                String prefix = NamespaceUtil.getPrefixForNamespace(resource, this.typeLanguage.getUri());
                if (prefix != null && !prefix.isEmpty()) {
                    return String.valueOf(prefix) + ":" + this.name;
                }
                if (this.typeLanguage.prefix != null) {
                    return String.valueOf(this.typeLanguage.prefix) + ":" + this.name;
                }
                return this.name;
            }
            return this.qname;
        }

        public TypeLanguageDescriptor getTypeLanguage() {
            return this.typeLanguage;
        }
    }
}

