/// <reference types="node" />
/*********************************************************************
 * Copyright (c) 2018 QNX Software Systems and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
import { ChildProcess } from 'child_process';
import * as events from 'events';
import { Writable } from 'stream';
import { AttachRequestArguments, LaunchRequestArguments } from './GDBDebugSession';
import { MIResponse } from './mi';
import { MIParser } from './MIParser';
import { VarManager } from './varManager';
export interface MIExecNextRequest {
    reverse?: boolean;
}
export interface MIExecNextResponse extends MIResponse {
}
export interface MIGDBShowResponse extends MIResponse {
    value?: string;
}
export declare interface GDBBackend {
    on(event: 'consoleStreamOutput', listener: (output: string, category: string) => void): this;
    on(event: 'execAsync' | 'notifyAsync' | 'statusAsync', listener: (asyncClass: string, data: any) => void): this;
    emit(event: 'consoleStreamOutput', output: string, category: string): boolean;
    emit(event: 'execAsync' | 'notifyAsync' | 'statusAsync', asyncClass: string, data: any): boolean;
}
export declare class GDBBackend extends events.EventEmitter {
    protected parser: MIParser;
    protected varMgr: VarManager;
    protected out?: Writable;
    protected token: number;
    protected proc?: ChildProcess;
    get varManager(): VarManager;
    spawn(requestArgs: LaunchRequestArguments | AttachRequestArguments): Promise<void>;
    spawnInClientTerminal(requestArgs: LaunchRequestArguments | AttachRequestArguments, cb: (args: string[]) => Promise<void>): Promise<void>;
    pause(): boolean;
    supportsNewUi(gdbPath?: string): Promise<boolean>;
    sendCommands(commands?: string[]): Promise<void>;
    sendCommand<T>(command: string): Promise<T>;
    sendEnablePrettyPrint(): Promise<unknown>;
    standardEscape(arg: string): string;
    sendFileExecAndSymbols(program: string): Promise<unknown>;
    sendFileSymbolFile(symbols: string): Promise<unknown>;
    sendAddSymbolFile(symbols: string, offset: string): Promise<unknown>;
    sendLoad(imageFileName: string, imageOffset: string | undefined): Promise<unknown>;
    sendGDBSet(params: string): Promise<unknown>;
    sendGDBShow(params: string): Promise<MIGDBShowResponse>;
    sendGDBExit(): Promise<unknown>;
    protected nextToken(): number;
}
