/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core;

import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.sqltools.core.DataTypeProvider;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.Messages;
import org.eclipse.datatools.sqltools.core.PredefinedDataTypeValidator;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.osgi.util.NLS;

public class DataTypeValidator {
    public String isValidDataTypeString(String typeString, Schema schema, int context, DatabaseIdentifier databaseIdentifier) {
        DataTypeProvider typeProvider = this.getDataTypeProvider();
        if (typeProvider == null) {
            return Messages.DataTypeValidator_no_db_definition;
        }
        DataType t = typeProvider.getDataType(typeString, schema, databaseIdentifier);
        DataType type = typeProvider.getDataType(typeString, schema, context, databaseIdentifier);
        if (type == null && t != null) {
            return NLS.bind((String)Messages.DataTypeValidator_can_not_use_in_current_context, (Object)typeString);
        }
        if (type == null && t == null) {
            return NLS.bind((String)Messages.DataTypeValidator_invalid_type, (Object)typeString);
        }
        if (type instanceof PredefinedDataType) {
            return PredefinedDataTypeValidator.isValidPredefinedType((PredefinedDataType)type, ProfileUtil.getDatabaseDefinition(this.getDatabaseVendorDefinitionId()));
        }
        return null;
    }

    public String isValidDataType(DataType dataType, Schema schema, int context, DatabaseIdentifier databaseIdentifier) {
        DataTypeProvider typeProvider = this.getDataTypeProvider();
        if (typeProvider == null) {
            return Messages.DataTypeValidator_no_db_definition;
        }
        String str = typeProvider.getDataTypeString(dataType, false);
        return this.isValidDataTypeString(str, schema, context, databaseIdentifier);
    }

    protected DatabaseVendorDefinitionId getDatabaseVendorDefinitionId() {
        return null;
    }

    protected DataTypeProvider getDataTypeProvider() {
        DatabaseVendorDefinitionId id = this.getDatabaseVendorDefinitionId();
        if (id == null) {
            return null;
        }
        SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByVendorIdentifier(id);
        if (config == null) {
            return null;
        }
        return config.getSQLDataService().getDataTypeProvider();
    }
}

