/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.editor;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtend.shared.ui.Activator;

public class MarkerHandler {
    protected static final String MARKER_ID = String.valueOf(Activator.getId()) + ".problem";

    void deleteMarkers(final IResource resource, IProgressMonitor monitor) {
        this.checkResource(resource);
        this.run(new WorkspaceModifyOperation(ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(resource)){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                resource.deleteMarkers(MARKER_ID, true, 2);
            }
        }, monitor);
    }

    private void checkResource(IResource resource) {
        Assert.isLegal((resource != null ? 1 : 0) != 0);
        Assert.isLegal((boolean)resource.exists(), (String)("Can't handle Marker for a non existing resource '" + resource.getFullPath() + "'"));
        Assert.isLegal((!resource.getResourceAttributes().isReadOnly() ? 1 : 0) != 0, (String)("Can't handle Marker for read only resource'" + resource.getFullPath() + "'"));
    }

    private void run(WorkspaceModifyOperation workspaceModifyOperation, IProgressMonitor monitor) {
        try {
            workspaceModifyOperation.run(monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void addMarker(final IFile file, final String message, final int severity, final String location) {
        this.checkResource((IResource)file);
        this.run(new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                try {
                    IMarker marker = file.createMarker(MARKER_ID);
                    marker.setAttribute("message", (Object)message);
                    int status = 0;
                    switch (severity) {
                        case 3: {
                            status = 2;
                            break;
                        }
                        case 2: {
                            status = 1;
                        }
                    }
                    marker.setAttribute("severity", status);
                    if (location != null) {
                        marker.setAttribute("location", (Object)location);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }
}

