/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public final class TypeTools {
    public static final String SERIALIZABLE_NAME = Serializable.class.getName();
    public static final Predicate<IType> IS_CLASS = new IsClass();
    public static final Predicate<IType> IS_INTERFACE = new IsInterface();
    public static final Predicate<IType> IS_ENUM = new IsEnum();
    public static final IType[] EMPTY_ARRAY = new IType[0];
    public static final Transformer<IType, String> NAME_TRANSFORMER = new NameTransformer();

    public static boolean isSubTypeOf(String typeName, String possibleSuperTypeName, IJavaProject javaProject) {
        try {
            return TypeTools.isSubTypeOf_(javaProject.findType(typeName), javaProject.findType(possibleSuperTypeName));
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    public static boolean isSubTypeOf(IType type, String possibleSuperTypeName) {
        try {
            return TypeTools.isSubTypeOf_(type, possibleSuperTypeName);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    private static boolean isSubTypeOf_(IType type, String possibleSuperTypeName) throws JavaModelException {
        return TypeTools.isSubTypeOf_(type, type.getJavaProject().findType(possibleSuperTypeName));
    }

    private static boolean isSubTypeOf_(IType type, IType possibleSuperType) throws JavaModelException {
        if (type == null) {
            return false;
        }
        HashSet<String> visitedTypeNames = new HashSet<String>();
        visitedTypeNames.add(type.getFullyQualifiedName());
        return TypeTools.isSubTypeOf_(type, possibleSuperType, visitedTypeNames);
    }

    private static boolean isSubTypeOf_(IType type, IType possibleSuperType, HashSet<String> visitedTypeNames) throws JavaModelException {
        if (type == null || possibleSuperType == null) {
            return false;
        }
        if (type.equals(possibleSuperType)) {
            return true;
        }
        IJavaProject javaProject = type.getJavaProject();
        if (javaProject.findType(Object.class.getName()).equals(possibleSuperType)) {
            return true;
        }
        String possibleSuperTypeName = possibleSuperType.getFullyQualifiedName();
        for (String superTypeName : TypeTools.getResolvedSuperTypeNames(type)) {
            if (superTypeName == null || visitedTypeNames.contains(superTypeName)) continue;
            visitedTypeNames.add(superTypeName);
            if (superTypeName.equals(possibleSuperTypeName)) {
                return true;
            }
            if (!TypeTools.isSubTypeOf_(javaProject.findType(superTypeName), possibleSuperType, visitedTypeNames)) continue;
            return true;
        }
        return false;
    }

    private static Iterable<String> getResolvedSuperTypeNames(IType type) throws JavaModelException {
        Iterable<String> nonResolvedSuperTypeNames = TypeTools.getNonResolvedSuperTypeNames(type);
        if (type.isBinary()) {
            return nonResolvedSuperTypeNames;
        }
        ArrayList<String> resolvedSuperTypeNames = new ArrayList<String>();
        for (String superTypeName : nonResolvedSuperTypeNames) {
            resolvedSuperTypeNames.add(TypeTools.resolveType_(type, superTypeName));
        }
        return resolvedSuperTypeNames;
    }

    private static Iterable<String> getNonResolvedSuperTypeNames(IType type) throws JavaModelException {
        String superclassName = type.getSuperclassName();
        Iterable superInterfaceNames = IterableTools.iterable((Object[])type.getSuperInterfaceNames());
        return superclassName == null ? superInterfaceNames : IterableTools.add((Iterable)superInterfaceNames, (Object)superclassName);
    }

    private static String resolveType_(IType type, String typeName) throws JavaModelException {
        String[][] resolvedClassNames = type.resolveType(typeName);
        if (resolvedClassNames == null) {
            return null;
        }
        String pkg = resolvedClassNames[0][0];
        String cls = resolvedClassNames[0][1];
        return pkg.length() == 0 ? cls : String.valueOf(pkg) + '.' + cls;
    }

    public static String resolveType(IType type, String typeName) {
        try {
            return TypeTools.resolveType_(type, typeName);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return null;
        }
    }

    public static boolean isSerializable(IType type) {
        return TypeTools.isSubTypeOf(type, SERIALIZABLE_NAME);
    }

    public static boolean isSerializable(String typeName, IJavaProject javaProject) {
        return TypeTools.isSubTypeOf(typeName, SERIALIZABLE_NAME, javaProject);
    }

    public static boolean hasPublicZeroArgConstructor(String typeName, IJavaProject javaProject) {
        IType type;
        if (javaProject != null && typeName != null && (type = JavaProjectTools.findType(javaProject, typeName)) != null) {
            return TypeTools.hasPublicZeroArgConstructor(type);
        }
        return false;
    }

    public static boolean hasPublicZeroArgConstructor(IType type) {
        try {
            return TypeTools.hasPublicZeroArgConstructor_(type);
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    private static boolean hasPublicZeroArgConstructor_(IType type) throws JavaModelException {
        boolean ctorDefined = false;
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.isConstructor()) {
                if (method.getNumberOfParameters() == 0 && Flags.isPublic((int)method.getFlags())) {
                    return true;
                }
                ctorDefined = true;
            }
            ++n2;
        }
        return !ctorDefined;
    }

    public static boolean isClass(IType type) {
        try {
            return type.isClass();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    public static boolean isInterface(IType type) {
        try {
            return type.isInterface();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    public static boolean isEnum(IType type) {
        try {
            return type.isEnum();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    public static IType[] getTypes(IType type) {
        try {
            return type.getTypes();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return EMPTY_ARRAY;
        }
    }

    private TypeTools() {
        throw new UnsupportedOperationException();
    }

    public static class IsClass
    extends PredicateAdapter<IType> {
        public boolean evaluate(IType type) {
            return TypeTools.isClass(type);
        }
    }

    public static class IsEnum
    extends PredicateAdapter<IType> {
        public boolean evaluate(IType type) {
            return TypeTools.isEnum(type);
        }
    }

    public static class IsInterface
    extends PredicateAdapter<IType> {
        public boolean evaluate(IType type) {
            return TypeTools.isInterface(type);
        }
    }

    public static class NameTransformer
    extends TransformerAdapter<IType, String> {
        public String transform(IType type) {
            return type.getFullyQualifiedName();
        }
    }
}

