/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.command;

import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class SafeCommandWrapper
implements Command {
    private final Command command;
    private final ExceptionHandler exceptionHandler;

    public SafeCommandWrapper(Command command, ExceptionHandler exceptionHandler) {
        if (command == null || exceptionHandler == null) {
            throw new NullPointerException();
        }
        this.command = command;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void execute() {
        try {
            this.command.execute();
        }
        catch (Throwable ex) {
            this.exceptionHandler.handleException(ex);
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.command);
    }
}

