/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.core;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.libra.framework.core.OSGIFrameworkInstanceBehaviorDelegate;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.wst.server.core.IServer;

public class PingThread {
    private static final int PING_DELAY = 2000;
    private static final int PING_INTERVAL = 250;
    private int maxPings;
    private boolean stop = false;
    private String url;
    private IServer server;
    private ILaunch launch;
    private OSGIFrameworkInstanceBehaviorDelegate behaviour;

    public PingThread(ILaunch launch, IServer server, String url, int maxPings, OSGIFrameworkInstanceBehaviorDelegate behaviour) {
        this.server = server;
        this.url = url;
        this.maxPings = maxPings;
        this.behaviour = behaviour;
        this.launch = launch;
        Thread t = new Thread("OSGi Framework Launchers Ping Thread"){

            public void run() {
                PingThread.this.ping();
            }
        };
        t.setDaemon(true);
        t.start();
    }

    protected void ping() {
        int count = 0;
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        while (!this.stop) {
            try {
                if (count == this.maxPings) {
                    try {
                        this.server.stop(false);
                    }
                    catch (Exception exception) {
                        Trace.trace((byte)3, "Ping: could not stop server");
                    }
                    this.stop();
                    break;
                }
                ++count;
                if (this.launch.isTerminated()) {
                    this.behaviour.stop(true);
                    this.server.stop(true);
                    this.stop = true;
                    break;
                }
                Trace.trace((byte)3, "Ping: pinging " + count);
                IProcess[] procs = this.launch.getProcesses();
                if (procs == null || procs.length <= 0 || procs[0].isTerminated()) continue;
                this.behaviour.setServerStarted();
                this.stop();
                break;
            }
            catch (Exception exception) {
                Trace.trace((byte)3, "Ping: failed");
                if (this.stop) continue;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.stop = true;
    }

    public void stop() {
        Trace.trace((byte)3, "Ping: stopping");
        this.stop = true;
    }
}

