/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.ui.overview;

import java.util.Map;
import org.eclipse.libra.framework.editor.core.model.IBundle;
import org.eclipse.libra.framework.editor.ui.internal.AbstractBundleEditorPage;
import org.eclipse.libra.framework.editor.ui.internal.overview.BundleInformationMasterDetailsBlock;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPartInput;
import org.eclipse.wst.server.ui.internal.editor.ServerResourceCommandManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleInformationEditorPage
extends AbstractBundleEditorPage {
    private BundleInformationMasterDetailsBlock masterDetailsBlock;
    private ServerResourceCommandManager commandManager;

    @Override
    protected void createBundleContent(Composite parent) {
        if (this.mform == null) {
            this.mform = new ManagedForm(parent);
        }
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        this.sform = this.mform.getForm();
        this.sform.getForm().setSeparatorVisible(true);
        this.sform.getForm().setText("Bundle Information");
        this.sform.setExpandHorizontal(true);
        this.sform.setExpandVertical(true);
        this.sform.setImage(ServerUICore.getLabelProvider().getImage((Object)this.getServer()));
        toolkit.decorateFormHeading(this.sform.getForm());
        this.masterDetailsBlock = new BundleInformationMasterDetailsBlock(this, (MultiPageEditorPart)this.commandManager.getServerEditor(), this.getServer().getOriginal());
        this.masterDetailsBlock.createContent((IManagedForm)this.mform);
    }

    @Override
    protected void enablePage() {
        super.enablePage();
        this.setInfoStatus("Click the 'Refresh' button for fetching data from server.");
        this.masterDetailsBlock.refresh();
    }

    @Override
    protected void disablePage() {
        super.disablePage();
        this.masterDetailsBlock.clear();
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.commandManager = ((ServerEditorPartInput)input).getServerCommandManager();
    }

    public void showOverviewForBundle(IBundle bundle) {
        this.masterDetailsBlock.setSelectedBundle(bundle);
    }

    public void refresh(Map<Long, IBundle> bundles) {
        this.masterDetailsBlock.refresh(bundles);
    }
}

